---
name: Demonstrações & Exemplos
permalink: '/about/demos-examples'
---

# Demonstrações & Exemplos

Essa página lista diversos <i>demos</i> e exemplos que você pode utilizar para aprender Preact.


> :information_desk_person: _Criou algo com Preact?
> [Adicione aqui!](https://github.com/preactjs/preact-www/blob/master/content/pt-br/about/demos-examples.md)_


## Aplicações completos

[**Webiste do Preact ** _(preactjs.com)_](https://preactjs.com)
Logicamente, esse <i>website</i> é construído com Preact.
[Github Project](https://github.com/preactjs/preact-www)

**[ESBench](http://esbench.com)** :alarm_clock:
Construído com Preact & Material Design Lite.

[**GuriVR**](https://gurivr.com) :eyeglasses:
Criador de histórias Web VR baseado em linguagens naturais.
_([Github Project](https://github.com/opennewslabs/guri-vr))_

[**BigWebQuiz**](https://bigwebquiz.com) :game_die:
O <i>Progressive Web App</i> para participação do público na Chrome Dev Summit 2016!
([Github Project](https://github.com/jakearchibald/big-web-quiz))

**[Nectarine.rocks](http://nectarine.rocks)** :peach:  
Uma aplicação similar ao 'peach.cool' de código aberto!  
[Github Project](https://github.com/developit/nectarine)

**[Dropfox](https://github.com/developit/dropfox)** :wolf:
Aplicação desktop para Dropbox, criado com Preact, Electron e Photon.

**[Connectivity Index](https://cindex.co)** :iphone:  
Um site que permite que você pesquise através dos  [dados de conectividade Akamai](https://content.akamai.com/PG7010-Q2-2016-SOTI-Connectivity-Report.html) por país.

**[Drag & Drop file upload (webpack 2)](https://contentful-labs.github.io/file-upload-example/)** :rocket:
Desktop App for uploading assets to Contentful (API based CMS)
Aplicativo de Desktop para upload de assets para o Contentful (CMS com base em API)
[Github Project](https://github.com/contentful-labs/file-upload-example)

**[ColoGuessr](https://cologuessr.com)** :rainbow:
Teste o quão bem você conhece suas cores
[Github Project](https://github.com/jackpordi/cologuessr)

## Demos completos & Exemplos

**[Documentation Viewer](https://documentation-viewer.firebaseapp.com)**  
Visualize o <i>output</i> do documentation.js online.
[Github Project](https://github.com/developit/documentation-viewer)

**[TodoMVC](http://developit.github.io/preact-todomvc/)**  
A mais rápida implementação (não-oficial) do TodoMVC.
[Github Project](https://github.com/developit/preact-todomvc)

**[TodoMVC+PouchDB](http://katopz.github.io/preact-todomvc-pouchdb/)** :floppy_disk:  
TodoMVC com sincronização offline, com [PouchDB](https://pouchdb.com/).  
[Github Project](https://github.com/katopz/preact-todomvc-pouchdb)

**[Hacker News Minimal](https://developit.github.io/hn_minimal/)** :newspaper:  
Pequeno cliente do HackerNews.
[Github Project](https://github.com/developit/hn_minimal)

**[Preact Boilerplate](https://preact-boilerplate.surge.sh)** :zap:
Iniciador de projetos Preact com 2 comandos. Preact + Webpack + LESS + CSS Modules.
[Github Project](https://github.com/developit/preact-boilerplate)

**[Preact Redux Example](https://preact-redux-example.surge.sh)** :repeat:  
Projeto exemplo com Preact + Redux, implementando uma <i>To-Do list</i> simples.
[Github Project](https://github.com/developit/preact-redux-example)

**[Preact Without Babel](https://github.com/developit/preact-without-babel)** :horse:  
Como usar Preact inteiramente sem Babel, ES2015 ou JSX.

**[preact-minimal](https://github.com/aganglada/preact-minimal)** :rocket:  
Estrutura minimalista do Preact com todas as ferramentas necessárias para iniciar o seu projeto imediatamente.

## Codepens

- [Navegador do Flickr](http://codepen.io/developit/full/VvMZwK/) _(@ CodePen)_
- [Texto Animado](http://codepen.io/developit/full/LpNOdm/) _(@ CodePen)_
- [Arcoíris espiral a 60FPS](http://codepen.io/developit/full/xGoagz/) _(@ CodePen)_
- [Relógio Simples](http://jsfiddle.net/developit/u9m5x0L7/embedded/result,js/) _(@ JSFiddle)_
- [3D + ThreeJS](http://codepen.io/developit/pen/PPMNjd?editors=0010) _(@ CodePen)_

## Templates

:zap: [**JSFiddle Template**](https://jsfiddle.net/developit/rs6zrh5f/embedded/result/)

:zap: [**CodePen Template**](http://codepen.io/developit/pen/pgaROe?editors=0010)
