
---
name: 라이브러리 & 애드온
permalink: '/about/addons-libraries'
description: 'Preact와 훌륭하게 동작하는 라이브러리와 애드온 모음'
---

# 라이브러리 & 애드온

Preact와 훌륭하게 동작하는 모듈 모음입니다.

> :information_desk_person: _직접 만드셨나요?
> [추가하기!](https://github.com/preactjs/preact-www/blob/master/content/en/about/libraries-addons.md)_

## 애드온

- :repeat: [**preact-cycle**](https://github.com/developit/preact-cycle): Preact를 위한 함수형 반응형 패러다임
- :page_facing_up: [**preact-render-to-string**](https://github.com/preactjs/preact-render-to-string): Universal 렌더링
- :timer_clock: [**relaks**](https://github.com/trambarhq/relaks): 비동기적으로 반환하는 렌더 메서드를 가진 컴포넌트 생성
- :nut_and_bolt: [**express-preact-views**](https://github.com/edwjusti/express-preact-views): Express 뷰 엔진
- :floppy_disk: [**Prefresh**](https://github.com/JoviDeCroock/prefresh): Preact를 위한 빠른 새로고침
- :bookmark_tabs: [**adonis-preact**](https://github.com/DonsWayo/adonis-preact): Adonisjs에서 Preact 사용

## 컴포넌트

- :earth_americas: [**preact-router**](https://github.com/preactjs/preact-router): 컴포넌트를 위한 URL 라우팅
- :bookmark_tabs: [**preact-markup**](https://github.com/developit/preact-markup): HTML 및 커스텀 엘리먼트를 JSX와 컴포넌트로 렌더링
- :satellite: [**preact-portal**](https://github.com/developit/preact-portal): Preact 컴포넌트를 임의의 공간에 렌더링 :milky_way:
- :pencil: [**preact-richtextarea**](https://github.com/developit/preact-richtextarea): 간단한 HTML 편집기 컴포넌트
- :bookmark: [**preact-token-input**](https://github.com/developit/preact-token-input): 태그와 같은 것을 위한 입력을 토큰화하는 텍스트 필드
- :card_index: [**preact-virtual-list**](https://github.com/developit/preact-virtual-list): 수백만 개의 행이 있는 목록을 쉽게 렌더링 ([데모](https://jsfiddle.net/developit/qqan9pdo/))
- :triangular_ruler: [**preact-layout**](https://download.github.io/preact-layout/): 작고 간단한 레이아웃 라이브러리
- :construction_worker: [**preact-helmet**](https://github.com/download/preact-helmet): Preact를 위한 문서 head 관리자
- :arrow_up_down: [**preact-custom-scrollbars**](https://github.com/lucafalasco/preact-custom-scrollbars): 완전하게 커스텀 가능한 스크롤바(네이티브 브라우저 스크롤링 원활하게 지원)
- 🧱 [**@modular-forms/preact**](https://modularforms.dev/): 모듈화되고 타입에 안전한 폼 라이브러리

## 통합

- :thought_balloon: [**preact-socrates**](https://github.com/matthewmueller/preact-socrates): [Socrates](http://github.com/matthewmueller/socrates)를 위한 Preact 플러그인
- :rowboat: [**preact-flyd**](https://github.com/xialvjun/preact-flyd): Preact + JSX에서 [flyd](https://github.com/paldepind/flyd) FRP 스트림 사용
- :speech_balloon: [**preact-i18nline**](https://github.com/download/preact-i18nline): [i18n-js](https://github.com/everydayhero/i18n-js) 주변의 생태계를 [i18nline](https://github.com/download/i18nline)을 통해 Preact와 통합합니다.
- :diamond_shape_with_a_dot_inside: [**Capacitor**](https://capacitorjs.com/solution/preact): Preact 앱을 네이티브 iOS/Android 앱 및 PWA로 변환
- :ice_cube: [**Kretes**](https://kretes.dev/docs/howtos/preact-setup/): Preact 및 Node.js를 사용하여 풀스택 TypeScript 앱 빌드
- 🏝: [**preact-island**](https://github.com/mwood23/preact-island): 반응적인 Props를 통해 어떤 웹사이트에서든 Preact 위젯 실행

## GUI 툴킷

- 🎴 [**@mui/material**](https://github.com/mui/material-ui/tree/master/examples/material-ui-preact): 여러분이 늘 원하던 React UI 라이브러리. 자체 디자인 시스템을 따르거나, Material Design으로 시작하세요.
- :thumbsup: [**preact-material-components**](https://github.com/prateekbh/preact-material-components): 웹을 위한 Material 컴포넌트 (MDL 대용)
- :white_square_button: [**preact-mdl**](https://github.com/developit/preact-mdl): Preact 컴포넌트로 [MDL](https://getmdl.io) 사용
- :rocket: [**preact-photon**](https://github.com/developit/preact-photon): [photon](http://photonkit.com)으로 아름다운 데스크톱 UI 빌드
- :penguin: [**preact-weui**](https://github.com/afeiship/preact-weui): Preact용 [Weui](https://github.com/afeiship/preact-weui)
- 💅 [**preact-fluid**](https://github.com/ajainvivek/preact-fluid): Preact용 [Fluid](https://github.com/ajainvivek/preact-fluid) 미니멀 UI 킷
- :book: [**storybook-preact**](https://github.com/storybooks/storybook/tree/next/app/preact): Preact 컴포너트를 위한 UI 개발 환경인 Storybook

## 테스트

- :microscope: [**preact-jsx-chai**](https://github.com/developit/preact-jsx-chai): JSX assertion 테스트 _(DOM 없이 Node에서 진행)_
- :white_check_mark: [**unexpected-preact**](https://github.com/bruderstein/unexpected-preact): JSX assertions, 이벤트, Jest에서 스냅샷 _(DOM, Node jsdom 아래에서 동작하거나 Jest에서 기본적으로 작동)_ - [docs](https://bruderstein.github.io/unexpected-preact/)

## 유틸리티

- :tophat: [**preact-classless-component**](https://github.com/ld0rman/preact-classless-component): class 키워드 없이 Preact 컴포넌트 생성
- :hammer: [**preact-hyperscript**](https://github.com/queckezz/preact-hyperscript): 엘리먼트 생성을 위한 Hyperscript와 같은 문법
- :white_check_mark: [**shallow-compare**](https://github.com/tkh44/shallow-compare): 단순화된 `shouldComponentUpdate` 헬퍼
- :signal_strength: [**@deepsignal/preact**](https://github.com/EthanStandel/deepsignal/tree/main/packages/preact): 전체 상태 관리를 위한 `@preact/signals`의 확장
