---
name: 데모 & 예제
permalink: '/about/demos-examples'
description: 'Preact 데모 & 예제 애플리케이션 모음'
---

# 데모 & 예제

이 페이지는 Preact를 학습하는 데 사용할 수 있는 다양한 데모와 예제를 제공합니다.

> :information_desk_person: _직접 만드셨나요?
> [추가하기!](https://github.com/preactjs/preact-www/blob/master/content/en/about/demos-examples.md)_


## 완전한 앱

[**Preact Website** _(preactjs.com)_](https://preactjs.com)  
물론 이 웹사이트는 Preact로 만들어졌습니다.  
[Github Project](https://github.com/preactjs/preact-www)

**[ESBench](http://esbench.com)** :alarm_clock:  
Preact & Material Design Lite로 만들어진 웹사이트입니다.

[**GuriVR**](https://gurivr.com) :eyeglasses:  
자연어 기반의 Web VR 스토리 크리에이터  
[Github Project](https://github.com/opennewslabs/guri-vr)

[**BigWebQuiz**](https://bigwebquiz.com) :game_die:  
Chrome Dev Summit 2016의 관중 참여형 점진적 웹 앱!  
[Github Project](https://github.com/jakearchibald/big-web-quiz)

**[Nectarine.rocks](http://nectarine.rocks)** :peach:  
오픈 소스 peach.cool 앱  
[Github Project](https://github.com/developit/nectarine)

**[Web Maker](https://webmaker.app/)** :zap:  
매우 빠른 오프라인 프런트엔드 플레이그라운드  
[Github Project](https://github.com/chinchang/web-maker)

**[BitMidi](https://bitmidi.com/)** :musical_keyboard:  
무료 MIDI 파일을 위한 웨이백 머신  
[Github Project](https://github.com/feross/bitmidi.com)

**[BBC Roasting Calculator](https://www.bbc.com/food/techniques/articles/roast-calculator)** :turkey:  
다양한 고기 부위에 대한 조리 시간을 계산합니다.

**[Dropfox](https://github.com/developit/dropfox)** :wolf:  
Preact, Electron 및 Photon으로 만든 Dropbox용 데스크톱 앱

**[Embed Hacker News](https://github.com/TXTPEN/hn)** :kissing_closed_eyes:  
블로그 글 아래에 Hacker News 코멘트 트리를 삽입합니다.

**[Connectivity Index](https://cindex.co)** :iphone:  
[Akamai 인터넷 상태 보고서](https://content.akamai.com/PG7010-Q2-2016-SOTI-Connectivity-Report.html) 데이터를 국가별로 검색할 수 있는 웹사이트

**[Drag & Drop file upload (webpack 2)](https://contentful-labs.github.io/file-upload-example/)** :rocket:  
Contentful에 애셋을 업로드하는 데 사용되는 데스크톱 앱 (API 기반 CMS)  
[Github Project](https://github.com/contentful-labs/file-upload-example)

**[Exchange Widget](https://sgtpep.github.io/exchange-widget/dist/)** :currency_exchange:  
인기 있는 모바일 앱에서 영감을 받은 화폐 환율 위젯을 Preact, Meiosis, HTML 태그 템플릿 및 기본 ES 모듈을 사용해 구현합니다.  
[Github Project](https://github.com/sgtpep/exchange-widget)

**[Blaze](https://blaze.now.sh)** :zap:  
모던 P2P 파일 공유 점진적 웹 앱  
[Github Project](https://github.com/blenderskool/blaze)

**[1tuner](https://1tuner.com)** :radio:  
라디오와 팟캐스트를 청취할 수 있는 웹사이트  
[Github Project](https://github.com/robinbakker/1tuner)

## 완전한 데모 & 예제

**[Documentation Viewer](https://documentation-viewer.firebaseapp.com)**  
documentation.js 출력물을 온라인에서 확인합니다.  
[Github Project](https://github.com/developit/documentation-viewer)

**[TodoMVC](http://developit.github.io/preact-todomvc/)**  
비공식이지만 가장 빠른 TodoMVC 구현입니다.  
[Github Project](https://github.com/developit/preact-todomvc)

**[TodoMVC+PouchDB](http://katopz.github.io/preact-todomvc-pouchdb/)** :floppy_disk:  
[PouchDB](https://pouchdb.com/)를 사용한 오프라인 동기화 TodoMVC  
[Github Project](https://github.com/katopz/preact-todomvc-pouchdb)

**[Hacker News Minimal](https://developit.github.io/hn_minimal/)** :newspaper:  
작은 해커 뉴스 클라이언트  
[Github Project](https://github.com/developit/hn_minimal)

**[Preact Boilerplate](https://preact-boilerplate.surge.sh)** :zap:  
두 개의 명령으로 시작하는 프로젝트. Preact + Webpack + LESS + CSS Modules  
[Github Project](https://github.com/developit/preact-boilerplate)

**[Preact Offline Starter](https://preact-starter.now.sh)** :100:  
점진적 웹 앱을 위한 Webpack2 스타터의 간소화된 버전. 오프라인 지원 포함  
[Github Project](https://github.com/lukeed/preact-starter)

**[Preact Redux Example](https://preact-redux-example.surge.sh)** :repeat:  
간단한 To-Do 리스트를 구현한 Preact + Redux 예제 프로젝트  
[Github Project](https://github.com/developit/preact-redux-example)

**[Preact Without Babel](https://github.com/developit/preact-without-babel)** :horse:  
Babel, ES2015 또는 JSX 없이 Preact를 사용하는 방법

**[preact-minimal](https://github.com/aganglada/preact-minimal)** :rocket:  
프로젝트를 즉시 시작할 수 있는 최소한의 도구가 갖춰져 있는 Preact 구조

**[preact-typescript-webpack4-less](https://github.com/lexey111/preact-typescript-webpack4-boilerplate)**  
Preact, Typescript 및 Webpack4를 사용하여 최소한의 설정으로 시작하는 프로젝트

**[Preact Homepage Generator](https://thomaswood.me/)** :globe_with_meridians:  
JSON 데이터만 수정하여 새로운 개인 웹페이지를 빠르게 만듭니다.  
[Github Project](https://github.com/tomasswood/preact-homepage-generator)

**[Parcel + Preact + Unistore Starter](https://github.com/hwclass/parcel-preact-unistore-starter)**  
프로토타이핑 및 소규모/중규모 프로젝트 구조를 위한 스타터 팩

**[buildless-preact-starter](https://github.com/ttntm/buildless-preact-starter)** :rocket:  
빌드 없이 Preact를 사용하는 환경을 위한 스타터 템플릿

## Codepens

- [Flickr Browser](http://codepen.io/developit/full/VvMZwK/) _(@ CodePen)_
- [Animating Text](http://codepen.io/developit/full/LpNOdm/) _(@ CodePen)_
- [60FPS Rainbow Spiral](http://codepen.io/developit/full/xGoagz/) _(@ CodePen)_
- [Simple Clock](http://jsfiddle.net/developit/u9m5x0L7/embedded/result,js/) _(@ JSFiddle)_
- [3D + ThreeJS](http://codepen.io/developit/pen/PPMNjd?editors=0010) _(@ CodePen)_

## 템플릿

:zap: [**JSFiddle 템플릿**](https://jsfiddle.net/developit/rs6zrh5f/embedded/result/)

:zap: [**CodePen 템플릿**](http://codepen.io/developit/pen/pgaROe?editors=0010)
