---
name: Bibliothèques et modules complémentaires
permalink: '/about/addons-libraries'
---

# Bibliothèques et modules complémentaires

Une liste de modules construit pour fonctionner parfaitement avec Preact.

> :information_desk_person: _Vous avez construit le vôtre ?
> [ajoutez-le !](https://github.com/preactjs/preact-www/blob/master/content/fr/about/libraries-addons.md)_


### Modules complémentaires

- :raised_hands: [**preact-compat**](https://github.com/preactjs/preact-compat): utilisez n'importe quelle bibliothèque créée pour React avec Preact *([full example](https://github.com/developit/preact-compat-example))*
- :repeat: [**preact-cycle**](https://github.com/developit/preact-cycle): Le paradigme de programmation fonctionnelle réactive pour Preact
- :page_facing_up: [**preact-render-to-string**](https://github.com/preactjs/preact-render-to-string): Rendu universel.


### Composants

- :earth_americas: [**preact-router**](https://github.com/preactjs/preact-router): Un routeur d'URL pour vos composants
- :bookmark_tabs: [**preact-markup**](https://github.com/developit/preact-markup): Affichez du HTML et des Custom Elements comme du JSX et des composants
- :satellite: [**preact-portal**](https://github.com/developit/preact-portal): Affichez des composants Preact dans l'ESPACE :milky_way:
- :pencil: [**preact-richtextarea**](https://github.com/developit/preact-richtextarea): Un composant d'éditeur HTML simple
- :bookmark: [**preact-token-input**](https://github.com/developit/preact-token-input): Un champ de texte qui transforme son contenu en tokens, pour créer un système de tags, par exemple
- :card_index: [**preact-virtual-list**](https://github.com/developit/preact-virtual-list): Affichez facilement des listes de plusieurs millions de lignes ([demo](https://jsfiddle.net/developit/qqan9pdo/))
- :triangular_ruler: [**preact-layout**](https://download.github.io/preact-layout/): Une bibliothèque de mise en page légère et simple d'utilisation
- :construction_worker: [**preact-helmet**](https://github.com/download/preact-helmet): Une bibliothèque pour Preact permettant de gérer le head d'un document


### Intégrations

- :thought_balloon: [**preact-socrates**](https://github.com/matthewmueller/preact-socrates): Un module Preact pour [Socrates](http://github.com/matthewmueller/socrates)
- :rowboat: [**preact-flyd**](https://github.com/xialvjun/preact-flyd): Utilisez les flux FRP de [flyd](https://github.com/paldepind/flyd) avec Preact et JSX
- :speech_balloon: [**preact-i18nline**](https://github.com/download/preact-i18nline): Intègre l'écosystème autour de [i18n-js](https://github.com/everydayhero/i18n-js) avec Preact via [i18nline](https://github.com/download/i18nline).


### Outils pour créer des interfaces graphiques

- :white_square_button: [**preact-mdl**](https://github.com/developit/preact-mdl): Utilisez [MDL](https://getmdl.io) comme des composants Preact
- :rocket: [**preact-photon**](https://github.com/developit/preact-photon): créez de belles interfaces utilisateurs pour bureau avec [photon](http://photonkit.com)


### Tests

- :microscope: [**preact-jsx-chai**](https://github.com/developit/preact-jsx-chai): Test d'assertions en JSX _(pas de DOM, directement dans Node)_
- :white_check_mark: [**unexpected-preact**](https://github.com/bruderstein/unexpected-preact): Assertions, événements, snapshots en JSX dans Jest _(DOM, fonctionne avec le module Node jsdom ou directement avec Jest)_ - [docs](https://bruderstein.github.io/unexpected-preact/)


### Utilitaires

- :tophat: [**preact-classless-component**](https://github.com/ld0rman/preact-classless-component): Créez des composants Preact sans le mot-clé class
- :hammer: [**preact-hyperscript**](https://github.com/queckezz/preact-hyperscript): Une syntaxe ressemblant à celle d'Hyperscript pour créer des éléments
- :white_check_mark: [**shallow-compare**](https://github.com/tkh44/shallow-compare): Un assistant simplifié pour `shouldComponentUpdate`.
