---
name: Démos et Exemples
permalink: '/about/demos-examples'
---

# Démos et Exemples

Cette page liste un certain nombre de démos et d'exemples utiles pour apprendre Preact.

> :information_desk_person: _Vous avez écrit le/la vôtre ?
> [Ajoutez le/la!](https://github.com/preactjs/preact-www/blob/master/content/fr/about/demos-examples.md)_


## Applications complètes

[**Site web de Preact** _(preactjs.com)_](https://preactjs.com)  
Bien sûr ce site web est construit avec Preact.
[Projet Github](https://github.com/preactjs/preact-www)

**[ESBench](http://esbench.com)** :alarm_clock:  
Construit avec Preact et Material Design Lite.

[**GuriVR**](https://gurivr.com) :eyeglasses:
Créateur d'histoires Web VR basé sur le langage naturel.
_([Projet Github](https://github.com/opennewslabs/guri-vr))_

[**BigWebQuiz**](https://bigwebquiz.com) :game_die:  
La Progessive Web App de participation du public du Chrome Dev Summit 2016 !
([Projet Github](https://github.com/jakearchibald/big-web-quiz))

**[Nectarine.rocks](http://nectarine.rocks)** :peach:  
Une application Open-Source pour peach.cool.
[Projet Github](https://github.com/developit/nectarine)

**[Dropfox](https://github.com/developit/dropfox)** :wolf:  
Une application bureau pour Dropbox, créée avec Preact, Electron et Photon.

**[Connectivity Index](https://cindex.co)** :iphone:  
Un site web qui vous permet de faire des recherches par pays dans les données du [Akamai State of the Internet Connectivity Report](https://content.akamai.com/PG7010-Q2-2016-SOTI-Connectivity-Report.html).

**[Drag & Drop file upload (webpack 2)](https://contentful-labs.github.io/file-upload-example/)** :rocket:
Une application bureau pour envoyer des ressources sur Contentful (un CMS basé sur une API)
[Projet Github](https://github.com/contentful-labs/file-upload-example)

**[Embed Hacker News](https://github.com/TXTPEN/hn)** :kissing_closed_eyes:
Embarquez l'arbre de commentaires de Hacker News sous votre article de blog.

**[ColoGuessr](https://cologuessr.com)** :rainbow:
Vérifiez si vous connaissez bien vos couleurs
[Github Project](https://github.com/jackpordi/cologuessr)

## Démos entières et Exemples

**[Documentation Viewer](https://documentation-viewer.firebaseapp.com)**
Voir le résultat de documentation.js en ligne.
[Projet Github](https://github.com/developit/documentation-viewer)

**[TodoMVC](http://developit.github.io/preact-todomvc/)**
L'implémentation non officielle de TodoMVC la plus rapide.
[Projet Github](https://github.com/developit/preact-todomvc)

**[TodoMVC+PouchDB](http://katopz.github.io/preact-todomvc-pouchdb/)** :floppy_disk:  
Synchronisez TodoMVC avec [PouchDB](https://pouchdb.com/) hors ligne.  
[Projet Github](https://github.com/katopz/preact-todomvc-pouchdb)

**[Hacker News Minimal](https://developit.github.io/hn_minimal/)** :newspaper:  
Un client hacker news léger.
[Projet Github](https://github.com/developit/hn_minimal)

**[Preact Boilerplate](https://preact-boilerplate.surge.sh)** :zap:
Un starter de projet avec Preact, Webpack, LESS et CSS Modules.
[Projet Github](https://github.com/developit/preact-boilerplate)

**[Preact Offline Starter](https://preact-starter.now.sh)** :100:
Un starter Webpack 2 simplifié pour les Progressive Web Apps, avec support du hors ligne.
[Projet Github](https://github.com/lukeed/preact-starter)

**[Preact Redux Example](https://preact-redux-example.surge.sh)** :repeat:  
Un exemple de To-Do list implémenté avec Preact et Redux.
[Projet Github](https://github.com/developit/preact-redux-example)

**[Preact Without Babel](https://github.com/developit/preact-without-babel)** :horse:  
Comment utiliser Preact sans Babel, ES2015 ou JSX.

**[preact-minimal](https://github.com/aganglada/preact-minimal)** :rocket:  
Une structure minimale pour Preact, incluant tous les outils nécéssaires pour bien commencer votre projet.


## Codepens

- [Flickr Browser](http://codepen.io/developit/full/VvMZwK/) _(@ CodePen)_
- [Animating Text](http://codepen.io/developit/full/LpNOdm/) _(@ CodePen)_
- [60FPS Rainbow Spiral](http://codepen.io/developit/full/xGoagz/) _(@ CodePen)_
- [Simple Clock](http://jsfiddle.net/developit/u9m5x0L7/embedded/result,js/) _(@ JSFiddle)_
- [3D + ThreeJS](http://codepen.io/developit/pen/PPMNjd?editors=0010) _(@ CodePen)_

## Templates

:zap: [**Modèle JSFiddle**](https://jsfiddle.net/developit/rs6zrh5f/embedded/result/)

:zap: [**Modèle CodePen**](http://codepen.io/developit/pen/pgaROe?editors=0010)
