---
name: Libraries & Add-ons
permalink: '/about/addons-libraries'
---

# Librerías y complementos

Una colección de módulos construidos para trabajar perfectamente con Preact.

> :information_desk_person: _¿Creaste uno por tu cuenta?
> [¡Agregalo!](https://github.com/preactjs/preact-www/blob/master/content/es/about/libraries-addons.md)_


### Complementos

- :raised_hands: [**preact-compat**](https://github.com/preactjs/preact-compat): utilizar cualquier librería de React con Preact *([full example](https://github.com/developit/preact-compat-example))*
- :repeat: [**preact-cycle**](https://github.com/developit/preact-cycle): Paradigma funcional-reactivo para Preact
- :page_facing_up: [**preact-render-to-string**](https://github.com/preactjs/preact-render-to-string): Universal rendering.


### Componentes

- :earth_americas: [**preact-router**](https://github.com/preactjs/preact-router): URL routing para tus componentes
- :bookmark_tabs: [**preact-markup**](https://github.com/developit/preact-markup): Render HTML & Custom Elements as JSX & Components
- :satellite: [**preact-portal**](https://github.com/developit/preact-portal): Render Preact components into (a) SPACE :milky_way:
- :pencil: [**preact-richtextarea**](https://github.com/developit/preact-richtextarea): Simple HTML editor component
- :bookmark: [**preact-token-input**](https://github.com/developit/preact-token-input): Text field that tokenizes input, for things like tags
- :card_index: [**preact-virtual-list**](https://github.com/developit/preact-virtual-list): Easily render lists with millions of rows ([demo](https://jsfiddle.net/developit/qqan9pdo/))
- :triangular_ruler: [**preact-layout**](https://download.github.io/preact-layout/): Small and simple layout library


### Integraciones

- :thought_balloon: [**preact-socrates**](https://github.com/matthewmueller/preact-socrates): Preact plugin for [Socrates](http://github.com/matthewmueller/socrates)
- :rowboat: [**preact-flyd**](https://github.com/xialvjun/preact-flyd): Use [flyd](https://github.com/paldepind/flyd) FRP streams in Preact + JSX
- :speech_balloon: [**preact-i18nline**](https://github.com/download/preact-i18nline): Integrates the ecosystem around [i18n-js](https://github.com/everydayhero/i18n-js) with Preact via [i18nline](https://github.com/download/i18nline).


### GUI Toolkits

- :white_square_button: [**preact-mdl**](https://github.com/developit/preact-mdl): Usa [MDL](https://getmdl.io) como componente de Preact
- :rocket: [**preact-photon**](https://github.com/developit/preact-photon): construye hermosas interfaces de escritorio con [photon](http://photonkit.com)


### Testing

- :microscope: [**preact-jsx-chai**](https://github.com/developit/preact-jsx-chai): JSX assertion testing _(no DOM, right in Node)_


### Utilidades

- :tophat: [**preact-classless-component**](https://github.com/ld0rman/preact-classless-component): crea componentes de preact sin la palabra clave class
- :hammer: [**preact-hyperscript**](https://github.com/queckezz/preact-hyperscript): Hyperscript-like syntax for creating elements
- :white_check_mark: [**shallow-compare**](https://github.com/tkh44/shallow-compare): helper simplificado de `shouldComponentUpdate`.
