---
name: Demos & Examples
permalink: '/about/demos-examples'
---

# Demostraciones y Ejemplos

Esta página contiene una serie de demos y ejemplos que puedes utilizar para aprender Preact.

> :information_desk_person: _¿Creaste uno por tu cuenta?
> [¡Agregalo!](https://github.com/preactjs/preact-www/blob/master/content/es/about/demos-examples.md)_


## Full Apps

[**Preact Website** _(preactjs.com)_](https://preactjs.com)  
Por supuesto, este sitio está construído con Preact.  
[Github Project](https://github.com/preactjs/preact-www)

**[ESBench](http://esbench.com)** :alarm_clock:  
Construido con Preact y Material Design Lite.

[**GuriVR**](https://gurivr.com) :eyeglasses:  
Natural language based Web VR story creator.  
_([Github Project](https://github.com/opennewslabs/guri-vr))_

[**BigWebQuiz**](https://bigwebquiz.com) :game_die:  
The audience participation Progressive Web App from Chrome Dev Summit 2016!  
([Github Project](https://github.com/jakearchibald/big-web-quiz))

**[Nectarine.rocks](http://nectarine.rocks)** :peach:  
Open-Source peach.cool app.  
[Github Project](https://github.com/developit/nectarine)

**[Dropfox](https://github.com/developit/dropfox)** :wolf:  
Aplicación Desktop para Dropbox, construída con Preact, Electron y Photon.

**[ColoGuessr](https://cologuessr.com)** :rainbow:
Comprueba lo bien que conoces tus colores
[Github Project](https://github.com/jackpordi/cologuessr)

## Full Demos y Ejemplos

**[Documentation Viewer](https://documentation-viewer.firebaseapp.com)**  
View documentation.js output online.  
[Github Project](https://github.com/developit/documentation-viewer)

**[TodoMVC](http://developit.github.io/preact-todomvc/)**  
Una implementación rápida de TodoMVC (no oficial).
[Github Project](https://github.com/developit/preact-todomvc)

**[TodoMVC+PouchDB](http://katopz.github.io/preact-todomvc-pouchdb/)** :floppy_disk:  
Offline Sync TodoMVC con [PouchDB](https://pouchdb.com/).  
[Github Project](https://github.com/katopz/preact-todomvc-pouchdb)

**[Hacker News Minimal](https://developit.github.io/hn_minimal/)** :newspaper:  
Un pequeño cliente de hacker news.
[Github Project](https://github.com/developit/hn_minimal)

**[Preact Boilerplate](https://preact-boilerplate.surge.sh)** :zap:  
2 command starter project. Preact + Webpack + LESS + CSS Modules.  
[Github Project](https://github.com/developit/preact-boilerplate)

**[Preact Redux Example](https://preact-redux-example.surge.sh)** :repeat:  
Un proyecto de ejemplo con Preact + Redux, implementado una simple lista de To-Do.
[Github Project](https://github.com/developit/preact-redux-example)

**[Preact Without Babel](https://github.com/developit/preact-without-babel)** :horse:  
¿Cómo utilizar Preact completamente sin Babel, ES2015 o JSX?


## Codepens

- [Flickr Browser](http://codepen.io/developit/full/VvMZwK/) _(@ CodePen)_
- [Animating Text](http://codepen.io/developit/full/LpNOdm/) _(@ CodePen)_
- [60FPS Rainbow Spiral](http://codepen.io/developit/full/xGoagz/) _(@ CodePen)_
- [Simple Clock](http://jsfiddle.net/developit/u9m5x0L7/embedded/result,js/) _(@ JSFiddle)_
- [3D + ThreeJS](http://codepen.io/developit/pen/PPMNjd?editors=0010) _(@ CodePen)_

## Templates

:zap: [**JSFiddle Template**](https://jsfiddle.net/developit/rs6zrh5f/embedded/result/)

:zap: [**CodePen Template**](http://codepen.io/developit/pen/pgaROe?editors=0010)
