---
name: Libraries & Add-ons
permalink: '/about/addons-libraries'
description: 'Collection of libraries and addons that work well with Preact'
---

# Libraries & Add-ons

A collection of modules built to work wonderfully with Preact.

> :information_desk_person: _Built one of your own?
> [Add it!](https://github.com/preactjs/preact-www/blob/master/content/en/about/libraries-addons.md)_

## Add-Ons

- :repeat: [**preact-cycle**](https://github.com/developit/preact-cycle): Functional-reactive paradigm for Preact
- :page_facing_up: [**preact-render-to-string**](https://github.com/preactjs/preact-render-to-string): Universal rendering.
- :timer_clock: [**relaks**](https://github.com/trambarhq/relaks): Create components with render methods that return asynchronously.
- :nut_and_bolt: [**express-preact-views**](https://github.com/edwjusti/express-preact-views): Express View Engine.
- :floppy_disk: [**Prefresh**](https://github.com/JoviDeCroock/prefresh): Fast-Refresh for Preact.
- :bookmark_tabs: [**adonis-preact**](https://github.com/DonsWayo/adonis-preact): Use Preact in Adonisjs

## Components

- :earth_americas: [**preact-router**](https://github.com/preactjs/preact-router): URL routing for your components
- :bookmark_tabs: [**preact-markup**](https://github.com/developit/preact-markup): Render HTML & Custom Elements as JSX & Components
- :satellite: [**preact-portal**](https://github.com/developit/preact-portal): Render Preact components into (a) SPACE :milky_way:
- :pencil: [**preact-richtextarea**](https://github.com/developit/preact-richtextarea): Simple HTML editor component
- :bookmark: [**preact-token-input**](https://github.com/developit/preact-token-input): Text field that tokenizes input, for things like tags
- :card_index: [**preact-virtual-list**](https://github.com/developit/preact-virtual-list): Easily render lists with millions of rows ([demo](https://jsfiddle.net/developit/qqan9pdo/))
- :triangular_ruler: [**preact-layout**](https://download.github.io/preact-layout/): Small and simple layout library
- :construction_worker: [**preact-helmet**](https://github.com/download/preact-helmet): A document head manager for Preact
- :arrow_up_down: [**preact-custom-scrollbars**](https://github.com/lucafalasco/preact-custom-scrollbars): Fully customizable scrollbars, for frictionless native browser scrolling
- 🧱 [**@modular-forms/preact**](https://modularforms.dev/): Modular and type-safe form library

## Integrations

- :thought_balloon: [**preact-socrates**](https://github.com/matthewmueller/preact-socrates): Preact plugin for [Socrates](http://github.com/matthewmueller/socrates)
- :rowboat: [**preact-flyd**](https://github.com/xialvjun/preact-flyd): Use [flyd](https://github.com/paldepind/flyd) FRP streams in Preact + JSX
- :speech_balloon: [**preact-i18nline**](https://github.com/download/preact-i18nline): Integrates the ecosystem around [i18n-js](https://github.com/everydayhero/i18n-js) with Preact via [i18nline](https://github.com/download/i18nline).
- :diamond_shape_with_a_dot_inside: [**Capacitor**](https://capacitorjs.com/solution/preact): Turn your Preact app into a Native iOS/Android App and PWA.
- :ice_cube: [**Kretes**](https://kretes.dev/docs/howtos/preact-setup/): Build full-stack TypeScript apps using Preact and Node.js
- 🏝: [**preact-island**](https://github.com/mwood23/preact-island): Run your Preact widget on any website with reactive props.

## GUI Toolkits

- 🎴 [**@mui/material**](https://github.com/mui/material-ui/tree/master/examples/material-ui-preact): the React UI library you always wanted. Follow your own design system, or start with Material Design.
- :thumbsup: [**preact-material-components**](https://github.com/prateekbh/preact-material-components): Material Components for the Web (supersedes MDL)
- :white_square_button: [**preact-mdl**](https://github.com/developit/preact-mdl): Use [MDL](https://getmdl.io) as Preact components
- :rocket: [**preact-photon**](https://github.com/developit/preact-photon): build beautiful desktop UI with [photon](http://photonkit.com)
- :penguin: [**preact-weui**](https://github.com/afeiship/preact-weui): [Weui](https://github.com/afeiship/preact-weui) for Preact
- 💅 [**preact-fluid**](https://github.com/ajainvivek/preact-fluid): [Fluid](https://github.com/ajainvivek/preact-fluid) minimal UI kit for Preact
- :book: [**storybook-preact**](https://github.com/storybooks/storybook/tree/next/app/preact): Storybook for Preact is a UI development environment for your Preact components

### Testing

- :microscope: [**preact-jsx-chai**](https://github.com/developit/preact-jsx-chai): JSX assertion testing _(no DOM, right in Node)_
- :white_check_mark: [**unexpected-preact**](https://github.com/bruderstein/unexpected-preact): JSX assertions, events, snapshots in Jest _(DOM, works under Node jsdom or out-of-the-box in Jest)_ - [docs](https://bruderstein.github.io/unexpected-preact/)

## Utilities

- :tophat: [**preact-classless-component**](https://github.com/ld0rman/preact-classless-component): create preact components without the class keyword
- :hammer: [**preact-hyperscript**](https://github.com/queckezz/preact-hyperscript): Hyperscript-like syntax for creating elements
- :white_check_mark: [**shallow-compare**](https://github.com/tkh44/shallow-compare): simplified `shouldComponentUpdate` helper.
- :signal_strength: [**@deepsignal/preact**](https://github.com/EthanStandel/deepsignal/tree/main/packages/preact): Extension of `@preact/signals` for full state management
