---
name: Demos & Examples
permalink: '/about/demos-examples'
description: 'Collection of demos and example Preact applications'
---

# Demos & Examples

This pages lists a bunch of demos and examples you can use to learn Preact.

> :information_desk_person: _Built one of your own?
> [Add it!](https://github.com/preactjs/preact-www/blob/master/content/en/about/demos-examples.md)_


## Full Apps

[**Preact Website** _(preactjs.com)_](https://preactjs.com)  
Of course this website is built with Preact.  
[Github Project](https://github.com/preactjs/preact-www)

**[ESBench](http://esbench.com)** :alarm_clock:  
Built with Preact & Material Design Lite.

[**GuriVR**](https://gurivr.com) :eyeglasses:
Natural language based Web VR story creator.  
[Github Project](https://github.com/opennewslabs/guri-vr)

[**BigWebQuiz**](https://bigwebquiz.com) :game_die:  
The audience participation Progressive Web App from Chrome Dev Summit 2016!  
[Github Project](https://github.com/jakearchibald/big-web-quiz)

**[Nectarine.rocks](http://nectarine.rocks)** :peach:  
Open-Source peach.cool app.  
[Github Project](https://github.com/developit/nectarine)

**[Web Maker](https://webmaker.app/)** :zap:
Blazing fast & offline frontend playground.
[Github Project](https://github.com/chinchang/web-maker)

**[BitMidi](https://bitmidi.com/)** :musical_keyboard:
Wayback machine for free MIDI files
[Github Project](https://github.com/feross/bitmidi.com)

**[BBC Roasting Calculator](https://www.bbc.com/food/techniques/articles/roast-calculator)** :turkey:
Calculates cooking times for different cuts of meat.

**[Dropfox](https://github.com/developit/dropfox)** :wolf:  
Desktop app for Dropbox, built with Preact, Electron and Photon.

**[Embed Hacker News](https://github.com/TXTPEN/hn)** :kissing_closed_eyes:
Embed Hacker News comment tree below your blog article.

**[Connectivity Index](https://cindex.co)** :iphone:  
A site that allows you to search through [Akamai State of the Internet Connectivity Report](https://content.akamai.com/PG7010-Q2-2016-SOTI-Connectivity-Report.html) data by country.

**[Drag & Drop file upload (webpack 2)](https://contentful-labs.github.io/file-upload-example/)** :rocket:
Desktop App for uploading assets to Contentful (API based CMS)
[Github Project](https://github.com/contentful-labs/file-upload-example)

**[Exchange Widget](https://sgtpep.github.io/exchange-widget/dist/)** :currency_exchange:
The currency exchange widget inspired by a popular mobile app implemented using Preact, Meiosis, HTML tagged templates and native ES modules.
[Github Project](https://github.com/sgtpep/exchange-widget)

**[Blaze](https://blaze.now.sh)** :zap:  
Modern peer-to-peer file sharing Progressive Web App.  
[Github Project](https://github.com/blenderskool/blaze)

**[1tuner](https://1tuner.com)** :radio:  
Listen to radio and podcasts.  
[Github Project](https://github.com/robinbakker/1tuner)

**[ColoGuessr](https://cologuessr.com)** :rainbow:
Test how well you know your colors
[Github Project](https://github.com/jackpordi/cologuessr)

## Full Demos & Examples

**[Documentation Viewer](https://documentation-viewer.firebaseapp.com)**  
View documentation.js output online.  
[Github Project](https://github.com/developit/documentation-viewer)

**[TodoMVC](http://developit.github.io/preact-todomvc/)**  
Unofficial fastest TodoMVC implementation.  
[Github Project](https://github.com/developit/preact-todomvc)

**[TodoMVC+PouchDB](http://katopz.github.io/preact-todomvc-pouchdb/)** :floppy_disk:  
Offline Sync TodoMVC with [PouchDB](https://pouchdb.com/).  
[Github Project](https://github.com/katopz/preact-todomvc-pouchdb)

**[Hacker News Minimal](https://developit.github.io/hn_minimal/)** :newspaper:  
Tiny hacker news client.  
[Github Project](https://github.com/developit/hn_minimal)

**[Preact Boilerplate](https://preact-boilerplate.surge.sh)** :zap:  
2 command starter project. Preact + Webpack + LESS + CSS Modules.  
[Github Project](https://github.com/developit/preact-boilerplate)

**[Preact Offline Starter](https://preact-starter.now.sh)** :100:  
Simplified Webpack2 starter for Progressive Web Apps, with offline support.  
[Github Project](https://github.com/lukeed/preact-starter)

**[Preact Redux Example](https://preact-redux-example.surge.sh)** :repeat:  
Preact + Redux example project, implementing a simple To-Do list.  
[Github Project](https://github.com/developit/preact-redux-example)

**[Preact Without Babel](https://github.com/developit/preact-without-babel)** :horse:  
How to use Preact entirely without Babel, ES2015 or JSX.

**[preact-minimal](https://github.com/aganglada/preact-minimal)** :rocket:  
Minimal Preact structure with all the necessary tools to start your project right away.

**[preact-typescript-webpack4-less](https://github.com/lexey111/preact-typescript-webpack4-boilerplate)**
Another one minimal set with Preact, Typescript and Webpack 4.

**[Preact Homepage Generator](https://thomaswood.me/)** :globe_with_meridians:  
Quickly spin up a new personal webpage by only needing to modify JSON data.
[Github Project](https://github.com/tomasswood/preact-homepage-generator)

**[Parcel + Preact + Unistore Starter](https://github.com/hwclass/parcel-preact-unistore-starter)**
Starter pack for lightning-fast prototyping and small/medium size project structure

**[buildless-preact-starter](https://github.com/ttntm/buildless-preact-starter)** :rocket:
A starter/template for using Preact in buildless environments

## Codepens

- [Flickr Browser](http://codepen.io/developit/full/VvMZwK/) _(@ CodePen)_
- [Animating Text](http://codepen.io/developit/full/LpNOdm/) _(@ CodePen)_
- [60FPS Rainbow Spiral](http://codepen.io/developit/full/xGoagz/) _(@ CodePen)_
- [Simple Clock](http://jsfiddle.net/developit/u9m5x0L7/embedded/result,js/) _(@ JSFiddle)_
- [3D + ThreeJS](http://codepen.io/developit/pen/PPMNjd?editors=0010) _(@ CodePen)_
- [Endless Horse](https://codepen.io/youkwhd/pen/zYbjepj) _(@ CodePen)_

## Templates

:zap: [**JSFiddle Template**](https://jsfiddle.net/developit/rs6zrh5f/embedded/result/)

:zap: [**CodePen Template**](http://codepen.io/developit/pen/pgaROe?editors=0010)
