---
name: Demos & Beispiele
permalink: '/about/demos-examples'
---

# Demos & Beispiele

Diese Seite zeigt einige Demos und Beispiele, die zum Erlernen von Preact benutzt werden können.

> :information_desk_person: _Eigenes Beispiel erstellt?
> [Einfach hinzufügen!](https://github.com/preactjs/preact-www/blob/master/content/de/about/demos-examples.md)_


## Vollständige Apps

[**Preact Website** _(preactjs.com)_](https://preactjs.com)  
Natürlich ist diese Website mit Preact erstellt.
[GitHub-Projekt](https://github.com/preactjs/preact-www)

**[ESBench](http://esbench.com)** :alarm_clock:  
Erstellt mit Preact & Material Design Lite.

[**GuriVR**](https://gurivr.com) :eyeglasses:
Web VR-Geschichtenersteller basierend auf natürlicher Sprache.
_([GitHub-Projekt](https://github.com/opennewslabs/guri-vr))_

[**BigWebQuiz**](https://bigwebquiz.com) :game_die:  
Die progressive Web App für Publikumspartizipation vom Chrome Dev Summit 2016!
([GitHub-Projekt](https://github.com/jakearchibald/big-web-quiz))

**[Nectarine.rocks](http://nectarine.rocks)** :peach:  
Open-Source peach.cool App.  
[GitHub-Projekt](https://github.com/developit/nectarine)

**[Dropfox](https://github.com/developit/dropfox)** :wolf:  
Desktop-App für Dropbox, erstellt mit Preact, Electron und Photon.

**[Connectivity Index](https://cindex.co)** :iphone:  
Eine Seite, die das Durchsuchen von Daten, geordnet nach Land, des [Akamai State of the Internet Connectivity Report](https://content.akamai.com/PG7010-Q2-2016-SOTI-Connectivity-Report.html) ermöglicht.

**[Drag & Drop file upload (webpack 2)](https://contentful-labs.github.io/file-upload-example/)** :rocket:
Desktop App zum Hochladen auf Contentful (API based CMS)
[GitHub-Projekt](https://github.com/contentful-labs/file-upload-example)

**[Embed Hacker News](https://github.com/TXTPEN/hn)** :kissing_closed_eyes:
Kommentarbaum für die Embed Hacker News unter dem eigenen Blogeintrag.

**[ColoGuessr](https://cologuessr.com)** :rainbow:
Testen Sie, wie gut Sie Ihre Farben kennen
[Github Project](https://github.com/jackpordi/cologuessr)

## Vollständige Demos & Beispiele

**[Documentation Viewer](https://documentation-viewer.firebaseapp.com)**  
Onlineansicht der Ausgabe von documentation.js.
[GitHub-Projekt](https://github.com/developit/documentation-viewer)

**[TodoMVC](http://developit.github.io/preact-todomvc/)**  
Inoffiziell schnellste TodoMVC-Implementierung.  
[GitHub-Projekt](https://github.com/developit/preact-todomvc)

**[TodoMVC+PouchDB](http://katopz.github.io/preact-todomvc-pouchdb/)** :floppy_disk:  
Synchronisiere TodoMVC offline mit [PouchDB](https://pouchdb.com/).  
[GitHub-Projekt](https://github.com/katopz/preact-todomvc-pouchdb)

**[Hacker News Minimal](https://developit.github.io/hn_minimal/)** :newspaper:  
Kleine Hacker News-App.  
[GitHub-Projekt](https://github.com/developit/hn_minimal)

**[Preact Boilerplate](https://preact-boilerplate.surge.sh)** :zap:  
Anfängerprojekt mit zwei Befehlen. Preact + Webpack + LESS + CSS Modules.  
[GitHub-Projekt](https://github.com/developit/preact-boilerplate)

**[Preact Offline Starter](https://preact-starter.now.sh)** :100:  
Vereinfachter Webpack2-Starter für progressive Web Apps mit Offlinesupport.  
[GitHub-Projekt](https://github.com/lukeed/preact-starter)

**[Preact Redux Example](https://preact-redux-example.surge.sh)** :repeat:  
Preact + Redux-Beispielprojekt, das eine einfache To-Do-Liste implementiert.
[GitHub-Projekt](https://github.com/developit/preact-redux-example)

**[Preact Without Babel](https://github.com/developit/preact-without-babel)** :horse:  
Wie man Preact gänzlich ohne Babes, ES2015 oder JSX benutzt.

**[preact-minimal](https://github.com/aganglada/preact-minimal)** :rocket:  
Kleine Preact-Struktur mit allen nötigen Werkzeugen um direkt mit seinem Projekt zu Starten.


## Codepens

- [Flickr-Browser](http://codepen.io/developit/full/VvMZwK/) _(@ CodePen)_
- [Text animieren](http://codepen.io/developit/full/LpNOdm/) _(@ CodePen)_
- [60FPS-Regenboxenspirale](http://codepen.io/developit/full/xGoagz/) _(@ CodePen)_
- [Simple Uhr](http://jsfiddle.net/developit/u9m5x0L7/embedded/result,js/) _(@ JSFiddle)_
- [3D + ThreeJS](http://codepen.io/developit/pen/PPMNjd?editors=0010) _(@ CodePen)_

## Vorlage

:zap: [**JSFiddle Template**](https://jsfiddle.net/developit/rs6zrh5f/embedded/result/)

:zap: [**CodePen Template**](http://codepen.io/developit/pen/pgaROe?editors=0010)
