#include <spdlog/spdlog.h>

#include "mods/AutomataMPConfig.hpp"
#include "mods/AutomataMPMod.hpp"
#include "mods/AnimTester.hpp"
#include "mods/BuddyFeatures.hpp"
#include "mods/Explorer.hpp"

#include "Mods.hpp"

Mods::Mods() {
    m_mods.emplace_back(new AutomataMPConfig());
    m_mods.emplace_back(AutomataMPMod::get());
    m_mods.emplace_back(new BuddyFeatures());
    m_mods.emplace_back(new AnimTester());
    m_mods.emplace_back(new Explorer());
}

std::optional<std::string> Mods::on_initialize() const {
    for (auto& mod : m_mods) {
        spdlog::info("{:s}::on_initialize()", mod->get_name().data());

        if (auto e = mod->on_initialize(); e != std::nullopt) {
            spdlog::info("{:s}::on_initialize() has failed: {:s}", mod->get_name().data(), *e);
            return e;
        }
    }

    utility::Config cfg{ "automatamp_config.txt" };

    for (auto& mod : m_mods) {
        spdlog::info("{:s}::on_config_load()", mod->get_name().data());
        mod->on_config_load(cfg);
    }

    return std::nullopt;
}

void Mods::on_pre_imgui_frame() const {
    for (auto& mod : m_mods) {
        mod->on_pre_imgui_frame();
    }
}

void Mods::on_frame() const {
    for (auto& mod : m_mods) {
        mod->on_frame();
    }
}

void Mods::on_present() const {
    for (auto& mod : m_mods) {
        mod->on_present();
    }
}

void Mods::on_post_frame() const {
    for (auto& mod : m_mods) {
        mod->on_post_frame();
    }
}

void Mods::on_draw_ui() const {
    for (auto& mod : m_mods) {
        mod->on_draw_ui();
    }
}

void Mods::on_device_reset() const {
    for (auto& mod : m_mods) {
        mod->on_device_reset();
    }
}
