# Welcome to Open Source! &middot; [![GitHub license](https://img.shields.io/badge/license-MIT-blue.svg)](https://github.com/pr4shan7/beginners-only/blob/master/LICENSE) [![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg)](https://github.com/pr4shan7/beginners-only/blob/master/README.md#get-started) [![first-timers-only](https://img.shields.io/badge/first--timers--only-friendly-blue.svg?style=flat-square)](https://www.firsttimersonly.com/)

> **_[This repository](https://github.com/pr4shan7/beginners-only) is meant to help people learn about Git and Github and get started contributing to Open Source Software, and can be freely used to practice Git workflow. Also, it can be used as a learning resource for other topics. [Experienced users](https://github.com/pr4shan7/beginners-only/issues/10) are requested to contribute useful learning resources to this repo and help the community learn._**

## Get Started

Getting started with Open Source can be intimidating, but it doesn't have to be. Don't worry, this repo is at your help!

If you are absolutely new to Open Source (like everyone was once!) you can use the following resources to get-started:

* [An Introduction to Open Source from DigitalOcean](https://www.digitalocean.com/community/tutorial_series/an-introduction-to-open-source)
* [Crash Course: git Lingo](https://dev.to/tvanblargan/crash-course-git-lingo-1enj)
* [How to create a Pull Request](https://www.digitalocean.com/community/tutorials/how-to-create-a-pull-request-on-github)
* [How to Contribute to Open Source](https://opensource.guide/how-to-contribute/)

More learning resources can be found [here](https://github.com/pr4shan7/beginners-only/blob/master/Learning-Resources/learning-resources.md#git-github-and-open-source).

Now that you are familiar with the basics of Git and GitHub, apply your knowledge to practice and start contributing to [this repository](https://github.com/pr4shan7/beginners-only) and help it evolve. You're welcome! ^_^

If you're an experienced programmer/user, you are requested to contribute useful learning resources to this repo and provide guidance to beginners. See [Issue #10](https://github.com/pr4shan7/beginners-only/issues/10)  
Also, please consider becoming a maintainer to help keep this repo alive and give back to the community. See [Issue #100](https://github.com/pr4shan7/beginners-only/issues/100)

Please read the [Contribution Guide](https://github.com/pr4shan7/beginners-only/blob/master/CONTRIBUTING.md) before you start.

You can raise an issue, if you need to, or directly submit a PR addressing some issue.
[This issue](https://github.com/pr4shan7/beginners-only/issues/1) is a great first issue to address and get started.

Please spread the word and share this repository with your friends and help them start their Open Source journey!

Additionally, you may participate in [Hacktoberfest](https://github.com/pr4shan7/beginners-only/blob/master/Hacktoberfest/README.md) if you are here in the month of October, and earn a limited-edition T-shirt!

After you've made your first contribution, you may head to other repositories and explore Open Source. The following resources share repositories that curate tasks for beginners:

* [First Timers Only](https://www.firsttimersonly.com/)
* [Up For Grabs](https://up-for-grabs.net/#/)
* [Awesome for Beginners](https://github.com/mungell/awesome-for-beginners)
* [Issuehub.io](http://issuehub.io/)
* [Your First PR](https://yourfirstpr.github.io/)
* [First Contributions](https://roshanjossey.github.io/first-contributions)

Once you start feeling more comfortable, you can find more open source projects through the following programs:

* [Pull Request Roulette](http://www.pullrequestroulette.com/)
* [Code Triage](https://www.codetriage.com/)
* [24 P[ULL] R[EQUEST]S](https://24pullrequests.com/)

Here are guides from different organizations to make it easy for first timers to contribute to their projects:

1. [First Kernel Patch](https://kernelnewbies.org/FirstKernelPatch)
2. [GnomeLove](https://wiki.gnome.org/action/show/Newcomers?action=show&redirect=GnomeLove)
3. [What Can I Do For Mozilla?](http://www.whatcanidoformozilla.org/#!/progornoprog/support)
4. [What Can I Do For Fedora?](https://whatcanidoforfedora.org/en#designexclamation)
5. [How to become a MediaWiki hacker?](https://www.mediawiki.org/wiki/How_to_become_a_MediaWiki_hacker)
6. [Apache Newcomers Guide](http://community.apache.org/newcomers/index.html)
7. [KDE guide](https://community.kde.org/Get_Involved)

[Twitter Accounts which tweet about beginner friendly issues](https://github.com/pr4shan7/beginners-only/blob/master/help-from-twitter.md).

_Like this repo? Star it and show your love!_
