# [Hacktoberfest](https://hacktoberfest.digitalocean.com/)

> **_Support open source and earn a limited edition T-shirt!_**

[Hacktoberfest](https://hacktoberfest.digitalocean.com/) is an annual global hackathon event presented by [DigitalOcean](https://digitalocean.com) and [DEV](https://dev.to/) in partnership with [GitHub](https://github.com) to encourage people to make meaningful contribution to Open Source Software.
Getting started with Open Source can be intimidating at first, but don't worry. Hacktoberfest is a great event to make your first meaningful pull request (PR) and this repository has everything you need to get started. What's more, make 4 PRs in this period and get a limited-edition T-shirt!

## Event details

Hacktoberfest® is open to everyone in our global community. Whether you’re a developer, student learning to code, event host, or company of any size, you can help drive growth of open source and make positive contributions to an ever-growing community. All backgrounds and skill levels are encouraged to complete the challenge.

* Hacktoberfest is open to everyone in our global community!
* Pull requests can be made in any GitHub-hosted repositories/projects.
* Sign up anytime between October 1 and October 31.

## Rules

To qualify for the official limited edition Hacktoberfest T-shirt, you must register and make four pull requests (PRs) between October 1-31 (in any time zone). PRs can be made to any public repo on GitHub, not only the ones with issues labeled Hacktoberfest. If a maintainer reports your pull request as spam or behavior not in line with the project’s code of conduct, you will be ineligible to participate. This year, the first 50,000 participants who successfully complete the challenge will earn a T-shirt.

## Quality standards

In line with Hacktoberfest value #2 (Quantity is fun, quality is key), here are examples of the PRs that we consider to be low-quality contributions (which we discourage).

* PRs that are automated (e.g. scripted opening PRs to remove whitespace/optimize images)
* PRs that are disruptive (e.g. taking someone else's branch/commits and making a PR)
* PRs that are regarded by a project maintainer as a hindrance vs. helping
* Something that's clearly an attempt to simply +1 your PR count for October
* Last but not least, one PR to fix a typo is fine. 5 PRs to remove a stray whitespace... not.

## Values

Inspired by you – the community – through your actions and stories.

* Everyone is welcome! Hacktoberfest participants have represented 151 countries and thousands of unique skill sets. Our program welcomes everyone already in the open source software community – and anyone interested in diving in.
* Quantity is fun, quality is key! Participating in Hacktoberfest leads to personal growth, professional opportunities, and community building. And it all begins with meaningful contributions to open source technology.
* Short-term actions, long-term impact! In the open source community, we stand on the shoulders of those who came before us. Your participation has a lasting effect on people and technology long after October comes to an end. This is a voyage, not a race.

## Get Started

First of all, go to the [Hacktoberfest Official Website](https://hacktoberfest.digitalocean.com/) and register yourself for the event.

If you are absolutely new to Open Source (like everyone was once!) you can use the following resources to get-started:

* [An Introduction to Open Source from DigitalOcean](https://www.digitalocean.com/community/tutorial_series/an-introduction-to-open-source)
* [Crash Course: git Lingo](https://dev.to/tvanblargan/crash-course-git-lingo-1enj)
* [How to create a Pull Request](https://www.digitalocean.com/community/tutorials/how-to-create-a-pull-request-on-github)
* [How to Contribute to Open Source](https://opensource.guide/how-to-contribute/)

More learning resources can be found [here](https://github.com/pr4shan7/beginners-only/blob/master/Learning-Resources/learning-resources.md#git-github-and-open-source).

Now that you are familiar with the basics of Git and GitHub, apply your knowledge to practice and make your first contribution to [this repository](https://github.com/pr4shan7/beginners-only). You are welcome! ^_^

Please read the [Contribution Guide](https://github.com/pr4shan7/beginners-only/blob/master/CONTRIBUTING.md) before you start.

If you're an experienced programmer/user, you are requested to contribute to this repo and help the community learn. See [Issue #10](https://github.com/pr4shan7/beginners-only/issues/10)

You can raise an issue, if you need to, or directly submit a PR addressing some issue.
[This issue for beginners](https://github.com/pr4shan7/beginners-only/issues/1) is a great first issue to address and get started.

> **_Please remember: While this repository is a great way to make your first contribution to open-source and get-started with Hacktoberfest, it is strongly advised that you make 4 contributions in a real-life Open Source Project (like [react](https://github.com/facebook/react)) to help support Open Source! Quality contributions to this repo addressing [#10](https://github.com/pr4shan7/beginners-only/issues/10) shall also be considered meaningful and helping._**

The following resources share repositories that curate tasks for beginners:

* [First Timers Only](https://www.firsttimersonly.com/)
* [Up For Grabs](https://up-for-grabs.net/#/)
* [Awesome for Beginners](https://github.com/mungell/awesome-for-beginners)
* [Issuehub.io](http://issuehub.io/)
* [Your First PR](https://yourfirstpr.github.io/)

Once you start feeling more comfortable, you can find more open source projects through the following programs:

* [Pull Request Roulette](http://www.pullrequestroulette.com/)
* [Code Triage](https://www.codetriage.com/)
* [24 P[ULL] R[EQEST]S](https://24pullrequests.com/)

Be sure to checkout [the main README file](https://github.com/pr4shan7/beginners-only/blob/master/README.md). Happy Hacktober! ^_^
