
class QueryParseError extends Error {
  constructor(message) {
    super();
    this.status = 400;
    this.name = 'query_parse_error';
    this.message = message;
    this.error = true;
  }
}

class NotFoundError extends Error {
  constructor(message) {
    super();
    this.status = 404;
    this.name = 'not_found';
    this.message = message;
    this.error = true;
  }
}

class BuiltInError extends Error {
  constructor(message) {
    super();
    this.status = 500;
    this.name = 'invalid_value';
    this.message = message;
    this.error = true;
  }
}

export {
  QueryParseError,
  NotFoundError,
  BuiltInError
};
