import { blob as createBlob } from 'pouchdb-binary-utils';

function readAsBlobOrBuffer(storedObject, type) {
  // In the browser, we've stored a binary string. This now comes back as a
  // browserified Node-style Buffer (implemented as a typed array),
  // but we want a Blob instead.
  var byteArray = new Uint8Array(storedObject);
  return createBlob([byteArray], {type});
}

export default readAsBlobOrBuffer;
