'use strict';

export default function (dbOpts, openDatabases, idbChanges, callback) {

  idbChanges.removeAllListeners(dbOpts.name);

  function doDestroy() {
    const req = indexedDB.deleteDatabase(dbOpts.name);
    req.onsuccess = function () {
      delete openDatabases[dbOpts.name];
      callback(null, {ok: true});
    };
  }

  // If the database is open we need to close it
  if (dbOpts.name in openDatabases) {
    openDatabases[dbOpts.name].then(function (res) {
      res.idb.close();
      doDestroy();
    });
  } else {
    doDestroy();
  }

}
