---
layout: 2ColLeft
title: Who's using PouchDB?
sidebar: nav.html
---

A list of known products and services that are using PouchDB.
## Newt

{% include img.html width=100 src="newt.png" alt="Newt" %}

[Newt](https://newt.to) lets you read, listen and write thousands of books across devices natively. It runs on Windows, Linux, macOS, Android, iOS & web. Its backed is powered by CouchDB and it uses PouchDB on the web client, desktop client and mobile native app for offline access, live sync, revisions and much more.

## BikeCommute

[BikeCommute](https://github.com/autonome/bikecommute) is a FirefoxOS app that registers an NFC tag to track bike commuters in the Mozilla Portland office. Built using Famo.us, PouchDB, and CouchDB. See [a video of it in action](https://youtu.be/3BVZYcQ-TYA) or [read about it on Mozilla Hacks](https://hacks.mozilla.org/2014/11/nfc-in-firefox-os/).

## Cloudwall

{% include img.html width=200 src="cloudwall.png" alt="Cloudwall" %}

[Cloudwall](http://cloudwall.me/) is an operating system for noBackend webapps, based on CouchDB and PouchDB.

## Cozy Cloud

{% include img.html width=125 src="cozy.png" alt="Cozy Cloud" %}

[Cozy](https://cozy.io/en/) is a personal cloud that you can host, customize, and fully control. It syncs contacts, calendars, and files between your personal devices and server. Under the hood, it leverages CouchDB and PouchDB.

## Delta
[Delta](http://delta.octavore.com/) is a command-line utility for text diffs. View split diffs in the browser with syntax highlighting, or in the command-line using the --cli flag.

## DevITJobs
[DevITJobs](http://devitjobs.com) is a job board for the tech industry with mandatory salary ranges & tech stacks.

## eHealth Africa

{% include img.html width=200 src="ehealth_africa.png" alt="eHealth Africa" %}

[eHealth Africa](http://ehealthafrica.org/) is an American-Nigerian NGO specialising in the development and deployment of tech for health. To tackle the Ebola outbreak, they built [mobile apps and dashboards](https://github.com/eHealthAfrica) to help track the spread of infection in the field. The combination of CouchDB and PouchDB enabled these apps to work consistently despite the extreme network unreliability of sub-saharan Africa.

## Financier

[Financier](https://financier.io) is a freemium personal budgeting app that uses PouchDB to store your budget data. The paid version syncs data with CouchDB 2 for data persistence and sharing across devices. The app is fully integrated with the PouchDB changes feed for instant updates. More about the stack is available in [humans.txt](https://app.financier.io/humans.txt).

## GRADEpro GDT

{% include img.html width=150 src="gradepro.png" alt="GRADEpro GDT" href="http://gradepro.org/" %}

[GRADEpro GDT](http://gradepro.org/) is an easy to use, all‐in‐one web solution to summarize and present information for healthcare decision making. PouchDB is instrumental for both the collaboration features of GRADEpro (so many users can work on the same data simultaneously) and implementation of the offline mode. The tool is used in more than 135 countries, some of which have poor Internet connectivity, as well as by scientists, who are frequent travelers and need to use the application e.g. on a plane.

## Hoodie

{% include img.html width=150 src="HoodieLogo.png" alt="Hoodie" href="http://hood.ie/" %}

[Hoodie](http://hood.ie/) provides a complete backend solution for your frontend code. It helps you develop your web application fast and easy. Hoodie-based apps are [offline-first](http://offlinefirst.org/) so they are usable anytime. Just plug Hoodie’s API into your frontend code, and your app is ready.

{% include svg/hospitalrun-logo.html %}

[HospitalRun](http://hospitalrun.io/) is an open source software product designed specifically for developing world hospitals, making usability the key requirement. Using PouchDB and offline-first design, HospitalRun allows records to be carried to remote clinics, functioning when there is no Internet, and syncing when there is.

## Local NPM

[Local NPM](https://github.com/nolanlawson/local-npm) allows you to easily set up a local NPM server that caches data from the real NPM and updates in realtime. The goal is to cut down network request time by moving data closer to the client. Built using Node.js, LevelDB, and PouchDB.

## Lullabot

[Lullabot](https://www.lullabot.com) is an interactive strategy, design, and development company. We create delightful experiences using Drupal and open source technologies. Our main website is using Drupal as the back-end for content management, CouchDB with PouchDB for the API, and ReactJS for the front-end.

## MBTA Alerts

{% include img.html width=100 src="mbta_alerts.jpeg" alt="MBTA Alerts" %}

[MBTA Alerts](https://twitter.com/MBTA_Alerts) is a Twitter bot that thousands of Bostonians depend upon to be notified of delays in the MBTA transit system. Uses Node.js, PouchDB, and CouchDB.

## Medic Mobile

{% include img.html src="medic-mobile.png" alt="Medic Mobile" %}

[Medic Mobile](http://medicmobile.org) is a software toolkit that combines smart messaging, decision support, easy data gathering and management, and health system analytics. Thanks to PouchDB our tools are offline first so workers can file reports wherever they are and sync when back online.

## MoneyTracker.cc

[MoneyTracker](https://moneytracker.cc/) is an open-source personal finances tracking web app. This app can work offline on desktop, tablet and mobile.
Data is stored locally on device in PouchDB database and can be synced to the cloud.

## NPM Browser

[NPM Browser](http://www.npm-browser.com/#/) is a fully offline cache of NPM packages, which runs in your browser, using Angular.js, PouchDB, and the pouchdb-load plugin.

## Pokedex.org

{% include img.html width=100 src="pokedexorg-logo.png" alt="Pokedex.org logo" %}

[Pokedex.org](https://www.pokedex.org/) [(Github)](https://github.com/nolanlawson/pokedex.org) is a progressive web app, powered by ServiceWorker, PouchDB, virtual-dom, and web workers.

## Quizster

{% include img.html width=100 src="quizster.svg" alt="Quizster" href="https://quizster.co" %}

[Quizster](https://quizster.co) is a photo-based submission and feedback system. Quizster uses PouchDB to allow real-time communication between students and teachers.

## Squarespace Blog

{% include img.html width=100 src="squarespace_blog.png" alt="Squarespace Blog" %}

Squarespace Blog is an [Android](https://play.google.com/store/apps/details?id=com.squarespace.android.blog) and [iOS app](https://itunes.apple.com/us/app/squarespace-blog/id715084234) that gives you the tools you need to write and edit posts on multiple Squarespace websites. It uses PouchDB attachments inside a WebView for fast offline images.

## Story-writer

Story-writer is a free Markdown editor, with a [web version](http://markdown.xiaoshujiang.com) and [NW.js client version](http://soft.xiaoshujiang.com), built using Node.js, NW.js, LevelDB, and PouchDB.

## Thali project

[Thali](http://thaliproject.org/) is a Microsoft-sponsored open-source platform for creating apps that exploit the power of personal devices and put people in control of their data. It uses Cordova, PouchDB, OpenSSL, and Tor.

## StudyMD

{% include img.html width=100 src="studymd.png" alt="StudyMD" %}

[StudyMD](https://github.com/jotron/StudyMD) transforms your markdown files into flashcards. It's an electronjs app based on reactjs. PouchDB is used in Node.js for storing the flashcards in a LevelDB database.

## YLD

[YLD](http://www.yld.io) is a Node.js software engineering, consulting and training company. We partner with enterprises to strengthen their software engineering culture and create the agility necessary to compete in today’s market, and are responsible for some of the largest Node.js solutions in production today. PouchDB allows us to create responsive, resilient and sync-enabled web applications.

{% include img.html src="TeamONE.png" alt="FactoryTalk TeamONE" %}
[FactoryTalk® TeamONE™](http://33seconds.io) delivers one new experience and helps industrial teams improve productivity.  Created by [Rockwell Automation](http://www.rockwellautomation.com/). We're using PouchDB for offline access and team synchronization. Looking to use the [Thali project](http://thaliproject.org/) (also a PouchDB client listed here) to enable true peer-to-peer connectivity. Connect with us on twitter ([@ROKTeamONE](https://twitter.com/rokteamone).)
