---
layout: post

title: PouchDB 9.0.0
author: Alba Herrerías

---

The PouchDB developers are *delighted* to announce the immediate availability of PouchDB 9.0.0. This is a **major** release with 202 PRs merged since the last version.

For a full changelog from 8.0.1 to 9.0.0, please see [the releases page](https://github.com/pouchdb/pouchdb/releases) or view the [latest commits](https://github.com/pouchdb/pouchdb/compare/8.0.1...9.0.0).

The PouchDB developers would like to thank all contributors for their hard and diligent work.

## Highlights

- Massively improved the stability and performance of the `indexeddb` adapter. Special thanks to [@alxndrsn](https://github.com/alxndrsn), [Medic](https://medic.org), and the [Google Advanced Web Apps Fund](https://developer.chrome.com/blog/advanced-web-apps-fund-oct-22).
- Introduce a default limit (of `25`) to the `.find()` method. This constitutes a backwards incompatible change and is the reason for the major version bump.
- Streamline the automated test suites and move in-browser testing to [Playwright](https://playwright.dev) resulting in much more reliable test runs.
- Continue to update the codebase to ES6.

## Changelog

### Features
* [c7c8afb1](https://github.com/pouchdb/pouchdb/commit/c7c8afb15f466c4846cc24a55155fc80094a5043) chore: remove `clone-buffer polyfill` (#8957)
* [ef655ecc](https://github.com/pouchdb/pouchdb/commit/ef655ecc55d01eb8d9664065fcc82e6a8c43b092) chore: remove `AbortController` dependency and polyfills
* [9a9ff27d](https://github.com/pouchdb/pouchdb/commit/9a9ff27d3020ef807aaa2ed13d1916b0b3ad5c61) chore: remove IE polyfill for `ArrayBuffer.slice()`
* [8739f80f](https://github.com/pouchdb/pouchdb/commit/8739f80f6ce06e158f688073ad6b8697cd8c1174) chore: remove `Set`/`Map` polyfill
* [9c587a64](https://github.com/pouchdb/pouchdb/commit/9c587a640b59aa79984a76f9b6d59a1051c26dd8) pouchdb-find: make `_design/` prefix removal more specific (#8946)
* [0297c6a6](https://github.com/pouchdb/pouchdb/commit/0297c6a6e047d9f1693f0aa03d2d8d1c50407fe0) (#8927) - Set default limit on find queries to 25
* [2e48ed7d](https://github.com/pouchdb/pouchdb/commit/2e48ed7dd47977f3dc1a83e6b54c26aa94978236) pouchdb-utils/flatten: replace with `Array.flat()` built-in (#8929)
* [e5731fae](https://github.com/pouchdb/pouchdb/commit/e5731faecba63814ae7425b3cea98e83fed590b8) Replace `lodash.flatten()` with `Array.flat()` built-in (#8928)
* [7505bedd](https://github.com/pouchdb/pouchdb/commit/7505bedd5464bdce8aedd84fe2ded48ec431718a) `isValidRev()`: reject revs with more than one dash (#8933)
* [3c852034](https://github.com/pouchdb/pouchdb/commit/3c8520344c640e3a739b1ebfec49ae957dad9b37) `db.post()`, `db.bulkDocs()`: throw `INVALID_REV` consistently (#8934)
* [4a765418](https://github.com/pouchdb/pouchdb/commit/4a765418b277ddcf7fa8b54900af30dba00bd6a4) feat: migrate dev dep `watch-glob` with maintained `glob-watcher`
* [06170b67](https://github.com/pouchdb/pouchdb/commit/06170b67ba0a1c0af6dad68852d533c74b753b08) replace the last occurrence of `jsnext:main` (#8663)
* [905dfdfb](https://github.com/pouchdb/pouchdb/commit/905dfdfb3c6c7b6707668e74d8ade12ca5bb881f) `isValidRev()`: cache regex
* [9afecb28](https://github.com/pouchdb/pouchdb/commit/9afecb285ae9d240294219e96b6701716d169831) dev dependencies: replace individual lodash functions (#8907)
* [41cc5687](https://github.com/pouchdb/pouchdb/commit/41cc5687401fbcd88c5f8169e859447714825062) chore(PouchDB-find): purified promise flow (#8860)
* [08649d96](https://github.com/pouchdb/pouchdb/commit/08649d9660263c2054f3676df0822a51a1b7f2fe) adapter-indexeddb: replace var with let/const (#8926)
* [2789b704](https://github.com/pouchdb/pouchdb/commit/2789b704588049b0163aa986ad888cac468272af) indexeddb: improve `allDocs()` perf with skip & key ranges (#8603)
* [95e8c1ee](https://github.com/pouchdb/pouchdb/commit/95e8c1eef5559815958fc1ef8805f1977ae94ad9) chore(PouchDB-find): utils `oneSetIsSubArrayOfOther` loop update (#8921)
* [e69fe210](https://github.com/pouchdb/pouchdb/commit/e69fe21036305e3988bb9a7ef1cf808992476165) chore(PouchDB-find): minor cleanup (#8920)
* [9ba277bd](https://github.com/pouchdb/pouchdb/commit/9ba277bd886054a29c89265d250f847ba56c9846) chore(PouchDB-find): loop updates (#8918)
* [d0eee195](https://github.com/pouchdb/pouchdb/commit/d0eee195e7c2c92d4bda3c9f18bcb86c3b254bd5) chore(pouchdb-find): var -> const/let (#8917)
* [5bc8f319](https://github.com/pouchdb/pouchdb/commit/5bc8f319bc302f0087ea5bfdbed2caccef1af0a0) chore: PouchDB-find abstract-mapper update (#8913)
* [3e3be0be](https://github.com/pouchdb/pouchdb/commit/3e3be0be92f751bde0014dfc1e962f7fc9e02d01) chore: PouchDB-find adapters/local refactor to async/await (#8914)
* [f48c76f7](https://github.com/pouchdb/pouchdb/commit/f48c76f7eb6c1a89ea94e461812085f20f563f89) chore: PouchDB-find validateSelector cleanup (#8915)
* [d3014959](https://github.com/pouchdb/pouchdb/commit/d30149598305a08f5d88046f05f19aa314ec74e5) chore: PouchDB-find adapters/http update (#8912)
* [acc12f69](https://github.com/pouchdb/pouchdb/commit/acc12f69ffd5369468b75f52989c38d5c98c07f1) remove unused devDependency: query-string (#8909)
* [36d042b9](https://github.com/pouchdb/pouchdb/commit/36d042b9d62d859b233c6e6d25658aa889635bb0) update dev dep: marky (#8903)
* [df735024](https://github.com/pouchdb/pouchdb/commit/df7350242501e3f713e29466bb22ffcb6976fdf8) chore(abstract-mapreduce): cleanup taskqueue.js (#8891)
* [9aaba0c8](https://github.com/pouchdb/pouchdb/commit/9aaba0c89d9f5057326a3e0f865d7f7387f939d0) chore(abstract-mapreduce): refactor to for `...` of loops (#8892)
* [96037a7b](https://github.com/pouchdb/pouchdb/commit/96037a7b9918f51a3c56fc35288917b13cc91f75) chore(abstract-mapreduce): reduce repetitive catch handlers (#8889)
* [5f647e52](https://github.com/pouchdb/pouchdb/commit/5f647e52874ba94372d57cc53c8bc1d0feaf399d) Remove legacy polyfill: `Blob.slice()` (#8895)
* [59ac0d3e](https://github.com/pouchdb/pouchdb/commit/59ac0d3ed34fe81d3ff3e29ca68b6452f7c7e57b) Remove legacy util/polyfill: `Object.assign()` (#8896)
* [94eccbb9](https://github.com/pouchdb/pouchdb/commit/94eccbb996c03af160e8001b96bb69d58bc90baa) chore(abstract-mapreduce): replace `var` with `const` (#8880)
* [7b23c81e](https://github.com/pouchdb/pouchdb/commit/7b23c81e548b8b944a44dc8b310528286eef7d62) adapter-indexeddb: use `isLocalId()` (#8883)
* [86b6c5ec](https://github.com/pouchdb/pouchdb/commit/86b6c5ecb84c1895fa3547074c339b275feb4ff7) Checkpointer shortcut (#8856)
* [0f08688f](https://github.com/pouchdb/pouchdb/commit/0f08688ffa50f25cd34d629c25a31da0cda49026) remove isIE (#8867)
* [281c3e11](https://github.com/pouchdb/pouchdb/commit/281c3e1115d371166910e4b8e391ae119c2ad780) Set default opts for `CheckpointerInternal` (#8871)
* [7278ae4e](https://github.com/pouchdb/pouchdb/commit/7278ae4e42e0b152a5bef3d83ee0556e17b0adc6) (#8607) - replace `immediate` with `queueMicrotask`
* [def06b03](https://github.com/pouchdb/pouchdb/commit/def06b03adbf72413750d23911590a42f4d4119f) (#8526): Upgrade leveldown from 5.6.0 to 6.1.1
* [5ea26d55](https://github.com/pouchdb/pouchdb/commit/5ea26d55f41d236c4df65a58214ab73a222191d2) (#8526) - remove outdated `bundle-collapser` and `es3ify`
* [15cd6a03](https://github.com/pouchdb/pouchdb/commit/15cd6a03bc9888991b4904d2be793273aa50bdb7) indexeddb: add c`heckBlobSupport()` (#8804)
* [85ec16ca](https://github.com/pouchdb/pouchdb/commit/85ec16ca145a78f153b34759197432cbf7a966c5) core/adapter: use `findIndex()` (#8791)
* [c91d5eae](https://github.com/pouchdb/pouchdb/commit/c91d5eae36e40a618f5cdbe3489a3f7912ed36a6) Attempting to Make Database Version Staling Clearer (#8812)
* [74d29507](https://github.com/pouchdb/pouchdb/commit/74d295079191c3928c49685b6a6d484d3079ea20) `commonUtils.createDocId()`: simplify with `padStart()` (#8795)
* [2b6219af](https://github.com/pouchdb/pouchdb/commit/2b6219afa9b75a036362ca6e1b00e3593e704b9e) `adapter.getAttachment()`: don't pass rev (#8792)
* [1e69c31b](https://github.com/pouchdb/pouchdb/commit/1e69c31b7c2dd434e60ab713c44883884c1bd0d8) `indexeddb.bulkDocs()`: inline `parseBase64()` (#8793)
* [10d9edc7](https://github.com/pouchdb/pouchdb/commit/10d9edc749129465b13b7a90384afaf20056ad4e) adapter: use `forEach()` instead of `map()` when result not used (#8790)
* [9f01e637](https://github.com/pouchdb/pouchdb/commit/9f01e63766299310d011b81298d0e84bfcae3cab) adapter: simplify `compareByIdThenRev() `(#8787)
* [99f20e52](https://github.com/pouchdb/pouchdb/commit/99f20e52016c311251ab1df2f3b58e503f7e3449) `indexeddb.getAttachment()`: don't open unnecessary transaction (#8786)
* [caa8c9cf](https://github.com/pouchdb/pouchdb/commit/caa8c9cf17592103cc848bf4312db45a31e2a3b1) `idb.allDocs()`: use seqStore.openKeyCursor() in place of openCursor() (#8764)
* [b0f2e57d](https://github.com/pouchdb/pouchdb/commit/b0f2e57df165368deaffdc4a8765bff4555bdbea) `indexeddb.getAttachments()`: reduce selects from `N+1` (#8771)
* [eafc0f14](https://github.com/pouchdb/pouchdb/commit/eafc0f148ea4cc4979f455c0dba198e5abaf8b9c) indexeddb: rename main adapter fn (#8770)
* [1a6a1820](https://github.com/pouchdb/pouchdb/commit/1a6a18204b2f16098d98a161023760f1552f6dab) bin/dev-server: simplify URL logging (#8772)
* [2305addf](https://github.com/pouchdb/pouchdb/commit/2305addfa87b8ffeea7a28c75102d6b90261f03d) adapter-idb/allDocs: simplify `getMaxUpdateSeq()` (#8762)
* [fc12d33f](https://github.com/pouchdb/pouchdb/commit/fc12d33f88cdec27e4beb8baeb83132effff1563) `idb.info()`: use `seqStore.openKeyCursor()` in place of `openCursor()` (#8763)
* [1234036f](https://github.com/pouchdb/pouchdb/commit/1234036fbc81621bf7f0813e722321bedee5d308) get-postfixed-pouchdb-build: show helpful error if version arg missing (#8743)
* [f1a9b896](https://github.com/pouchdb/pouchdb/commit/f1a9b8969f26a950756cbf8b5ef5e11e88335a2c) Remove dependency - `promise-polyfill` (#8643)
* [e8680dde](https://github.com/pouchdb/pouchdb/commit/e8680dde2f23a19014d8b5b285edbb8bd3730e58) (#8685) - `.gitignore`: remove lerna reference
* [1b12b0d4](https://github.com/pouchdb/pouchdb/commit/1b12b0d41db1421dfd460063d0ffa74654c1240c) prevent urls ending with empty `"?"` when no params present
* [0fdd5a8b](https://github.com/pouchdb/pouchdb/commit/0fdd5a8bc73afe5fdb5b87f50b725692934c608a) (#8612) - use `const` where possible
* [e316c88c](https://github.com/pouchdb/pouchdb/commit/e316c88c756435063cbd224ec2187f7e44da5d97) (#8627): Bump `node-fetch` to 2.6.9
* [c5f931a6](https://github.com/pouchdb/pouchdb/commit/c5f931a66c6cde4d01bc49e202119d3950414fdb) `idb.allDocs()`: reference keys consistently (#8578)
* [102b303c](https://github.com/pouchdb/pouchdb/commit/102b303ca2f1de20841fd5d9dc549ee4f858b04e) indexeddb: fix typo in comment (#8604)

### Bugfixes
* [953f3b3f](https://github.com/pouchdb/pouchdb/commit/953f3b3ff0980abdfb75fa98f380a286f559f54d) fix: docs/Gemfile & docs/Gemfile.lock to reduce vulnerabilities
* [8ba73788](https://github.com/pouchdb/pouchdb/commit/8ba73788dd5cd3e51c2c6b13ba78336cd4da58f6) `db.put()`: throw `INVALID_REV` for invalid revs (#8931)
* [18669009](https://github.com/pouchdb/pouchdb/commit/18669009d80fb654bc9815230310b970835e2274) fix: input isn't defined in array case (#8890)
* [e14c5474](https://github.com/pouchdb/pouchdb/commit/e14c547471df732d06568775317678a9fa41a8f4) fix: upgrade `fetch-cookie` from 2.1.0 to 2.2.0 (#8859)
* [34cb6911](https://github.com/pouchdb/pouchdb/commit/34cb69117931d4b520ee8d7a6208eb0f33da8ec7) (#8525) - Fix compaction from the last `last_seq`
* [14a566f2](https://github.com/pouchdb/pouchdb/commit/14a566f2e7bb780c1af37fd468f419f029a0adc5) eslint: add rule: object-shorthand; fix violations (#8794)
* [d9ee8e0f](https://github.com/pouchdb/pouchdb/commit/d9ee8e0f502561937fd827de45fc3cdf06d2c63d) indexeddb: prevent collisions in `find()` (#8807)
* [04a1735c](https://github.com/pouchdb/pouchdb/commit/04a1735cef289c2dd6f4dd05b6e65ae6bfac1267) indexeddb/rewrite: fix comment typo (#8809)
* [e28a62a9](https://github.com/pouchdb/pouchdb/commit/e28a62a9627d2e958582126f88b773b5203d5c16) (#8706) - Handle null options in 'get' method

### Documentation
* [51380f90](https://github.com/pouchdb/pouchdb/commit/51380f909b1af482d0a5c92e8fc3f4493ca8b808) fix(docs): update testing docs to match reality after #8569
* [d4dab681](https://github.com/pouchdb/pouchdb/commit/d4dab681bb4f05c3c624b685cbff34c31c166bf3) Pat Helland's blog is no longer available
* [d62526d3](https://github.com/pouchdb/pouchdb/commit/d62526d3a77f44524f90c1430eeb630294c3bfb1) docs: replace `var` in with `let`/`const` (#8932)
* [63c856fa](https://github.com/pouchdb/pouchdb/commit/63c856fa912a4fd022dfd5bd305bee733883eb38) fix: remove dead `Debug mode` link (#8916)
* [bdb56789](https://github.com/pouchdb/pouchdb/commit/bdb56789985d5c9c042498536652ec37ee0f218f) README: update Getting Help links (#8888)
* [230e9f66](https://github.com/pouchdb/pouchdb/commit/230e9f6634ad2fbc1d529f7dca9404417ce5cf6b) README: Getting Help: remove glitch.com reference (#8887)
* [6d9d5e14](https://github.com/pouchdb/pouchdb/commit/6d9d5e145de3bfcb486c0cfaef0363319fcdedcd) pouchdb-find/README: remove outdated links to old repo (#8875)
* [9757c0ba](https://github.com/pouchdb/pouchdb/commit/9757c0ba12fc5b0279caca67b41783496e7e7454) ci: use minified plugins if using minified core (#8870)
* [04e82714](https://github.com/pouchdb/pouchdb/commit/04e827147bfbc4d02921b4064d1e8d5bc972a50f) fix assert in error handler results in out of bound exception (#8861)
* [88527c32](https://github.com/pouchdb/pouchdb/commit/88527c3209fce7522e2c875c8f0d9a3415fd6bc4) Clarify the semantics of `since` (#8624)
* [4a05b536](https://github.com/pouchdb/pouchdb/commit/4a05b53659ea59a3e1167e8daeb18a44eb34b68a) spelling: update docs, comments (#8831)
* [741fcc1e](https://github.com/pouchdb/pouchdb/commit/741fcc1e44b8c9c60c3b90232057892a9cc6affd) docs: remove sentence (#8830)
* [c469b042](https://github.com/pouchdb/pouchdb/commit/c469b04203e93cc5e0165bfd97e15719aceda9ac) spelling: dont -> don't (#8829)
* [dabd30ac](https://github.com/pouchdb/pouchdb/commit/dabd30ac84cf64b491026fa83e2b862a4106dce6) spelling: comments & docs (#8828)
* [6f3e8ab2](https://github.com/pouchdb/pouchdb/commit/6f3e8ab29e6c0c0107710e59b85a1bdd255d450c) spelling: checkpoint (#8827)
* [a480a525](https://github.com/pouchdb/pouchdb/commit/a480a5253cfaa03fd62c948b0ee2cf73d473123b) fix spelling(docs,comments): wtih -> with (#8822)
* [102a1e39](https://github.com/pouchdb/pouchdb/commit/102a1e39efafa31ca1d21fc8f73ef2c950f4dd3b) immediate dependency: update documentation (#8815)
* [bae22f1a](https://github.com/pouchdb/pouchdb/commit/bae22f1aa594e0f1c777d0f292d9fd1e5990d7ec) docs: reflect CI move travis to GitHub actions (#8798)
* [1c697dc2](https://github.com/pouchdb/pouchdb/commit/1c697dc27ff5ebf1341a7e19eb2aa6cd68bc158f) Remove Saucelabs references from docs (#8800)
* [c0565394](https://github.com/pouchdb/pouchdb/commit/c0565394ec4e98fa8fafa03452a12069dc5bd23b) (#8748) - Fixing some non-function links in documentation + some http -> https
* [afbcf027](https://github.com/pouchdb/pouchdb/commit/afbcf0272a4571a3adcc65aae797541f35dbb4fe) Remvove Promise polyfill mention from docs (#8736)
* [d67ff087](https://github.com/pouchdb/pouchdb/commit/d67ff0874d2727833a61783c958e00f9e1eecac7) docs: standardise docs.couchdb.org links (#8745)
* [c11c4358](https://github.com/pouchdb/pouchdb/commit/c11c4358d6b186bf80064e064efb666390a2e41f) (#8742) - fix dead link in docs
* [43b77da0](https://github.com/pouchdb/pouchdb/commit/43b77da075a7f7cd175d34d57e4259be4e0b4204) Remove TODO.md
* [babba217](https://github.com/pouchdb/pouchdb/commit/babba217bd4b55704f4366fdca94386b9fcfcc19) (#8716) - update Committer guidelines
* [171f80ee](https://github.com/pouchdb/pouchdb/commit/171f80ee9f2183beca849a8f463ea25ff4fa31de) (#8732) - guides/queries: make link consistent
* [18042829](https://github.com/pouchdb/pouchdb/commit/180428291cd81e092588930f854216c860ba5bcb) chore(#8725): remove references to TonicDev
* [307dea3a](https://github.com/pouchdb/pouchdb/commit/307dea3a72008b6e578c3783d7551b877329d871) docs(#8722): fix image baseurls
* [4498dcdd](https://github.com/pouchdb/pouchdb/commit/4498dcdda1ed98c020ad0a4f87d90241864e34a5) docs(#8721): include `baseurl` for favicon
* [58e408c5](https://github.com/pouchdb/pouchdb/commit/58e408c5513b5ff251edc9ce2b02be4850ee9369) (#8668) - fix typo in attachments guide
* [33b5ffc3](https://github.com/pouchdb/pouchdb/commit/33b5ffc315d6fe49a48c26992b8cc04b984e197c) (#8402) - add note to docs regarding `jwt` usage

### Automated Tests & Build System
* [7d71f444](https://github.com/pouchdb/pouchdb/commit/7d71f444e61cc6b4d5da14998a959bb62a0bfb09) update CI workflow node environments to 18 and 20
* [1cfbadc3](https://github.com/pouchdb/pouchdb/commit/1cfbadc3bf5a9964219b7d71a105becf2328da4d) build: harden `ci.yml` permissions
* [f2401be4](https://github.com/pouchdb/pouchdb/commit/f2401be4261e236725c00fcb0b03644fd530662b) chore(ci): remove PouchDB-Server
* [84b7afbb](https://github.com/pouchdb/pouchdb/commit/84b7afbbd72204d387c3d0315b2eb78b5333c6fc) fix: remove out of date test and flakey mocking lib
* [bb10785b](https://github.com/pouchdb/pouchdb/commit/bb10785bb47ac7349919cd08e830fb630612f6d6) fix: use universally portable shebang
* [20a5ccc3](https://github.com/pouchdb/pouchdb/commit/20a5ccc3870a328a1cc3d4e91694b5301c120c1f) `NOT_AN_OBJECT`: throw for null; add additional tests (#8930)
* [db193f5c](https://github.com/pouchdb/pouchdb/commit/db193f5c1f9f531020f375c0422636948b4c8e5f) `test.slash_id`: assert `getAttachment()` result (#8923)
* [43193de2](https://github.com/pouchdb/pouchdb/commit/43193de2489881b24efb24d50067d2c75c72586a) Add tests for attachments on local docs (#8897)
* [29d568e0](https://github.com/pouchdb/pouchdb/commit/29d568e0643f5b98f9305ae5a1ee87089fdde5be) `test.slash_id`: fix test name (#8924)
* [3aa44a0c](https://github.com/pouchdb/pouchdb/commit/3aa44a0c03e3e909bb29cc66e0e1e49af03e40a2) tests/perf: remove firefox bug workaround (#8904)
* [d8c79fe7](https://github.com/pouchdb/pouchdb/commit/d8c79fe7e6b260f92e2d817af7bf2fb52b741bdc) repeat-perf-test: allow specifying adapters (#8911)
* [032ac45e](https://github.com/pouchdb/pouchdb/commit/032ac45e6a9c181c082646a11c900d4ebedba83a) ci: disable checkout.persist-credentials (#8882)
* [799c564e](https://github.com/pouchdb/pouchdb/commit/799c564e1e9e996f31664c1e7f6b9db2ed4c36fc) test-browser: improve unhandled error debugging (#8826)
* [3deef61f](https://github.com/pouchdb/pouchdb/commit/3deef61f1d03572e97e68577151ba1e734447216) Reduce ci overhead (#8866)
* [66852032](https://github.com/pouchdb/pouchdb/commit/668520327ab1de81aa731498c5198264ffc96758) Add script: repeat-perf-test.sh (#8760)
* [1f581739](https://github.com/pouchdb/pouchdb/commit/1f5817390ddc91278e5182cfd434ed52a279fb12) ci: don't rebuild when running dev-server (#8874)
* [c792a33c](https://github.com/pouchdb/pouchdb/commit/c792a33c9ab9b10a4913408874440ec67ae046fc) tests: show unminified stacktraces for Errors (#8841)
* [5cd750f6](https://github.com/pouchdb/pouchdb/commit/5cd750f60ca5ba1bde7bd34ec8a93806e686fe79) perf-tests: fix JSON reporter (#8876)
* [7e15d3b7](https://github.com/pouchdb/pouchdb/commit/7e15d3b72cbef4582c1e45d1c72ff0e3b23d4f5b) chore(test): update playwright dep (#8821)
* [99a64240](https://github.com/pouchdb/pouchdb/commit/99a642408cf7547eaa818e65e96f224389d46f2a) chore(ci): upgrade node actions to node v20 (#8857)
* [1a064d83](https://github.com/pouchdb/pouchdb/commit/1a064d83be300cbb52201b434b74f5285667d8d8) (#8863) - fix subsequent fails of `5007 sync 2 databases`
* [340635f4](https://github.com/pouchdb/pouchdb/commit/340635f4fc52013eb511a355d206557510346b54) (#8862): Fix timeout of `test.issue3179.js` conflicts synced live sync
* [1d1a08e4](https://github.com/pouchdb/pouchdb/commit/1d1a08e477b8abcfc8361875036219ea29fcda4a) test-browser: fix indentation (#8851)
* [d1f6cdda](https://github.com/pouchdb/pouchdb/commit/d1f6cddabba2bf27a9a3165e4000d2f630e712c1) ci: run tests in webkit (#8805)
* [366e86a4](https://github.com/pouchdb/pouchdb/commit/366e86a4c77fad6623471faf1730b617172b861f) test-browser: add try/catch (#8824)
* [75070d6c](https://github.com/pouchdb/pouchdb/commit/75070d6c1cf67f04fc4aa5ebef810aa07af23138) test: remove whatwg-fetch polyfill (#8825)
* [fe0905d1](https://github.com/pouchdb/pouchdb/commit/fe0905d1ee928e3ae460a5d4c72e5d3d8dfab48b) ci: add shellcheck; fix violations (#8753)
* [5054bf82](https://github.com/pouchdb/pouchdb/commit/5054bf8236a33d20533c6c811af51755768ed9af) tests: use `done()` when closing express servers (#8840)
* [c7054c29](https://github.com/pouchdb/pouchdb/commit/c7054c294543b7db784d5f03bece9a8fabdd9be3) mocha v10: fix failure handling (#8844)
* [a6b47e29](https://github.com/pouchdb/pouchdb/commit/a6b47e291ff210c05d2e767b6ca70c2eb7467e66) chore(test): update `mocha` from v3.5 to v10 (#8838)
* [519e3316](https://github.com/pouchdb/pouchdb/commit/519e33168e27f8e44eb6e56a9facdcaae2d19cea) playwright: handle `externally-triggered browser-close` event (#8836)
* [e90267b6](https://github.com/pouchdb/pouchdb/commit/e90267b69a76e39c3675ddc770fdd6e6f09d5fc0) chore: upgrade `fetch-cookie` from 0.11.0 to 2.1.0
* [b0879cb5](https://github.com/pouchdb/pouchdb/commit/b0879cb5945e67f05198f9e88f422aec3efec539) test.migration: move `before()` above `beforeEach()` (#8832)
* [dc97aedf](https://github.com/pouchdb/pouchdb/commit/dc97aedf449a94b87f074f3aa975b5412415706a) test-browser: use native event handling (#8823)
* [a630555f](https://github.com/pouchdb/pouchdb/commit/a630555f9ab7164f4c442b11a016479f3cf9b20f) test-browser: work around weird webkit behaviour (#8802)
* [26e33960](https://github.com/pouchdb/pouchdb/commit/26e339609ad392e642dd921cdd4e93731d2f18ff) eslint: set globals readonly (#8818)
* [9618a042](https://github.com/pouchdb/pouchdb/commit/9618a0429406b2742670b214451c8fe920a9e064) eslint: separate test config from root config (#8817)
* [24e6400b](https://github.com/pouchdb/pouchdb/commit/24e6400bd705752189e7030afe58b1a0b270f2bf) tests/performance: fix use of `this.iterations` in setup/tearDown (#8777)
* [154440f0](https://github.com/pouchdb/pouchdb/commit/154440f0889398c787ca0f0808e9f8c627da5973) eslint: comma-dangle: only allow for multiline declarations (#8846)
* [b8a29852](https://github.com/pouchdb/pouchdb/commit/b8a298528b0ecf179467c1cfe63863d631aa67a1) tests: remove commonUtils.Promise (#8776)
* [60bf1021](https://github.com/pouchdb/pouchdb/commit/60bf1021bb7725308291a9078c574f073b8d5dc9) test.changes: fix case ddoc without filters+key (#8775)
* [70bd2afc](https://github.com/pouchdb/pouchdb/commit/70bd2afcdc908bc4cb964dde15544ca1eb1f1654) tests/perf: fix doc creation in basic-gets (#8797)
* [288714dc](https://github.com/pouchdb/pouchdb/commit/288714dcc3fea36466d934dfcabfa9a46b80cd2d) tests/perf: document pull-replication-perf-skimdb (#8796)
* [43e6160a](https://github.com/pouchdb/pouchdb/commit/43e6160af35c94564056ea4ce0c7148f80bd0e22) tests/performance/utils: use `commonUtils.params()` (#8780)
* [2f5a5f66](https://github.com/pouchdb/pouchdb/commit/2f5a5f668590f4518ac03266388f7d3ef825274f) test.browser.worker: use same PouchDB src as other tests (#8782)
* [4f45948f](https://github.com/pouchdb/pouchdb/commit/4f45948f53bd100e7c3365eee1e9adb10ce993f5) tests/common-utils: parse query string w/ `URLSearchParams` (#8779)
* [775b2e1a](https://github.com/pouchdb/pouchdb/commit/775b2e1aee3ec63c44db0eeac408737fd944eede) test-browser: catch-and-fail on unhandled error (#8768)
* [5b9abdb4](https://github.com/pouchdb/pouchdb/commit/5b9abdb463e0a0e67c8cb20029c716ab03f9b657) eslint: add rule: no-undef-init (#8758)
* [48bef766](https://github.com/pouchdb/pouchdb/commit/48bef766b529a684b2c726f43a4f4164e36fe135) tests/perf: support regex in GREP option (#8784)
* [72a9b94c](https://github.com/pouchdb/pouchdb/commit/72a9b94c26c4bf41e4b8e7cb36941edf7e72f361) tests/browser.worker: parse query string w/ `URLSearchParams` (#8781)
* [105b735f](https://github.com/pouchdb/pouchdb/commit/105b735f66f566acbbb2515c541cc8227b71070b) tests/browser.migration: test local docs with attachments (#8785)
* [2b050594](https://github.com/pouchdb/pouchdb/commit/2b05059497ff0e05b9cab7fd8765ac1432139177) test-browser: simplify building query string (#8773)
* [c89f4079](https://github.com/pouchdb/pouchdb/commit/c89f4079bdc25961357e01a47cf31914309bb5f9) test.retry: skip "destroyed" event listener leak test (chrome+indexeddb) (#8765)
* [d2f6bcf4](https://github.com/pouchdb/pouchdb/commit/d2f6bcf478f61e3c98bdfc974ff003958f2fd43a) test.issue3179: fix: allow test to run in browsers (#8769)
* [6c5aa2b5](https://github.com/pouchdb/pouchdb/commit/6c5aa2b5110c6b275070c185036490947e28e040) tests/browser.migration: compare version parts as numbers not strings (#8767)
* [2dfadd17](https://github.com/pouchdb/pouchdb/commit/2dfadd174b58f6fe439a97e62cf3dacea010198d) tests/browser.migration: also run with indexeddb (#8766)
* [7d874a1f](https://github.com/pouchdb/pouchdb/commit/7d874a1f57aab1559632e9bbba2a623201b99e14) perf-tests: add option to save benchmarks to file (#8759)
* [cb5cd952](https://github.com/pouchdb/pouchdb/commit/cb5cd9521ff90cef6f20ac1f70f322cbbf8c5a73) run-test: echo `COUCH_HOST` value when waiting (#8761)
* [ad98df00](https://github.com/pouchdb/pouchdb/commit/ad98df00607755fe31cf72afa0444088e30c442b) tests/integration: move isSafari checks to testUtils.isSafari() (#8756)
* [197fcc40](https://github.com/pouchdb/pouchdb/commit/197fcc409b97208e1c1b4ecb50669402a1aeb17e) tests/integration: rename `leveldown.migration.js` (#8755)
* [238dc24d](https://github.com/pouchdb/pouchdb/commit/238dc24ddf2dbeb87a2c5f031d8d8ddfb7fcf690) tests/integration: use `asyncLoadScript()` (#8751)
* [aa6d500e](https://github.com/pouchdb/pouchdb/commit/aa6d500eabe89b252613fa78c6685178a8ee136b) test.migration: simplify scenario/constructor mapping (#8750)
* [6e705dfb](https://github.com/pouchdb/pouchdb/commit/6e705dfb7d52964e03017ea937e55e7a2ca53259) test.migration: simplify version number checks (#8749)
* [a48c28f1](https://github.com/pouchdb/pouchdb/commit/a48c28f1f236beced9ad72ec6b933e2b67f7ff7e) test/browser.migration: use `this.skip()` (#8744)
* [02ca4e3c](https://github.com/pouchdb/pouchdb/commit/02ca4e3c1dc356501703e8b098dcba5b2007485f) ci: test docs (#8747)
* [642d3500](https://github.com/pouchdb/pouchdb/commit/642d3500f42c09583e6cb06d378b35f9284df4ab) only build docs when triggered
* [4f3a9260](https://github.com/pouchdb/pouchdb/commit/4f3a9260549d3312183d6cf59ad5beb1130df440) (#8717) run-test.sh: always shut down server on exit
* [12974e07](https://github.com/pouchdb/pouchdb/commit/12974e07aa02de3baccf128a4808cda0614cb43f) (#8569) - Switch browser tests to playwright
* [2d78ed93](https://github.com/pouchdb/pouchdb/commit/2d78ed939636fb41164441a4fb6a63c1054f1d2b) test.retry: clarify` event-listener-leak` test names
* [98097033](https://github.com/pouchdb/pouchdb/commit/980970331b232969824df71df7bf0bf8cf19053f) Explicitly skip browser.worker tests (#8682)
* [78d17872](https://github.com/pouchdb/pouchdb/commit/78d1787262e25446b864b569d7c9adec6bd8f902) (#8703) - tests/integration: decrease default test timeout
* [e6b8c937](https://github.com/pouchdb/pouchdb/commit/e6b8c9371a6e5682e35b368b2ababb4a288a17a5) (#8688) - test.issue3179: assert that conflicts exist
* [27ab3b27](https://github.com/pouchdb/pouchdb/commit/27ab3b27a6673038b449313d9700b3a7977ac091) (#8686) - tests: safely de-reference `PromiseRejectionEvent`
* [28f4f768](https://github.com/pouchdb/pouchdb/commit/28f4f76810fcb2f318569c455b2b130fe6d4bae8) (#8684) - remove cordova test references
* [c8e532e4](https://github.com/pouchdb/pouchdb/commit/c8e532e4d817aa6d6122f7944967c0293c3a26a9) (#8676) - browser.worker test: dereference globals safely
* [4751ebdf](https://github.com/pouchdb/pouchdb/commit/4751ebdf0d6a153b3b330796aee57223834016c8) (#8674) - jshint: remove legacy inline directives
* [74c49df3](https://github.com/pouchdb/pouchdb/commit/74c49df395b3cc73e96b0ff4757cbc701f0c788d) (#8667) - test-webpack: fail if git working tree is dirty
* [ba74ebe3](https://github.com/pouchdb/pouchdb/commit/ba74ebe3e1ed73808836e3b7228e1bb79250b1f8) (#8670) - test-webpack: don't save new dependencies
* [6daf0c01](https://github.com/pouchdb/pouchdb/commit/6daf0c0148137c24d28b31988ad6fd47384ca83e) (#8672) - eslint: introduce rule: no-trailing-spaces
* [2876834b](https://github.com/pouchdb/pouchdb/commit/2876834bd0860cf97bf2f451f06988753ad56da9) (#8671) - eslint: introduce rule: eol-last
* [3d407892](https://github.com/pouchdb/pouchdb/commit/3d4078921a614091da329575b54d2e72e9f01174) (#8645) - test-webpack: don't rebuild node
* [e1fbbb41](https://github.com/pouchdb/pouchdb/commit/e1fbbb41911cf513a22e82568a1173a0d134fc0a) (#8651) - restructure async handling of test.viewadapter
* [080b8a93](https://github.com/pouchdb/pouchdb/commit/080b8a930e03ac74c99fa821309b3cdcebe5ed3a) (#8655) - remove deprecated usage
* [0ef150fa](https://github.com/pouchdb/pouchdb/commit/0ef150fa86b5e3d50e13d693878c27c057bc2892) (#8652) - only run test.viewadapter for expected adapters
* [546c8bb6](https://github.com/pouchdb/pouchdb/commit/546c8bb696872f86816574d02d47131ace0b4d18) (#5798) - set terser to minify with option `ascii_only=true`
* [aca46756](https://github.com/pouchdb/pouchdb/commit/aca46756644b1a4786d41229e7db5d14fce1680c) (#8656) - fix concurrent test-server errors
* [4c92c946](https://github.com/pouchdb/pouchdb/commit/4c92c946b1de8600ac338ff78c2c2bf4ef7910b7) (#8646) - standardise shell shebangs
* [90ea8c17](https://github.com/pouchdb/pouchdb/commit/90ea8c17a332cc2a8e5b31824e8faae0d8c45e47) (#8649) - fix build and test warnings
* [5f59f248](https://github.com/pouchdb/pouchdb/commit/5f59f2489ba6d9de2be96f0affe9d1b1b9cddfb5) ci: add NodeJS v16 to test matrix (#8616)
* [4f39bd25](https://github.com/pouchdb/pouchdb/commit/4f39bd25d855f6efbc7436631b53e950b2c9792f) (#8602) - fix tests for local doc IDs
* [8896707f](https://github.com/pouchdb/pouchdb/commit/8896707fbfb0ba0443bb53af08f59b353c88c427) test/integration/deps: add script: `get-postfixed-pouchdb-build` (#8622)
* [71501f89](https://github.com/pouchdb/pouchdb/commit/71501f893b6352d31d297f3a9fbca1832ca5c054) perf-tests: allow running specific suite(s) (#8592)
* [ba0a1060](https://github.com/pouchdb/pouchdb/commit/ba0a10600403739c476fc42ab505d259521b9fe3) Remove legacy script: `start_standalone_couch.sh` (#8635)
* [9d9c1000](https://github.com/pouchdb/pouchdb/commit/9d9c10000bb4f760c55a0e71edda0a44ad8e10a4) Remove script: bundle-browserify-test.sh (#8634)
* [30c49354](https://github.com/pouchdb/pouchdb/commit/30c49354d3005a4162cba54e6ae0846fba610d95) Remove unused script: jenkins-deploy.sh (#8632)
* [9b481e5b](https://github.com/pouchdb/pouchdb/commit/9b481e5b3ca742b61c0e544dd288e4dfdd4d7d19) Add migration tests for v7 & v8 (#8625)
* [44db15a4](https://github.com/pouchdb/pouchdb/commit/44db15a45612fbd19b957d199ff0f72431dfc3ea) Remove unused script: baldrick-test.sh (#8633)
* [81f22d68](https://github.com/pouchdb/pouchdb/commit/81f22d6829e2fbbddf48670cd3040668294a3a18) Use shells specified in shebangs (#8572)
* [ccccfb83](https://github.com/pouchdb/pouchdb/commit/ccccfb83b89d2cd87181dfae626fe872441ff127) browser-tests: remove saucelabs support (#8577)
* [9a41ca58](https://github.com/pouchdb/pouchdb/commit/9a41ca5894ca5a9daf3045f815271c807163431b) perf tests: enable in-browser performance profiling (#8579)
* [9e307c3b](https://github.com/pouchdb/pouchdb/commit/9e307c3bb7fdf45d074ed057e74a477e21efa319) Use shebang-defined shell for verify-bundle-size (#8644)

## Get in touch

As always, we welcome feedback from the community. Please don't hesitate to [file issues](https://github.com/pouchdb/pouchdb/issues), [open discussions](https://github.com/pouchdb/pouchdb/discussions) or [get in touch](https://github.com/pouchdb/pouchdb/blob/master/CONTRIBUTING.md#get-in-touch). And of course, a big thanks to all of our [new and existing contributors](https://github.com/pouchdb/pouchdb/graphs/contributors)!