---
layout: post

title: PouchDB 8.0.0 — Modernizing PouchDB
author: Alba Herrerías

---

We are thrilled to announce the release of PouchDB's new major version 8.0.0. For a full changelog from 7.3.1 to 8.0.0, please see [the releases page](https://github.com/pouchdb/pouchdb/releases) or view the [latest commits](https://github.com/pouchdb/pouchdb/compare/7.3.1...8.0.0). Here are the highlights:

## Embracing modern ES6+ JS syntax

We have started the process of moving to ES6+ syntax. We made refactors to use native JS classes instead of prototypes, deprecated some packages that implemented features that are now built in the language ([`inherits`](https://github.com/pouchdb/pouchdb/commit/50d2c33a9c262b0d44c39abb5c40c6685e3fcd8e), [`argsarray`](https://github.com/pouchdb/pouchdb/commit/4974b64a67723fc8ec2d471c0590502dfe104760)), and started in packages such as `pouchdb-abstract-mapreduce` and `pouchdb-adapter-http`. We encourage you to embrace the syntax in your new contributions and, if you can, contribute to the refactoring effort. 

This might mean a **potentially breaking change**, therefore we bump the major version. If you need to support ES5 we recommend you use a transpiler. 

## Add `activeTasks`

[#8422](https://github.com/pouchdb/pouchdb/issues/8422) [#8441](https://github.com/pouchdb/pouchdb/issues/8441) Analogous to the `_active_tasks` feature in CouchDB, PouchDB now has `activeTasks`. With this functionality, PouchDB is able to list all active database tasks, like `database_compaction`, `view_indexing`, or `replication`. PouchDB will report the progress of these tasks to the active tasks API and remove tasks as soon as they are completed or have failed.

Example usage:
```js
let tasks = PouchDB.activeTasks.list()
```

Example result:

```js
[{
  "id": "d81fea92-8ce4-42df-bb2b-89a4e67536c3",
  "name": "database_compaction",
  "created_at": "2022-02-08T15:38:45.318Z",
  "total_items": 12,
  "completed_items": 1,
  "updated_at": "2022-02-08T15:38:45.821Z"
}]
```

## Add `purge` to the `indexeddb` adapter

[#8453](https://github.com/pouchdb/pouchdb/pull/8453) Similar to CouchDB's `purge`, PouchDB has now `purge` for its `indexeddb` adapter.

Purge permanently removes data from the database. Normal deletion with `db.remove()` does not, it only marks the document as `_deleted=true` and creates a new revision. This behaviour ensures that deletes can be replicated across databases, and deleted documents don’t get undeleted by syncing with a database that still has this document.

`db.purge()` is not intended as a regular method for deleting documents, instead, it is meant as an admin function for cases where some secret was erroneously added to the database and must now be removed completely, eg. a credit card or social security number. Purge effectively puts the database in a state where the offending write never happened.

Example usage:

```js
try {
  const result = await db.purge('mydoc', '6-3a24009a9525bde9e4bfa8a99046b00d');
  // handle result
} catch (error) {
  // handle error
}
```

Example result:

```js
{
  "ok": true,
  "deletedRevs": [
    "6-3a24009a9525bde9e4bfa8a99046b00d",
    "5-df4a81cd21c75c71974d96e88a68fc2f"
  ],
  "documentWasRemovedCompletely": false
}
```

## Improving publishing packages
[#8576](https://github.com/pouchdb/pouchdb/pull/8576) Previously, if publishing packages failed part-way through, the release script halt and the remaining packages needed to be published by hand. With this improvement the script can be run again to publish the remaining packages.

## Changelog

### New features

* [0680c0ac](https://github.com/pouchdb/pouchdb/commit/0680c0acad8ba12bbe7af28ffef7e2de51f8d1d8) feat(core): simple active tasks implementation
* [c3fc43cc](https://github.com/pouchdb/pouchdb/commit/c3fc43cc1264406e50bb701981a84e3f7bcae0f8) feat: use activeTasks error handling
* [9a83c11f](https://github.com/pouchdb/pouchdb/commit/9a83c11f3f3d5905dfb2570bc9b6600a4b4bd96b) feat(core): activeTasks remove reason argument
* [40dc6b37](https://github.com/pouchdb/pouchdb/commit/40dc6b37e273d08d27afa1a09759997d92d91aa9) feat(replicate): track live replications in activeTasks
* [f5b6d35e](https://github.com/pouchdb/pouchdb/commit/f5b6d35ee3a3c4e036f9724543ec2cc0df8c692b) feat(core): view indexing use activeTasks API
* [d784b49a](https://github.com/pouchdb/pouchdb/commit/d784b49a956d82c4821ed675a51a0f053680e9c7) feat(replicate): replication uses activeTasks API
* [52a52495](https://github.com/pouchdb/pouchdb/commit/52a52495304ae810aac1f5bddb5af2a6d59457e7) feat: database compaction use activeTasks API
* [ed0db363](https://github.com/pouchdb/pouchdb/commit/ed0db363f959eb866c94339efcfb0c9bab26456b) feat(core): make activeTasks.list() return array
* [eaf9d52f](https://github.com/pouchdb/pouchdb/commit/eaf9d52fd50b37c1b75bc46d1ebdf0ffd16f0fd3) feat(core): active tasks `created_at/updated_at` naming
* [544eb77d](https://github.com/pouchdb/pouchdb/commit/544eb77d1f2ca6fc33eebc2511920af5f6806b68) feat(purge): add purge to core
* [ec1b7872](https://github.com/pouchdb/pouchdb/commit/ec1b7872264d850a10afb584e3afc147af76ac40) chore(purge): remove only from purge tests
* [3445a012](https://github.com/pouchdb/pouchdb/commit/3445a012d7d51de7afbaa2eea4c18e85a5fde992) feat(indexeddb): proof-of-concept purge method
* [e861d00f](https://github.com/pouchdb/pouchdb/commit/e861d00fe0fc15137630fb238d0dd5668b0efe86) wip(indexeddb): stub `_purgeRev` method
* [972ae331](https://github.com/pouchdb/pouchdb/commit/972ae331dc731445a48f37de729bd5a1737a9864) wip(merge): findPathToLeaf, removeLeafFromTree
* [4e921ebd](https://github.com/pouchdb/pouchdb/commit/4e921ebdfa224e8ed850bc91d3cb0927bf4522b9) feat(merge): removeLeafFromTree return empty trees
* [3e3f7613](https://github.com/pouchdb/pouchdb/commit/3e3f7613cb34c2e09b936feddfda0ad5f42dfe29) feat: make purge delete docs if tree is empty
* [a8b5e00c](https://github.com/pouchdb/pouchdb/commit/a8b5e00c046baf223f2d726bf43422e10a9c4fde) feat(indexeddb): attachment purging
* [693ea5c1](https://github.com/pouchdb/pouchdb/commit/693ea5c17d222ab2dce72131e4cd71005ef85541) feat(purge): handle missing doc, return something
* [774976a0](https://github.com/pouchdb/pouchdb/commit/774976a02781c3953727244706adfb0d5cce420a) feat: on-update view purging
* [94ec8932](https://github.com/pouchdb/pouchdb/commit/94ec8932fd79a2993c82a5381ae34d64c286375f) feat(core): `purged_infos_limit` support
* [ce8f8b30](https://github.com/pouchdb/pouchdb/commit/ce8f8b308f4509def96272693f797deac05b55e0) [wip] Purge leaves from multiple roots
* [4252a0f0](https://github.com/pouchdb/pouchdb/commit/4252a0f0ba71ab63f493709fe81e5e63baeb5dee) docs(purge): show result object separately
* [b856173b](https://github.com/pouchdb/pouchdb/commit/b856173b436c201d86c0c63319eaf0dc8396a772) chore(purge): add code comments
* [d5f4250a](https://github.com/pouchdb/pouchdb/commit/d5f4250a3539b62c430203441bcb02fa41e00ae2) chore(purge): remove unneeded logs and comments
* [2c0ddbb0](https://github.com/pouchdb/pouchdb/commit/2c0ddbb01e9d01ba2b4ccc754ff855a15173208c) feat(purge): simplify implementation of removeLeafFromTree()

### Bugfixes

* [34a79749](https://github.com/pouchdb/pouchdb/commit/34a797499b82df58c9005ee6dc4d5f179d4f6ebd) fix: check replication currentBatch
* [8f33ff0a](https://github.com/pouchdb/pouchdb/commit/8f33ff0a3b2042de51bc59bb570516fdc6a20d92) fix: add activeTask stub to mock replication database
* [3fe71b03](https://github.com/pouchdb/pouchdb/commit/3fe71b036a37f3cf983f47937bd9ccd0788fead6) ([#8491](https://github.com/pouchdb/pouchdb/issues/8491)) - Fix $regex and $ne within $or operator
* [86ccf481](https://github.com/pouchdb/pouchdb/commit/86ccf4811b7d420d865f86fbef62280ff3c83d88) fix(core): active tasks object datastructure
* [5f61b1fe](https://github.com/pouchdb/pouchdb/commit/5f61b1fe128bb6091d28555ee8d44f185371923f) fix partial filter find on indexeddb adapter
* [759ea5a0](https://github.com/pouchdb/pouchdb/commit/759ea5a0c0c6a7518fb9efbc0404a81959127448) fix: store `partial_filter_selector` in ddocs
* [9519c748](https://github.com/pouchdb/pouchdb/commit/9519c748c48cbac41451039765c758e5987bbc57) fix: active tasks race condition
* [25a12e11](https://github.com/pouchdb/pouchdb/commit/25a12e11682aaf462ec62727bfebe29c9c418a06) fix(merge): removeLeafFromTree to properly use branchings
* [d5f29f7b](https://github.com/pouchdb/pouchdb/commit/d5f29f7b73e7d0bea57dfa6398815c22cb5d6dff) fix(indexeddb): rev purging typo
* [f0958b50](https://github.com/pouchdb/pouchdb/commit/f0958b50273c0c16c5277c50069e2c9d2739115a) fix(purge): use callback in adapter
* [b20139e1](https://github.com/pouchdb/pouchdb/commit/b20139e176ea792bf22d263ddb62a646e2c7cd2f) fix(core): purge error values
* [4d11ef51](https://github.com/pouchdb/pouchdb/commit/4d11ef51fc3c275c46d465678cf499e18371744c) fix(a-m-r): purge check return value
* [203ae670](https://github.com/pouchdb/pouchdb/commit/203ae67030473285a3188df23dbfba7a088c4482) fix: remove logging
* [24157fcf](https://github.com/pouchdb/pouchdb/commit/24157fcf27ffa429c248770ee7997a46f3696117) ([#8513](https://github.com/pouchdb/pouchdb/pull/8513)) - Race condition for pouchdb hanging indefinitely when multiple instances are used
* [15092e8e](https://github.com/pouchdb/pouchdb/commit/15092e8eefaac5604afe2155ed7d38872bea40be) chore: catch selenium errors earlier
* [2eca392b](https://github.com/pouchdb/pouchdb/commit/2eca392bfae8c76bfb8d25b75414e5b47381a653) fix: ([#8471](https://github.com/pouchdb/pouchdb/pull/8471)) filterInclusiveStart for nested fields
* [45dc5ae8](https://github.com/pouchdb/pouchdb/commit/45dc5ae81d67ef37f62b06463a0d3a1f03395b6e) Fix the implementation of _bulkDocs() in the http adapter without using adapterFun()
* [fcb71db4](https://github.com/pouchdb/pouchdb/commit/fcb71db4df332afa03c88112af928da6b9b15f52) fix: active task total items calculation ([#8508](https://github.com/pouchdb/pouchdb/pull/8508))
* [76d35e44](https://github.com/pouchdb/pouchdb/commit/76d35e44119cab340a40400e6dff55289cb744b3) fix: replication cancellation race condition ([#8507](https://github.com/pouchdb/pouchdb/pull/8507))

### Documentation 

* [7c6753a6](https://github.com/pouchdb/pouchdb/commit/7c6753a6fd802191d51adcbcf153c5f646786f4d) Mark a few words in the 7.3 post as code so that markdown does not italicise them
* [486076d2](https://github.com/pouchdb/pouchdb/commit/486076d2892a35562aed7804246a1efe70ced41f) Fix formatting of 7.3 release post by adding blank lines
* [c6719367](https://github.com/pouchdb/pouchdb/commit/c6719367d30234f407bb83729ebea9e1cd08e76d) Add new author in the docs
* [9cc72318](https://github.com/pouchdb/pouchdb/commit/9cc72318806cdce5ef0b2916468f5226c1974fb6) Add 7.3.0 release post
* [140896cb](https://github.com/pouchdb/pouchdb/commit/140896cbdff064b5308cc3d55c481f4034855145) feat: update site version to 7.3.0
* [d9c19182](https://github.com/pouchdb/pouchdb/commit/d9c191821eaaf46da1d7b39ed643247d6160cf93) docs: update PouchDB on page
* [2afc29f7](https://github.com/pouchdb/pouchdb/commit/2afc29f7778696d69f8801e32ca3c126f5e5dd1b) docs: release script note
* [861003ad](https://github.com/pouchdb/pouchdb/commit/861003adecaab343ca7f10ae476638dc4f5fb9e3) docs: clarify release process
* [47cb987c](https://github.com/pouchdb/pouchdb/commit/47cb987cecbddb72058a7891e23aebb0f2cd57ca) Add 7.3.1 release post
* [f00d1193](https://github.com/pouchdb/pouchdb/commit/f00d1193ac7df78b44db8302c01f02b585875f00) feat: update site version to 7.3.1
* [0140bfa5](https://github.com/pouchdb/pouchdb/commit/0140bfa57c7100ad72cff65797e953e7bf80b417) docs: active tasks API
* [2de982e5](https://github.com/pouchdb/pouchdb/commit/2de982e557cca2216e874aec36848cfb7d4d0eea) add performance warning for indexeddb
* [5faa060c](https://github.com/pouchdb/pouchdb/commit/5faa060c01b8b6e4a753a90b73fc493ef800334e) docs(purge): add first draft of purge docs
* [3cfb4af4](https://github.com/pouchdb/pouchdb/commit/3cfb4af4c03eb275675f216bcc74db4f23224aab) docs(purge): update docs
* [d1c04dd5](https://github.com/pouchdb/pouchdb/commit/d1c04dd5d96582d8361aed54ab463b8464147ea9) Update attachments.md : outdated external link
* [0200eea4](https://github.com/pouchdb/pouchdb/commit/0200eea4d61c44fa426c81946d230540bc5bc332) Update 2022-04-13-pouchdb-7.3.0.md

### Testing

* [a3bf8ff0](https://github.com/pouchdb/pouchdb/commit/a3bf8ff0862c5918ae2a1a06ef2851bbbc9a0c40) test([#8522](https://github.com/pouchdb/pouchdb/issues/8522)): add failing test for partial index
* [69ce67ad](https://github.com/pouchdb/pouchdb/commit/69ce67ad7409d544f23ce71fe09c482df58490b8) chore(core): lint activetasks code and tests
* [5fd15227](https://github.com/pouchdb/pouchdb/commit/5fd15227832f02818be445dab94feab4b0426f24) test(purge): unit tests for findPathToLeaf util
* [621cf0a1](https://github.com/pouchdb/pouchdb/commit/621cf0a14234869893b08c64626b099a8b6bf5c2) wip: multi-root tree purge tests
* [f28b4ad5](https://github.com/pouchdb/pouchdb/commit/f28b4ad5aebf7f34eff6d8ae164b48cb32472125) [wip] failing test showing bug in tracking node position in removeLeafFromTree()
* [868937d8](https://github.com/pouchdb/pouchdb/commit/868937d8ae47151d39fb5acaa979c4112eed5b73) tests(purge): fix tests for fixed multi-root removals
* [63026167](https://github.com/pouchdb/pouchdb/commit/63026167572f4066643882866c961c7539ce97bc) chore(purge): lint
* [8e83728b](https://github.com/pouchdb/pouchdb/commit/8e83728ba43463dc075c3c121744f46289c44331) perf-tests: make wording clearer for multiple adapters
* [34a8cf52](https://github.com/pouchdb/pouchdb/commit/34a8cf525010c7b498dd2f61096c6c36326c9be5) ([#8568](https://github.com/pouchdb/pouchdb/pull/8568)) - use eslint cache
* [2b9b7fac](https://github.com/pouchdb/pouchdb/commit/2b9b7fac7ee3148b8037a37b41f87f6eb3ef5138) fix(tests): reformat tree fixtures
* [581c1048](https://github.com/pouchdb/pouchdb/commit/581c104883968ad2d03336068be632021560cad6) feat(tests): purge integration tests
* [df77ecbf](https://github.com/pouchdb/pouchdb/commit/df77ecbfb7dc04ff5c8c765a1858c5ba2bf016ab) refactor a test that timeout to use async
* [404346bb](https://github.com/pouchdb/pouchdb/commit/404346bba500c357c0276ad15762e985fb143eea) chore: upgrade webpack for testing

### Dependency updates

* [50d2c33a](https://github.com/pouchdb/pouchdb/commit/50d2c33a9c262b0d44c39abb5c40c6685e3fcd8e) Remove inherits package dependency
* [4974b64a](https://github.com/pouchdb/pouchdb/commit/4974b64a67723fc8ec2d471c0590502dfe104760) refactor: remove argsarray dependency

### Refactor

* [7350a701](https://github.com/pouchdb/pouchdb/commit/7350a701458bf77fca989ad9103cea1ed787544a) refactor: use es6 classes
* [08e46002](https://github.com/pouchdb/pouchdb/commit/08e4600203b8938bdc40180d9fbec28ff724373c) refactor: deprecate inherits in pouchdb-core
* [99ebea32](https://github.com/pouchdb/pouchdb/commit/99ebea32f39adc3f5feb47d1b3c57414c8ad0872) refactor: use class in sublevel-pouchdb
* [d4ff99b4](https://github.com/pouchdb/pouchdb/commit/d4ff99b4282c60f8ebdc48f245ef510a7287c807) refactor: use classes instead of prototypes
* [21d7975c](https://github.com/pouchdb/pouchdb/commit/21d7975c57b8dbaa3598ff7a0fc36f3a76c1fd37) feat(core): refactor ActiveTasks with ES6 classes
* [07d055ae](https://github.com/pouchdb/pouchdb/commit/07d055ae8a375366281ff12cec5519d3a42d120f) refactor: use rest parameters in find utils
* [d02eaaf0](https://github.com/pouchdb/pouchdb/commit/d02eaaf0a445a388d522052f3e2147c55881ebcd) refactor: remove argsarray usage
* [701f96dc](https://github.com/pouchdb/pouchdb/commit/701f96dc7c4ba2a598f46381b645a5c4c399b154) refactor: use await in abstract-mapreduce
* [74a6d6fd](https://github.com/pouchdb/pouchdb/commit/74a6d6fdbff0b0b0ade148562794107f25581091) refactor: remove unnecessary async
* [73e0199c](https://github.com/pouchdb/pouchdb/commit/73e0199cd1116352cc714266a4490d1f121f268a) refactor: use ES6 syntax in http adapter
* [133978fe](https://github.com/pouchdb/pouchdb/commit/133978fe771ff669a1855bf51910bce86f8777d6) refactor: use ES6 syntax in abstract-mapreduce
* [27128d6d](https://github.com/pouchdb/pouchdb/commit/27128d6df5059db263dcab8f7d4292321e2f975b) chore: remove obsolete replication revision-one optimization ([#8499](https://github.com/pouchdb/pouchdb/pull/8499))

### Other changes

* [8e08a14c](https://github.com/pouchdb/pouchdb/commit/8e08a14cb2706ca8ebbd587aa43b055d670b9383) chore: delete stale bot
* [55c2743e](https://github.com/pouchdb/pouchdb/commit/55c2743e4b17a85b21f4f888ff8f02a2b31beaaa) ([#8571](https://github.com/pouchdb/pouchdb/pull/8571)) - set executable mode on scripts
* [fec3c163](https://github.com/pouchdb/pouchdb/commit/fec3c1639e2ed83a31ed530e832a1f4c171b378e) Make bin/publish-packages.sh exit with non-zero status on failure
* [5b07d18d](https://github.com/pouchdb/pouchdb/commit/5b07d18d28fb8472fc35d914b911786e671cc08f) Recover if publishing packages fails part-way through


## Get in touch

As always, we welcome feedback from the community and would love to hear what you think of this release as well as PouchDB's future direction. Please don't hesitate to [file issues](https://github.com/pouchdb/pouchdb/issues), [open discussions](https://github.com/pouchdb/pouchdb/discussions) or [get in touch](https://github.com/pouchdb/pouchdb/blob/master/CONTRIBUTING.md#get-in-touch). And of course, a big thanks to all of our [new and existing contributors](https://github.com/pouchdb/pouchdb/graphs/contributors)!
