---
layout: post

title: PouchDB 7.3.1
author: Alba Herrerías

---

We're happy to announce the release of PouchDB 7.3.1, bringing in some fixes and dependency updates. For a full changelog from 7.3.0 to 7.3.1, please see [the releases page](https://github.com/pouchdb/pouchdb/releases) or view the [latest commits](https://github.com/pouchdb/pouchdb/compare/7.3.0...7.3.1). Some of the highlights:

## Changelog

### Bugfixes

* [7db104c5](https://github.com/pouchdb/pouchdb/commit/7db104c56248738598feb7ca1f22bc3b7bbd69be) ([#8463](https://github.com/pouchdb/pouchdb/issues/8463)) - check if docFieldValue is also null value. typeof null returns object in javascript. Fixes a bug when querying against and array with a null value, $elemMatch and $allMatch.
* [719502dc](https://github.com/pouchdb/pouchdb/commit/719502dc6a75851dce9d0a35e44929b25943588c) ([#8225](https://github.com/pouchdb/pouchdb/issues/8225)) - Added check for blob.type setter
* [d5bb7bd6](https://github.com/pouchdb/pouchdb/commit/d5bb7bd6330339448f5918592bd69df78166bad2) ([#8389](https://github.com/pouchdb/pouchdb/pull/8389)) - `_id` was mapped to `data._id` instead of id
* [bbeb7e55](https://github.com/pouchdb/pouchdb/commit/bbeb7e557658fb405b5cf91dec50a79faf5278a3) ([#8531](https://github.com/pouchdb/pouchdb/pull/8531)) - fix sorted find including deleted docs 

### Testing

* [87f27101](https://github.com/pouchdb/pouchdb/commit/87f27101d519fdfb47506546ef5c46c85d2c030a) Failing test for PR [#8389](https://github.com/pouchdb/pouchdb/pull/8389)
* [45522f78](https://github.com/pouchdb/pouchdb/commit/45522f7853831d0c4b514c49c72e672c73a18e7e)  test([#8438](https://github.com/pouchdb/pouchdb/issues/8438)): add test for sort deleted docs

### Dependency updates

* [922f7b54](https://github.com/pouchdb/pouchdb/commit/922f7b54c9300f2597e5f796248e5f5edfbb8eab) ([#8470](https://github.com/pouchdb/pouchdb/pull/8470)) - fix: upgrade promise-polyfill from 8.2.0 to 8.2.3 

### Other changes

* [fa57c294](https://github.com/pouchdb/pouchdb/commit/fa57c2942103b60f2345fc89d5291eee75ee8a89) ([#8468](https://github.com/pouchdb/pouchdb/pull/8468)) Replace deprecated String.prototype.substr()
* [5a52f2ce](https://github.com/pouchdb/pouchdb/commit/5a52f2cef7ef2276bf9435d3aec1fc7fccc90a78) ([#8343](https://github.com/pouchdb/pouchdb/pull/8343)) - Add contextual data to the error message of failing tryMap and tryReduce

## Get in touch

As always, we welcome feedback from the community and would love to hear what you think of this release as well as PouchDB's future direction. Please don't hesitate to [file issues](https://github.com/pouchdb/pouchdb/issues), [open discussions](https://github.com/pouchdb/pouchdb/discussions) or [get in touch](https://github.com/pouchdb/pouchdb/blob/master/CONTRIBUTING.md#get-in-touch). And of course, a big thanks to all of our [new and existing contributors](https://github.com/pouchdb/pouchdb/graphs/contributors)!
