---
layout: post

title: PouchDB 7.3.0
author: Alba Herrerías

---

We're happy to announce the release of PouchDB 7.3.0, bringing in features, fixes and dependency updates. For a full changelog from 7.2.2 to 7.3.0, please see [the releases page](https://github.com/pouchdb/pouchdb/releases) or view the [latest commits](https://github.com/pouchdb/pouchdb/compare/7.2.2...7.3.0). Some of the highlights:

## Improving testing

We have been investing _lots_ of time into our test suites, with around 36 commits, 112 files changed, 3314 insertions and 2064 deletions made about this topic. We have:

* Migrated from Travis CI to [Github Actions](https://github.com/pouchdb/pouchdb/actions/workflows/ci.yml), which has improved the speed, throughput and reliability of our CI.
* Rewrote [TESTING.md](https://github.com/pouchdb/pouchdb/blob/master/TESTING.md) documentation.
* Upgraded eslint configuration in order to use ES6 syntax within our tests. Feel free to incorporate newer syntax (such as `async/await`) into your new tests contributions.
* Fixed bugs in CI configuration: ADAPTERS and GREP variables weren't working correctly, background servers being started incorrectly, build failure caused by an older version of pouchdb-express-router.
* Unified the configuration variables used in the build.
* Fix the majority of non-deterministic tests to substantially reduce random failure during CI runs, and put in tooling for retrying failed tasks. This includes improving tests that check behaviour for unreachable servers, which previously relied on a third party service being available.
* Restructured the CI tasks so that each task exercises a single backend (i.e. CouchDB server version or client-side PouchDB adapter), rather than some combination of local and remote adapters. This reduces the impact of flaky tests, reduces the duration of each task, reduces redundant tasks repeating the same work, and allows more parallelisation of tests.
* Improved the test coverage across target platforms, including cross-browser tests, different Node.js versions, and different CouchDB versions. We have fixed tests that assume CouchDB v1.x behaviour so that they now work on v2.x and v3.x.
* Allowed the indexeddb adapter to be loaded and used during tests

## Add `indexeddb` adapter in the default distribution

The indexeddb adapter is now available in the default distribution. You can use it specifying the adapter:

```js
PouchDB.plugin(require('pouchdb-adapter-indexeddb'));
const db = new PouchDB('mydb', {adapter: 'indexeddb'});
```

Please note that it is considered BETA quality, use it carefully and please [report](https://github.com/pouchdb/pouchdb/issues/new) any issues you find. Thank you.

## Add `view_update_changes_batch_size`

[#8320](https://github.com/pouchdb/pouchdb/pull/8320) With `view_update_changes_batch_size`, we can now specify how many change records will be consumed at a time when rebuilding view indexes when the `query()` method is used.

## Support `partial_filter_selector`

[#8276](https://github.com/pouchdb/pouchdb/pull/8276) [#8277](https://github.com/pouchdb/pouchdb/pull/8277) Now PouchDB-find supports [`partial_filter_selector`](https://docs.couchdb.org/en/3.2.0/api/database/find.html#partial-indexes).

## Indexing event to show the progress of view updates

[#8321](https://github.com/pouchdb/pouchdb/pull/8321) We can now subscribe to an `indexing` event, which will emit a `progress` object containing the properties `view`, `last_seq`, `results_count` and `indexed_docs`.

## Checkpoint events during replication

[#8324](https://github.com/pouchdb/pouchdb/pull/8324) During replication, we can subscribe to `checkpoint` events, which will emit the following properties: `checkpoint`, `revs_diff`, `start_next_batch` and `pending_batch`.

## Add `style` to replication options

[#8380](https://github.com/pouchdb/pouchdb/issues/8380) [#8379](https://github.com/pouchdb/pouchdb/issues/8379) We expose changes feed `style` to replication options.

## Add `view_adapter` option

[#8335](https://github.com/pouchdb/pouchdb/pull/8335) `view_adapter` provides an option for the user to specify a separate adapter to store their view index in addition to the main adapter for their core data:

```js
const db = new PouchDB(DB_NAME, {adapter: 'indexeddb', view_adapter: 'memory'});
```

## Enable discussions and projects

In Github we have enabled:

* [Discussions](https://github.com/pouchdb/pouchdb/discussions): feel free to open and participate
* [Projects](https://github.com/orgs/pouchdb/projects?type=beta): we are keeping track of the issues and PRs for future releases.

## Changelog

### New features

* [7cc1c8e3](https://github.com/pouchdb/pouchdb/commit/7cc1c8e397a471ca0d107cadec486d589535dd0d) ([#8171](https://github.com/pouchdb/pouchdb/issues/8171)) - Allow `_access` field in documents
* [b359d788](https://github.com/pouchdb/pouchdb/commit/b359d78836f86a8045761361447a2aa7b162944b) Let caller set the change batch size when updating views ([#8320](https://github.com/pouchdb/pouchdb/pull/8320))
* [a9e2996b](https://github.com/pouchdb/pouchdb/commit/a9e2996b3739880bc600bb13a75aeaacb3d76878) ([#8277](https://github.com/pouchdb/pouchdb/pull/8277)) - Support `partial_filter_selector`
* [0875b19a](https://github.com/pouchdb/pouchdb/commit/0875b19acd96f066717ec41367e82838d8eb6bb3) Add an indexing event to show progress of view updates
* [fe9bd028](https://github.com/pouchdb/pouchdb/commit/fe9bd0281707fc91f598724211af4af56cc6707a) Add checkpoint events during replication
* [b523a1d2](https://github.com/pouchdb/pouchdb/commit/b523a1d2775ca06fb72e9a12c9cab757de6200de) ([#8379](https://github.com/pouchdb/pouchdb/issues/8379)) - Expose changes feed style to replication options ([#8380](https://github.com/pouchdb/pouchdb/pull/8380))
* ([#8335](https://github.com/pouchdb/pouchdb/pull/8335)) Add view adapter option

### Bugfixes

* [b8d3fc65](https://github.com/pouchdb/pouchdb/commit/b8d3fc65377b65a1945ae3c7a753d62739b3d918) ([#8229](https://github.com/pouchdb/pouchdb/issues/8229)) - indexeddb: ensure errors are propagated and handle database deletion
* [fe7ffa9c](https://github.com/pouchdb/pouchdb/commit/fe7ffa9cf7306baf74856b74cf7734ebafac25d0) ([#8237](https://github.com/pouchdb/pouchdb/pull/8237)) - Conform pouchdb find operators to couchdb's ([#8327](https://github.com/pouchdb/pouchdb/pull/8327))
* [0e27e23f](https://github.com/pouchdb/pouchdb/commit/0e27e23f4437bce134d0780a543f08a3020fa4de) ([#8222](https://github.com/pouchdb/pouchdb/issues/8222)) - fix multiple $regex conditions on same field when using $and
* [ab451d9e](https://github.com/pouchdb/pouchdb/commit/ab451d9e1d190627c6375a5babbf4f001ae448c1) ([#8165](https://github.com/pouchdb/pouchdb/pull/8165)) - Initial dollar sign escaped with unit tests.
* [f544c822](https://github.com/pouchdb/pouchdb/commit/f544c8221a82fc4b6f6714da3a59530dd0041d56) ([#8242](https://github.com/pouchdb/pouchdb/issues/8242)) - unhandled promise rejection in upsert
* [62dd11bf](https://github.com/pouchdb/pouchdb/commit/62dd11bf3ef9365d7013e8c4ac1a788d279f3f2d) ([#8185](https://github.com/pouchdb/pouchdb/issues/8185)) - Fix date checking
* [a6a34357](https://github.com/pouchdb/pouchdb/commit/a6a34357e18c8abee524e1f35c0c3d481492966e) ([#8187](https://github.com/pouchdb/pouchdb/pull/8187)) - Don't include leveldown in browsers
* [9bf13109](https://github.com/pouchdb/pouchdb/commit/9bf131092bdc3003ab1682bb17d3ed30be93b30e) ([#7331](https://github.com/pouchdb/pouchdb/issues/7331)) - Close leveldb file handlers
* [be55391b](https://github.com/pouchdb/pouchdb/commit/be55391bf9f69830d0c0d7854e17cb50087272ca) ([#8274](https://github.com/pouchdb/pouchdb/pull/8274)) - rev() should clone only when needed
* [8377ae00](https://github.com/pouchdb/pouchdb/commit/8377ae00476aca98ad607b17e32e6853a85bdb77) ([#8316](https://github.com/pouchdb/pouchdb/pull/8316)) - Properly handle transaction abort
* [c4aaf255](https://github.com/pouchdb/pouchdb/commit/c4aaf255f86938c7c3e41048cc3e8c1f45d359b6) Fix escaping of key path segments in indexeddb adapter ([#8358](https://github.com/pouchdb/pouchdb/pull/8358))
* [77d9782a](https://github.com/pouchdb/pouchdb/commit/77d9782afbc1bbf83f232d7f283677f5693d146e) Fix memory leak when replications fails
* [73a9bad4](https://github.com/pouchdb/pouchdb/commit/73a9bad44f9ee36c059b15eea8a70d25a3ddb007) fix: add `auto_compaction` to indexeddb bulkDocs
* ([#8460](https://github.com/pouchdb/pouchdb/pull/8460)) Fix writing erroneous attachment rev references in bulkDocs
* ([#8370](https://github.com/pouchdb/pouchdb/issues/8370)) Implement skip and limit for keys query [#8404](https://github.com/pouchdb/pouchdb/pull/8404)
* ([#8473](https://github.com/pouchdb/pouchdb/pull/8473)) Add stack to CustomPouchError (fix [#8372](https://github.com/pouchdb/pouchdb/issues/8372))
* ([#8473](https://github.com/pouchdb/pouchdb/pull/8473)) Add idb global database failure error as reason to transaction errors [#8414](https://github.com/pouchdb/pouchdb/pull/8414)

### Documentation 

* [d37fc6da](https://github.com/pouchdb/pouchdb/commit/d37fc6da659a9093451c9c2f4c1e134b7c305b91) ([#8212](https://github.com/pouchdb/pouchdb/pull/8212)) - Fix broken link to levelDB website
* [ab97b853](https://github.com/pouchdb/pouchdb/commit/ab97b853d8d0670b8815050f7bcf331e52fb82b3) ([#8201](https://github.com/pouchdb/pouchdb/pull/8201)) - Add indexeddb adapter option
* [b3eaf791](https://github.com/pouchdb/pouchdb/commit/b3eaf791608c9db964d2445ea51c79fbc4215001) ([#8259](https://github.com/pouchdb/pouchdb/issues/8259)) - Change link to firefox addon for deleting data
* [f703887f](https://github.com/pouchdb/pouchdb/commit/f703887fd46fcb9498ed4e5c924cab6dfbd958e7) ([#8269](https://github.com/pouchdb/pouchdb/pull/8269)) - Fix link to CouchDB docs related to views collation
* [a5a920c9](https://github.com/pouchdb/pouchdb/commit/a5a920c9d325ff2e1c65149605193b2dfe8dbb63) ([#8267](https://github.com/pouchdb/pouchdb/pull/8267)) - Add pouchdb-adapter-hyperbee
* [d6203248](https://github.com/pouchdb/pouchdb/commit/d6203248db74030cd09c11d7833aea0da42c2814) ([#8292](https://github.com/pouchdb/pouchdb/pull/8292)) - Add Newt image
* [ef0a2c6b](https://github.com/pouchdb/pouchdb/commit/ef0a2c6b25bb556ae7126e684acbdf0365225763) ([#8292](https://github.com/pouchdb/pouchdb/pull/8292)) - Add Newt to Who's Using PouchDB (https://newt.to)
* [7532eb30](https://github.com/pouchdb/pouchdb/commit/7532eb30f514d37b94f829ed22e70da7f3c1ed3a) ([#8261](https://github.com/pouchdb/pouchdb/pull/8261)) - Bump redcarpet from 3.5.0 to 3.5.1 in /docs
* [c3f06693](https://github.com/pouchdb/pouchdb/commit/c3f066930c62045783e7c0f51f9cfb690104d595) ([#8279](https://github.com/pouchdb/pouchdb/pull/8279)) - Bump kramdown from 2.3.0 to 2.3.1 in /docs
* [91b41360](https://github.com/pouchdb/pouchdb/commit/91b4136097d577400061db23e087289083ce708a) ([#8295](https://github.com/pouchdb/pouchdb/pull/8295)) - Bump rexml from 3.2.4 to 3.2.5 in /docs
* [09a26ba9](https://github.com/pouchdb/pouchdb/commit/09a26ba9d5d0132af47b6ac90afd52bfff3663c7) ([#8301](https://github.com/pouchdb/pouchdb/pull/8301)) - Update overview.html
* [8b3ed089](https://github.com/pouchdb/pouchdb/commit/8b3ed08952b314236b1c7ce0f87abeca27478d6f) ([#8328](https://github.com/pouchdb/pouchdb/pull/8328)) - Bump addressable from 2.7.0 to 2.8.0 in /docs
* [a7b9b8c3](https://github.com/pouchdb/pouchdb/commit/a7b9b8c327da1f641d6fd3269149fb2c6df4b016) update IRC links
* [40cf3dac](https://github.com/pouchdb/pouchdb/commit/40cf3dac5ce54fcf879fa6a1bfbddab496803ede) ([#8354](https://github.com/pouchdb/pouchdb/issues/8354)) - Docs: Update couchdb setup guide ([#8355](https://github.com/pouchdb/pouchdb/pull/8355))
* [a33bc407](https://github.com/pouchdb/pouchdb/commit/a33bc407407f97b9f2382db364f9e49a0fa03b62) Reorganise the testing documentation
* [349ca75e](https://github.com/pouchdb/pouchdb/commit/349ca75e75a703128a2f48a2d854a25a2c9948c3) docs: Fix a few typos
* [0ad4770](https://github.com/pouchdb/pouchdb/commit/0ad477023493284a0b0ee3c300ea5fad59ddf88b) ([#8474](https://github.com/pouchdb/pouchdb/pull/8474)) feat(docs) document the `partial_filter_selector` option to createIndex()
* [a44ae12](https://github.com/pouchdb/pouchdb/commit/a44ae12431c0c32fb74035ad0f407bd26662721d) ([#8474](https://github.com/pouchdb/pouchdb/pull/8474)) feat(docs) add documentation for the indexing event
* [1c3ac70](https://github.com/pouchdb/pouchdb/commit/1c3ac7063b8e7c2ac2d26dbff517399528ede19a) ([#8474](https://github.com/pouchdb/pouchdb/pull/8474)) feat(docs) add documentation for the checkpoint event

### Testing

* [04d2a458](https://github.com/pouchdb/pouchdb/commit/04d2a45872d11e57e25fd1bfdaa0011234ac1fb6) ([#8227](https://github.com/pouchdb/pouchdb/issues/8227)) - Remove saucelabs test runs
* [095ada4f](https://github.com/pouchdb/pouchdb/commit/095ada4f50a88ec09b417c21a57e76d3e204d6ac) ([#8319](https://github.com/pouchdb/pouchdb/pull/8319)) - Fix node build ordering
* [451e7ec4](https://github.com/pouchdb/pouchdb/commit/451e7ec426f3f90bd72d9cbf426707d7f170042f) ([#8325](https://github.com/pouchdb/pouchdb/issues/8325)) - Reduce the number of travis runs
* [1e6cfa1a](https://github.com/pouchdb/pouchdb/commit/1e6cfa1a3652e90952920670fa3a958ea099563d) Update indexing event test to use async/await instead of callbacks
* [9f5da871](https://github.com/pouchdb/pouchdb/commit/9f5da871ac5748bca187f97b3926326cdbddcce5) Update checkpoint event test to use async/await instead of callbacks
* [2218ed1c](https://github.com/pouchdb/pouchdb/commit/2218ed1ca6f47ef30a0e304a7ae39cbb64f81be8) Parse query string into an object in webrunner.js
* [b39b98f7](https://github.com/pouchdb/pouchdb/commit/b39b98f796fb84a0e32e3e61265d8cf7497b7402) Load adapters as plugins only if they are present in `packages/node_modules/pouchdb/dist`
* [731a83ba](https://github.com/pouchdb/pouchdb/commit/731a83ba39a8aac5c46f991614b922a1c74c8353) Remove the ADAPTER variable from the browser test scripts and update CI config and docs
* [7a8ff25f](https://github.com/pouchdb/pouchdb/commit/7a8ff25f4b8e8ab96f7172b87b222edba30b5668) Replace remaining uses of ADAPTER in tests with ADAPTERS
* [efa56c8c](https://github.com/pouchdb/pouchdb/commit/efa56c8ca1a0a5e78671d73405a2684ff407180c) Turn indexeddb into a plugin and make it loadable via the ADAPTERS option
* [6c5d601a](https://github.com/pouchdb/pouchdb/commit/6c5d601a07c29afcf824af0fca0c6c5ca0fdf911) Run "find" tests against a single implementation at a time ([#8359](https://github.com/pouchdb/pouchdb/pull/8359))
* [4a9562d2](https://github.com/pouchdb/pouchdb/commit/4a9562d2897d7639fe11828a6d4ba28a85985a43) Quote arguments to mocha(1) to make GREP work correctly ([#8363](https://github.com/pouchdb/pouchdb/pull/8363))
* [d9edb532](https://github.com/pouchdb/pouchdb/commit/d9edb532332afbcbcbc5b1de6ff39934ae3f6927) Fix mapreduce tests ([#8365](https://github.com/pouchdb/pouchdb/pull/8365))
* [453dd3e6](https://github.com/pouchdb/pouchdb/commit/453dd3e6e5265d810cdc7b7d3212fa58bf2f503b) Consistent loading of PouchDB in tests ([#8366](https://github.com/pouchdb/pouchdb/pull/8366))
* [18c74c3e](https://github.com/pouchdb/pouchdb/commit/18c74c3ed066e0bacc42ed12f7fa6e37d3c42ba1) Migrate CI to GitHub Actions ([#8368](https://github.com/pouchdb/pouchdb/pull/8368))
* [55b5ee5b](https://github.com/pouchdb/pouchdb/commit/55b5ee5b8d7f9c55112a490410d7acda810c1612) Add test for broken skip in pouch-find ([#8371](https://github.com/pouchdb/pouchdb/pull/8371))
* [566502c7](https://github.com/pouchdb/pouchdb/commit/566502c7ab20acd981bb87037a11f57a2853f3e1) fix(test): skip test setup and assertions were wrong
* [07376ded](https://github.com/pouchdb/pouchdb/commit/07376dedf574008ad7a07fc94650a8aebc1cc38a) chore(test): uncomment test for future fix
* [45413a6e](https://github.com/pouchdb/pouchdb/commit/45413a6e5b9c6d549a24e1b939be74fb39e67c62) chore: rename build node variable
* [c0771a7d](https://github.com/pouchdb/pouchdb/commit/c0771a7d7ad1e4bc0af63e4f3a2c099fb323a1c4) fix: skip building node on webpack tests
* [1fc976f7](https://github.com/pouchdb/pouchdb/commit/1fc976f718883ee5f195f058261f3b6862b7db0e) Add webpack test to github actions
* [469a4938](https://github.com/pouchdb/pouchdb/commit/469a49380f6d331d67af18c61df642505dbd6eab) Fix mapreduce tests that assume bulkDocs() response order, which pouchdb-server does not guarantee
* [fc7f6855](https://github.com/pouchdb/pouchdb/commit/fc7f685509839152a5509efb45b904c7ad2e4656) Test for non-string values for `views.*.map` should pass on more recent CouchDB versions which do not reject the design doc on write, but fail on queries instead
* [5b0903cb](https://github.com/pouchdb/pouchdb/commit/5b0903cbaa08c2be0fcb9dd26376e94a9a902b52) Add missing "npm test" command in mapreduce CI tasks
* [ea46e5a8](https://github.com/pouchdb/pouchdb/commit/ea46e5a84029a7e8788926626432e624913f5a57) Run integration tests on Node.js, and with the memory adapter, and use ADAPTERS (plural) to set the adapter
* [423124c0](https://github.com/pouchdb/pouchdb/commit/423124c07fd989af1890123722d509ff869894e8) Run integration tests against CouchDB and pouchdb-server
* [4040b214](https://github.com/pouchdb/pouchdb/commit/4040b214e6853c0ca8458b51b1a25d1a9d9544dc) Add all the combinations for testing the pouchdb-find plugin to the CI matrix
* [6893afd5](https://github.com/pouchdb/pouchdb/commit/6893afd5089fcc99c720d483cc3b1e806f890a44) Build pouchdb-server correctly during tests on GitHub Actions
* [d3912687](https://github.com/pouchdb/pouchdb/commit/d39126875c237c21e7001cb072ac4b14409b9842) Refactor the GitHub actions workflows
* [ac7bcc65](https://github.com/pouchdb/pouchdb/commit/ac7bcc6532700071178fed3d0416c38058133477) Do not run eslint after all tests, but make it a distinct task that other CI jobs depend on
* [6786456d](https://github.com/pouchdb/pouchdb/commit/6786456db080776b31e51a3d275fa6ce5ca3cc3c) test: add couchdb 2.3 browser matrix
* [1ba99d64](https://github.com/pouchdb/pouchdb/commit/1ba99d64b8c05f8c7e29394091ae90c4caeb8a03) test: remove debugging logs
* [ad520298](https://github.com/pouchdb/pouchdb/commit/ad5202985701e5efbf65c3a3b7d615ef12d571b7) feat: add down server, use it in tests
* [fc690dd4](https://github.com/pouchdb/pouchdb/commit/fc690dd42395fa0a8a8940b6a417acd6f096e22e) test: refactor in replication test replicate from down server test
* [e7e3eff7](https://github.com/pouchdb/pouchdb/commit/e7e3eff7436c8ca0514be5fba823fddcec58e9b2) feat: add retries to failed jobs in gha ci
* [31bc31f8](https://github.com/pouchdb/pouchdb/commit/31bc31f89f3dc2616142d8dcfa85fe5d1c56b1f3) fix: node build on tests

### Dependency updates

* [7b9ae245](https://github.com/pouchdb/pouchdb/commit/7b9ae245f10c5e17af8f205c91a7161e2512842c) ([#8160](https://github.com/pouchdb/pouchdb/issues/8160)) - fix: upgrade uuid from 8.1.0 to 8.3.0
* [dca61ca1](https://github.com/pouchdb/pouchdb/commit/dca61ca149fd5438c156fb917efc6cf0f34a3f63) ([#8232](https://github.com/pouchdb/pouchdb/issues/8232)) - Update node-fetch
* [3531d136](https://github.com/pouchdb/pouchdb/commit/3531d136e67ce52d75a8c73c1b314145a8b0a53b) ([#8235](https://github.com/pouchdb/pouchdb/pull/8235)) - fix: upgrade fetch-cookie from 0.10.1 to 0.11.0
* [356d696c](https://github.com/pouchdb/pouchdb/commit/356d696c31e2d6527cfbd73bd92d852778f24c6a) ([#8254](https://github.com/pouchdb/pouchdb/pull/8254)) - fix: upgrade uuid from 8.3.0 to 8.3.2
* [e76f02f9](https://github.com/pouchdb/pouchdb/commit/e76f02f96148d69855c592764cde274c3a43f4f0) Upgrade pouchdb-express-router to 0.0.11 to fix sync tests
* [2c93c04f](https://github.com/pouchdb/pouchdb/commit/2c93c04faca48958ffadad7ecca43b371a8980f1) chore: remove unused dependency
* [e4bda69f](https://github.com/pouchdb/pouchdb/commit/e4bda69ff6b5e6871a11909a5a51afb567dae25e) Revert "chore: remove unused dependency"
* [f42cc235](https://github.com/pouchdb/pouchdb/commit/f42cc235c34f6d40480c36a728f6da7db380b10f) fix: upgrade node-fetch from 2.6.1 to 2.6.2 ([#8369](https://github.com/pouchdb/pouchdb/pull/8369))
* [cd77102e](https://github.com/pouchdb/pouchdb/commit/cd77102ec4c3cd86b88f1af7e4c81493ff7866ff) fix: upgrade node-fetch from 2.6.2 to 2.6.4 ([#8377](https://github.com/pouchdb/pouchdb/pull/8377))
* [da0aac83](https://github.com/pouchdb/pouchdb/commit/da0aac831429a826e8ed4180406a93a073e7c3cc) chore: upgrade ua-parser-js version ([#8424](https://github.com/pouchdb/pouchdb/pull/8424))
* [b810edd7](https://github.com/pouchdb/pouchdb/commit/b810edd7255c2d42ad03784d86df8d5fbab12b59) chore: remove unused dependency js-extend ([#8425](https://github.com/pouchdb/pouchdb/pull/8425))
* [c3333db0](https://github.com/pouchdb/pouchdb/commit/c3333db0c636eb575604b65a1e4d918df192f9ae) chore: update eslint to the latest version (8.7.0)
* [abf87a84](https://github.com/pouchdb/pouchdb/commit/abf87a848811ae791c82caa37d017081bdedc855) ([#8440](https://github.com/pouchdb/pouchdb/issues/8440)) - bump node-fetch to 2.6.7 ([#8448](https://github.com/pouchdb/pouchdb/pull/8448))
* [3b980f21](https://github.com/pouchdb/pouchdb/commit/3b980f215e4a50ea827e6433f3c38d701e9f6c6a) Upgrade dependencies, remove request

### Other changes

* [1ba87970](https://github.com/pouchdb/pouchdb/commit/1ba879709fdf6306dc3f8e9d2d67f4060ade6e50) ([#8167](https://github.com/pouchdb/pouchdb/issues/8167)) - Revert Jekyll to 3.9.0 to be able to build documentation (+ doc updates)
* [dfdb55e6](https://github.com/pouchdb/pouchdb/commit/dfdb55e604c9fc87c835d1b7a7f698cca5204fe2) ([#8219](https://github.com/pouchdb/pouchdb/issues/8219)) - Update stale bot configuration
* [1a48c541](https://github.com/pouchdb/pouchdb/commit/1a48c5413c14db65f4e485bee60170bd943ad6b3) Upgrade eslint ecmaVersion to 8
* [1d8d7500](https://github.com/pouchdb/pouchdb/commit/1d8d750059d63ba7dc7171bd256098a3f3c18492) Update issue template's adapters
* [d5f47348](https://github.com/pouchdb/pouchdb/commit/d5f47348a09adb8fb0ece9d6ef01e384a5deca44) chore: fix eslint running at `packages/node_modules`
* [d143e02e](https://github.com/pouchdb/pouchdb/commit/d143e02eb96ff78e4599df31a3f7f101830b1db3) chore: remove local, unneeded eslint config
* [b1742b1d](https://github.com/pouchdb/pouchdb/commit/b1742b1d9373f19d0ad070779839a9d033f2b39d) chore: fix eslint no-prototype-builtins errors
* [41d70ea8](https://github.com/pouchdb/pouchdb/commit/41d70ea8cac50c0214aee72cfd5dd731db2e3b05) Update README's build status badge
* [dae3e384](https://github.com/pouchdb/pouchdb/commit/dae3e3846b76bbd5c658e84506c40b73cc8a3dee) Add or update repository field in package.jsons


## Get in touch

As always, we welcome feedback from the community and would love to hear what you think of this release as well as PouchDB's future direction. Please don't hesitate to [file issues](https://github.com/pouchdb/pouchdb/issues), [open discussions](https://github.com/pouchdb/pouchdb/discussions) or [get in touch](https://github.com/pouchdb/pouchdb/blob/master/CONTRIBUTING.md#get-in-touch). And of course, a big thanks to all of our [new and existing contributors](https://github.com/pouchdb/pouchdb/graphs/contributors)!
