---
layout: post

title: PouchDB 7.0 - 17.5% less PouchDB
author: Dale Harvey

---

As promised back in January it is time to drop WebSQL from our default builds. This not only lets us focus our development efforts on a single engine but along with the other changes explained below reduces the default PouchDB package size from 148KB to 122KB, thats 17.5% smaller!

## Removed WebSQL

[#6943](https://github.com/pouchdb/pouchdb/issues/6943) - The WebSQL adapter is still available to [download and use](https://github.com/pouchdb/pouchdb/releases/tag/7.0.0), it will no longer be available as part of a default PouchDB build and will eventually be moved to the [pouchdb-community repo](https://github.com/pouchdb-community). If you need to migrate your users from WebSQL to IndexedDB then there is some advice available in our [previous release post]({{ site.baseurl }}/2018/01/23/pouchdb-6.4.2.html).

## Removed Promise Polyfill

[#6945](https://github.com/pouchdb/pouchdb/issues/6945) - Including our own Promise polyfill means larger bundles when most apps already include their own polyfill if they need it. So if you support [browsers which do not support Promises natively](https://caniuse.com/#feat=promises) you will need to include a polyfill yourself. We use [promise-polyfill](https://www.npmjs.com/package/promise-polyfill) and have found it to work great.

## Switch to fetch

[#6944](https://github.com/pouchdb/pouchdb/issues/6944) - This is another API that may need polyfilled if you use PouchDB and support IE, we use [whatwg-fetch](https://www.npmjs.com/package/whatwg-fetch). Switching to fetch has allowed us to expose the ability to intercept the requests PouchDB makes for more flexibility, such as:

```js
var db = new PouchDB('http://example.com/dbname', {
  fetch: function (url, opts) {
    opts.headers.set('X-Some-Special-Header', 'foo');
    return PouchDB.fetch(url, opts);
  }
});
```

That will add a `X-Some-Special-Header` to every HTTP request PouchDB makes.

## Deterministic Revisions

[#4642](https://github.com/pouchdb/pouchdb/issues/4642) - We now match CouchDB default behaviour and use the documents contents to determine its revision, this means automated conflict resolution handlers are less likely to generate extra conflicts.

## More Deprecations

- [#6946](https://github.com/pouchdb/pouchdb/issues/6946) - Remove debug dep
- [#7134](https://github.com/pouchdb/pouchdb/issues/7134) - Remove IndexedDB storage option
- [#6944](https://github.com/pouchdb/pouchdb/issues/6944) - Remove deprecated skipSetup

## Fixes

- [#7040](https://github.com/pouchdb/pouchdb/issues/7040) - Use fixed-length array in idb/indexeddb allDocs
- [#6655](https://github.com/pouchdb/pouchdb/issues/6655) - Use consistent types for replication progress values
- [#7085](https://github.com/pouchdb/pouchdb/issues/7085) - Accept old Safari version as valid
- [#7095](https://github.com/pouchdb/pouchdb/issues/7095) - Reduce replication to server requests
- [#7115](https://github.com/pouchdb/pouchdb/issues/7115) - Remove catastrophic backtracking vulnerability
- [#7127](https://github.com/pouchdb/pouchdb/issues/7127) - Fix docs for db.query()'s options.reduce default
- [#7141](https://github.com/pouchdb/pouchdb/issues/7141) - Fix ios idb blobSupport silent fail
- [#6502](https://github.com/pouchdb/pouchdb/issues/6502) - Set return_docs default false when opts.live = true
- [#7126](https://github.com/pouchdb/pouchdb/issues/7126) - Check level.destroy exists before calling
- [#5814](https://github.com/pouchdb/pouchdb/issues/5814) - Ensure prefix has trailing slash

## Get in touch

As always, we welcome feedback from the community and would love to hear what you think of this release as well as PouchDB's future direction. Please don't hesitate to [file issues](https://github.com/pouchdb/pouchdb/issues) or [get in touch](https://github.com/pouchdb/pouchdb/blob/master/CONTRIBUTING.md#get-in-touch). And of course, a big thanks to all of our [new and existing contributors](https://github.com/pouchdb/pouchdb/graphs/contributors)!
