---
layout: post

title: PouchDB 6.4.2 - Long live WebSQL
author: Dale Harvey

---

In this release PouchDB now supports IndexedDB by default in Safari and will drop support for WebSQL in future versions.

## A brief history of WebSQL

Just over 5 years ago PouchDB got its [first support for WebSQL](https://github.com/pouchdb/pouchdb/commit/bb488ccd453435862b36b57c628d3fdc9ebee687), originally to support Opera WebSQL, as it was able to pick up for the lack of support for IndexedDB in Safari and gave PouchDB the ability to support a wide variety of browsers. Opera gained IndexedDB support from its switch to Blink / Chromium and with WebSQL failing to become a web standard Safari started supporting IndexedDB from its 7.1 release. Initially there were too many bugs in Safari's implementation for PouchDB to use it however after a lot of work from the WebKit devs and a few releases IndexedDB support became stable in Safari and as of this release is now the default storage engine for PouchDB in Safari.

Switching to IndexedDB vastly reduces the amount of work we need to do to keep PouchDB stable, as any new features and improvements relating to storage up until now has meant duplicating the entire code and effort for WebSQL. We will also see a nice reduction in the bundle size.

## Migrating current users

If you are using PouchDB and expect to want to use new releases then you will need to
migrate your current users, this release of PouchDB supports both WebSQL and IndexedDB
in Safari so one solution that may work depending on your circumstances is to
replicate between them like so:

```javascript
function openDB(name, opts) {
  return new Promise(function(resolve, reject) {
    var localdb = new PouchDB(name, opts);
    localdb.info().then(function(info) {

      if (info.adapter !== 'websql') {
        return resolve(localdb);
      }

      var newopts = opts || {};
      newopts.adapter = 'idb';

      var newdb = new PouchDB(name, newopts);
      var replicate = localdb.replicate.to(newdb);
      replicate.then(function() {
        resolve(newdb);
      }).catch(reject);
    }).catch(reject);
  });
}
```

## More Deprecations

With PouchDB we aim to keep breaking changes to a minimum which means when we do have a
breaking change release like the upcoming 7.0 there will usually be a few other changes.
Currently it looks likely that we will remove our [Promise Polyfill](https://github.com/pouchdb/pouchdb/issues/6945) and switch to the [fetch API for HTTP requests](https://github.com/pouchdb/pouchdb/issues/6944). These aren't all certain and you can follow along or join in with the [7.0 release discussion here](https://github.com/pouchdb/pouchdb/issues/6946).

## Other Changes

- [#7019](https://github.com/pouchdb/pouchdb/issues/7019) - Don't crash on empty HTTP requests
- [#7008](https://github.com/pouchdb/pouchdb/issues/7008) - Add Glitch bug helper
- [#6954](https://github.com/pouchdb/pouchdb/issues/6954) - Fix hang when storage quota is exceeded
- [#6958](https://github.com/pouchdb/pouchdb/issues/6958) - Fix PouchDB find with zero values
- [#6971](https://github.com/pouchdb/pouchdb/issues/6971) - Fix allDocs keys and limit < keys.length

## Get in touch

As always, we welcome feedback from the community and would love to hear what you think of this release as well as PouchDB's future direction. Please don't hesitate to [file issues](https://github.com/pouchdb/pouchdb/issues) or [get in touch](https://github.com/pouchdb/pouchdb/blob/master/CONTRIBUTING.md#get-in-touch). And of course, a big thanks to all of our [new and existing contributors](https://github.com/pouchdb/pouchdb/graphs/contributors)!
