---
layout: post

title: PouchDB 6.4.0
author: Dale Harvey

---

I'm happy to announce the release of PouchDB 6.4.0, bringing in a number of important features and fixes. For a full changelog from 6.3.0 to 6.4.0 please see [the releases page](https://github.com/pouchdb/pouchdb/releases). Some of the highlights:

## Add update_seq option to `allDocs()` and `query()`

[#6230](https://github.com/pouchdb/pouchdb/issues/6230) - [Dale Harders](https://github.com/dharders) added support for passing `update_seq: true` to either `allDocs()` or `query()` or will return the current databases `update_seq`.

## Add pending property

[#5710](https://github.com/pouchdb/pouchdb/issues/5710) - Dale also added support for passing through the `pending` property newly implemented in CouchDB that reports the number of pending documents to replicate.

## Use a single transaction for allDocs with keys requests

[#6854](https://github.com/pouchdb/pouchdb/issues/6854) - [@nename0](https://github.com/nename0) implemented an optimisation to use a single transaction in indexedDB and WebSQL for allDocs requests with keys. This seen a huge 8X speedup in Chrome and 2X in Firefox.

## Add support to store cookies on Node.js

[#6814](https://github.com/pouchdb/pouchdb/issues/6814) - [@ptitjes](https://github.com/ptitjes) fixed HTTP requests in Node.JS to ensure they use a cookie jar.

## Full changelog

### Bug fixes and performance improvements

- [#6443](https://github.com/pouchdb/pouchdb/issues/6443) - Support seq_interval for changes and use during replication
- [#6890](https://github.com/pouchdb/pouchdb/issues/6890) - Preventing SecurityError on Firefox
- [#6855](https://github.com/pouchdb/pouchdb/issues/6855) - Cache bust GET requests on IE11
- [#6736](https://github.com/pouchdb/pouchdb/issues/6736) - Fix {binary: true} in db.get() with open_revs and HTTP adapter
- [#6730](https://github.com/pouchdb/pouchdb/issues/6730) - Fix single-sided checkpointing
- [#6766](https://github.com/pouchdb/pouchdb/issues/6766) - Prevent field lookup on undefined value
- [#6793](https://github.com/pouchdb/pouchdb/issues/6793) - Fix incompatibility with pouchdb-wrappers


## Get in touch

As always, we welcome feedback from the community and would love to hear what you think of this release as well as PouchDB's future direction. Please don't hesitate to [file issues](https://github.com/pouchdb/pouchdb/issues) or [get in touch](https://github.com/pouchdb/pouchdb/blob/master/CONTRIBUTING.md#get-in-touch). And of course, a big thanks to all of our [new and existing contributors](https://github.com/pouchdb/pouchdb/graphs/contributors)!
