---
layout: post

title: PouchDB 6.3.0
author: Will Holley

---

I'm happy to announce the release of PouchDB 6.3.0, bringing in a number of important features and fixes. For a full changelog from 6.2.0 to 6.3.0 please see [the releases page](https://github.com/pouchdb/pouchdb/releases). Some of the highlights:

## Option to disable checkpoints

This adds a new `checkpoint` option to replication which allows you to disable checkpoints on the source, target, or both. Disabling remote checkpoints is a potential performance optimisation, at the risk of a local checkpoint becoming invalid if the remote database is moved or recreated. You may also want to disable remote checkpoint if the source database is read-only.

## Force update

This allows you to pass an option `force: true` when updating a single document to allow the update to be applied to a non-leaf revision.

## Replacing uuid function with node-uuid

The existing UUID generation was not as random as it should be, leading to UUID conflicts when large numbers of documents are generated by PouchDB clients. This change replaces the custom UUID generation with node-uuid, improving the entropy.

## pouchdb-find behaviour compatibility with CouchDB

The pouchdb-find plugin now supports `_explain`, `use_index` and the `$allMatch` operator (already available in CouchDB).

## Validate _changes timing parameters

We now validate the timeout and heartbeat parameters when calling remote `_changes` to ensure that clients don't timeout prematurely. This also prevents expected timeouts (i.e. the server closing the connection after the timeout parameter) from manifesting as an error and triggering the PouchDB backoff/retry logic, which should improve continuous replication responsiveness when there have been long periods (minutes) without any changes.

## Full changelog

### New features

- [#6565](https://github.com/pouchdb/pouchdb/issues/6565) - Replacing uuid function with node-uuid
- [#5490](https://github.com/pouchdb/pouchdb/issues/5490) - Include doc ID in conflict errors
- [#6308](https://github.com/pouchdb/pouchdb/issues/6308) - Add option to disable checkpoints
- [#6529](https://github.com/pouchdb/pouchdb/issues/6529) - Include doc ID in 404 (not_found) errors for IDB adapter
- [#5832](https://github.com/pouchdb/pouchdb/issues/5832) - Force update
- [#6452](https://github.com/pouchdb/pouchdb/issues/6452) - Add support for use_index in pouchdb-find
- [#6495](https://github.com/pouchdb/pouchdb/issues/6495) - Add explain endpoint for pouchdb-find
- [#6443](https://github.com/pouchdb/pouchdb/issues/6443) - Add $allMatch support for pouchdb-find

### Bug fixes and performance improvements

- [#6510](https://github.com/pouchdb/pouchdb/issues/6510) - validate _changes timing parameters
- [#6545](https://github.com/pouchdb/pouchdb/issues/6545) - throw Errors, not Strings
- [#6504](https://github.com/pouchdb/pouchdb/issues/6504) - fix possible "EventEmitter memory leak detected"
- [#5981](https://github.com/pouchdb/pouchdb/issues/5981) - ensure `close()` doesn't block `destroyed` events
- [#6472](https://github.com/pouchdb/pouchdb/issues/6472) - pouchdb-find: don't return design docs with `all_docs` index
- [#6458](https://github.com/pouchdb/pouchdb/issues/6458) - consistent error handling for mapreduce


## Get in touch

As always, we welcome feedback from the community and would love to hear what you think of this release as well as PouchDB's future direction. Please don't hesitate to [file issues](https://github.com/pouchdb/pouchdb/issues) or [get in touch](https://github.com/pouchdb/pouchdb/blob/master/CONTRIBUTING.md#get-in-touch). And of course, a big thanks to all of our [new and existing contributors](https://github.com/pouchdb/pouchdb/graphs/contributors)!
