---
layout: post

title: PouchDB 6.1.1
author: Dale Harvey

---

Happy New Year to all! With a new year comes a new PouchDB release. For a full changelog since 6.1.0, please see [the releases page](https://github.com/pouchdb/pouchdb/releases) but for a look at our new years resolutions then here goes:

## Include id's in bulkDocs response

Ben Nadel [pointed out](https://www.bennadel.com/blog/3200-retrying-bulk-updates-in-pouchdb-using-a-recursive-promise-chain.htm) that it was a lot of work for users to figure out the result of their individual documents writes in a bulkDocs request, so thanks to [Will Holley](https://twitter.com/willholley) we now [keep track of them](https://github.com/pouchdb/pouchdb/commit/2553fd77bf341976f205a5e7ae8352775dee7409).

## Play nicer with proxy servers

A lot people use PouchDB with a CouchDB server that is behind a proxy, sometimes these proxies do not behave exactly as CouchDB does so we have new fixes to improve that:

 1. [(#6089)](https://github.com/pouchdb/pouchdb/commit/5b692a11b3391a6fdd7f3d5b4e534262f29e3f7a) - Don't add a default heartbeat parameter to non live changes() requests. Thanks to [Artur Nowak](https://github.com/anowak).
 2. [(#5501)](https://github.com/pouchdb/pouchdb/commit/cb020e33384227c8272f8f579e58470849107683) - Fall back from bulkGet on any error (not just 4XX). Thanks to [Will Holley](https://github.com/willholley).

## Be faster and use less memory

[Nolan Lawson](https://twitter.com/nolanlawson) has spent a lot of time profiling PouchDB (keep on the look out for an upcoming blog post) but in the meantime these changes include: [Use native Map/Set where possible](https://github.com/pouchdb/pouchdb/commit/4e35f43c1b0b0338ef2e6bcdc9c9e20068b2fc21), [Use Object.assign instead of js-extend](https://github.com/pouchdb/pouchdb/commit/b325846d23d264121b80ead3f5e7b7567b56b538) and [use batched cursors (getAll / GetAllKeys) when fetching multiple documents from IndexedDB](https://github.com/pouchdb/pouchdb/commit/620d987a875542f9b0eec58573f9ed85c30bc00f).

## Be consistent in Worker threads

Last years PouchDB had a [bug in an optimisation](https://github.com/pouchdb/pouchdb/issues/6055) that could produce different results across worker threads or the same database in different tabs, 2017 PouchDB has had that memory optimisation replaced with a [thread safe version](https://github.com/pouchdb/pouchdb/commit/4a1b4e4b6ac7a46b306a7df6870b9e346ba2fea6). Again many thanks to Nolan.

## Full changelog

### New features

- [#6039](https://github.com/pouchdb/pouchdb/pull/6039) - include id in all bulk_docs results

### Bug fixes and performance improvements

- [#5987](https://github.com/pouchdb/pouchdb/pull/5987) - remove references to "db" option
- [#6002](https://github.com/pouchdb/pouchdb/pull/6002) - remove excessive debug dep
- [#5962](https://github.com/pouchdb/pouchdb/pull/5962) - fix broken verify-bundle-size.sh script
- [#5990](https://github.com/pouchdb/pouchdb/pull/5990) - Use native Map/Set
- [#6012](https://github.com/pouchdb/pouchdb/pull/6012) - replace js-extend with Object.assign
- [#6018](https://github.com/pouchdb/pouchdb/pull/6018) - simplify processNextBatch in mapreduce
- [#5501](https://github.com/pouchdb/pouchdb/pull/5501) - fall back from bulk_get on any error
- [#6027](https://github.com/pouchdb/pouchdb/pull/6027) - remove unused utils.extend
- [#6015](https://github.com/pouchdb/pouchdb/pull/6015) - use Map and Set in mapreduce
- [#6016](https://github.com/pouchdb/pouchdb/pull/6016) - separate funcs for map vs reduce
- [#6031](https://github.com/pouchdb/pouchdb/pull/6031) - faster IDB changes() with batched cursor
- [#5930](https://github.com/pouchdb/pouchdb/pull/5930) - use travis_retry
- [#6055](https://github.com/pouchdb/pouchdb/pull/6055) - remove docCount optimization from IDB
- [#6055](https://github.com/pouchdb/pouchdb/pull/6055) - remove docCount optimization from WebSQL
- [#6089](https://github.com/pouchdb/pouchdb/pull/6089) - Don't add default heartbeat to non-live `_changes` requests
- [#6068](https://github.com/pouchdb/pouchdb/pull/6068) - safely reimplement IDB docCount optimization
- [#6096](https://github.com/pouchdb/pouchdb/pull/6096) - clean up and reduce memory usage of mapreduce
- [#6099](https://github.com/pouchdb/pouchdb/pull/6099) - use Map/Set in viewCleanup()
- [#6101](https://github.com/pouchdb/pouchdb/pull/6101) - add perf test for building secondary indexes

## Get in touch

As always, we welcome feedback from the community and would love to hear what you think of this release as well as PouchDB's future direction. Please don't hesitate to [file issues](https://github.com/pouchdb/pouchdb/issues) or [get in touch](https://github.com/pouchdb/pouchdb/blob/master/CONTRIBUTING.md#get-in-touch). And of course, a big thanks to all of our [new and existing contributors](https://github.com/pouchdb/pouchdb/graphs/contributors)!
