---
layout: post

title: PouchDB 6.1.0
author: Nolan Lawson

---

PouchDB 6.1.0 adds a new feature, `{latest: true}`, as well as several bug fixes and performance improvements. For a full changelog since 6.0.0, including several patch releases up to 6.0.7, please see [the releases page](https://github.com/pouchdb/pouchdb/releases).

## latest: true

CouchDB has an option on [the document endpoint](http://docs.couchdb.org/en/2.0.0/api/document/common.html) called `latest=true`, which will fetch the latest revision of a document in the case where the requested revision has been updated.

For instance, let's say we have a document:

```js
{_id: 'foo', _rev: '1-x'}
```

And we update it, so its revision increments:

```js
{_id: 'foo', _rev: '2-y'}
```

Now, if were were to fetch it using `db.get('foo', {rev: '1-x'})`, that would give us the _old_ revision. However, by doing `db.get('foo', {rev: '1-x', latest: true})`, we'll get the `2-y` revision instead.

This might seem like a niche use case, but this parameter is used by the CouchDB replicator to avoid race conditions where a document is updated right at the moment that it's being synced. This feature has now been added to PouchDB's replication algorithm, meaning that with 6.1.0 onward, replication should be much more robust.

Many thanks to [Will Holley](https://github.com/willholley) for implementing both `{latest: true}` and the replication fixes! See [this PR](https://github.com/pouchdb/pouchdb/issues/5857) for more details.

## Better fetch() implementation

When using PouchDB inside of a Service Worker, the [XMLHttpRequest](https://developer.mozilla.org/en-US/docs/Web/API/XMLHttpRequest) API is unavailable and hence PouchDB uses the new [fetch](https://developer.mozilla.org/en-US/docs/Web/API/Fetch_API/Using_Fetch) API instead. However, this implementation was not previously tested, and feedback from [HospitalRun.io](http://hospitalrun.io/) developer [John Kleinschmidt](https://github.com/jkleinsc/) suggested that PouchDB's `fetch()`-based implementation was less robust than its XHR-based implementation.

In 6.1.0, we have added CI testing for the `fetch()` implementation and also [fixed all outstanding bugs](https://github.com/pouchdb/pouchdb/issues/5902) such that it passes the test suite at 100%. Therefore the new `fetch()` implementation is now just as reliable as the XHR implementation, improving PouchDB's Service Worker support.

In a future release, PouchDB will drop the XHR implementation entirely and use `fetch()` only, with a polyfill for non-`fetch()` browsers.

## Better warnings

When using plugins, we found that folks would often make a mistake like this:

```js
PouchDB.plugin('pouchdb-find');
```

Whereas the proper form is:

```js
PouchDB.plugin(require('pouchdb-find'));
```

Before 6.1.0 this error message was hard to diagnose. As of 6.1.0, though, this will now provide [a more helpful error](https://github.com/pouchdb/pouchdb/pull/5904):

    Invalid plugin: got "pouchdb-find", expected an object or a function

We also found it common to forget to include a `content_type` when inserting attachments, which can lead to hard-to-debug errors later on. Now, an attachment without a `content_type` [will emit a warning](https://github.com/pouchdb/pouchdb/pull/5826):

    Attachment foo.txt on document mydoc is missing content_type

Thanks to [Andy Morris](https://github.com/andymorris) for the `content_type` fix!

## Remove peerDependency on pouchdb-core

Because of the way PouchDB is structured, it's possible to use PouchDB plugins without technically including the `pouchdb-core` package. The reason for this is that packages like `pouchdb`, `pouchdb-browser`, and `pouchdb-node` are aggressively bundled to improve the installation, download, and execution time. So rather than explicitly depend on `pouchdb-core`, they inline it.

Previously, this would generate a warning during `npm install`:

    npm WARN pouchdb-adapter-memory@6.0.7 requires a peer of pouchdb-core@6.0.7 but none was installed.

This warning has been removed in 6.1.0 because it caused confusion more often than it helped.

Unfortunately npm offers no way to emit a `peerDependency` warning only if _any one of_ possible peers (e.g. `pouchdb-core`, `pouchdb`, `pouchdb-browser`, or `pouchdb-node`) are not installed or have the wrong version, so we removed the `peerDependency` entirely.

If you're wondering how to correctly use PouchDB plugins with core PouchDB packages, the answer is fairly simple: first-party plugins should always have the same version as the other core PouchDB packages. These packages are published at the same time with the same versions, so you just need to be sure to keep them synchronized. For instance:

```json
{
  "dependencies": {
     "pouchdb-core": "6.1.0",
     "pouchdb-promise": "6.1.0",
     "pouchdb-replication": "6.1.0",
     "pouchdb-adapter-memory": "6.1.0",
  }
}
```

If these versions do not exactly match (e.g. "6.1.0" and "6.0.7") then PouchDB [will no longer warn you](https://github.com/pouchdb/pouchdb/pull/5925), however the behavior is undefined and could lead to bugs.

Note that third-party dependencies (such as `pouchdb-find`, `worker-pouch`, and `pouchdb-server`) have their own versioning schemes and therefore do not need to be kept in sync.

## Smaller code, fewer dependencies

Like any codebase, PouchDB's has accumulated some cruft over time. As part of [an](https://github.com/pouchdb/pouchdb/pull/5930) [effort](https://github.com/pouchdb/pouchdb/pull/5898) [to](https://github.com/pouchdb/pouchdb/pull/5905) [simplify](https://github.com/pouchdb/pouchdb/pull/5899) the codebase, PouchDB 6.1.0 now has one less dependency ([es6-promise-pool](https://github.com/timdp/es6-promise-pool), replaced with a smaller custom implementation) and actually has a slightly smaller bundle size than 6.0.7 (45337 bytes min+gz to 45299).

Furthermore, PouchDB's internal timer system has been vastly simplified, relying on the built-in browser `setTimeout()` rather than `process.nextTick()` (thus avoiding [a rather large Browserify/Webpack dependency](https://github.com/defunctzombie/node-process/blob/7d8c3702a8bbc43fa55f4bab74b150aef37001dd/browser.js)), as well as eliminating timeouts entirely where they were found to be unnecessary. This will actually result in a performance boost to most PouchDB operations in terms of latency, since PouchDB is no longer yielding to the event loop so frequently.

However, the tradeoff is that this change may also give fewer opportunities for the browser to accept input, hence possibly leading to blocked UIs or slower scrolling. In such cases, if you do experience a sluggish UI on account of PouchDB, we recommend moving PouchDB into a web worker or using [worker-pouch](https://github.com/nolanlawson/worker-pouch) to avoid [blocking the browser UI](http://nolanlawson.com/2015/09/29/indexeddb-websql-localstorage-what-blocks-the-dom/).

## Full changelog

### New features

- [#5857](https://github.com/pouchdb/pouchdb/pull/5857) - add latest:true

### Bug fixes and performance improvements

- [#5857](https://github.com/pouchdb/pouchdb/pull/5857) - use latest:true during replication
- [#5904](https://github.com/pouchdb/pouchdb/pull/5904) - more helpful error message for invalid plugin
- [#5736](https://github.com/pouchdb/pouchdb/pull/5736) - warn about attachments without content_type
- [#5925](https://github.com/pouchdb/pouchdb/pull/5925) - remove peerDependency on pouchdb-core
- [#5922](https://github.com/pouchdb/pouchdb/pull/5922) - transitive default
- [#5930](https://github.com/pouchdb/pouchdb/pull/5930) [#5898](https://github.com/pouchdb/pouchdb/pull/5898) - simplify timeouts
- [#5934](https://github.com/pouchdb/pouchdb/pull/5934) - simplify parseAdapter
- [#5905](https://github.com/pouchdb/pouchdb/pull/5905) - remove es6-promise-pool
- [#5899](https://github.com/pouchdb/pouchdb/pull/5899) - simplify PouchError code
- [#5902](https://github.com/pouchdb/pouchdb/pull/5902) - fix fetch() implementation
- [#5886](https://github.com/pouchdb/pouchdb/pull/5886) - fix bulkGet() with reserved _id
- [#5855](https://github.com/pouchdb/pouchdb/pull/5855) - fix JSON.parse() overflows
- [#5883](https://github.com/pouchdb/pouchdb/pull/5883) - retrieve appropriate _revisions when there are duplicate rev hashes
- [#5832](https://github.com/pouchdb/pouchdb/pull/5832) - return correct revision after doc update
- [#5479](https://github.com/pouchdb/pouchdb/pull/5479) - ensure sync events are called the correct number of times
- [#5812](https://github.com/pouchdb/pouchdb/pull/5812) - fix memory leaks in pouchdb-core
- [#5793](https://github.com/pouchdb/pouchdb/pull/5793) - fixes for Couchbase Sync Gateway
- [#5988](https://github.com/pouchdb/pouchdb/pull/5988) - remove unsafe `new Buffer()` usages

## Get in touch

As always, we welcome feedback from the community and would love to hear what you think of this release as well as PouchDB's future direction. Please don't hesitate to [file issues](https://github.com/pouchdb/pouchdb/issues) or [get in touch](https://github.com/pouchdb/pouchdb/blob/master/CONTRIBUTING.md#get-in-touch). And of course, a big thanks to all of our [new and existing contributors](https://github.com/pouchdb/pouchdb/graphs/contributors)!
