---
layout: post

title: PouchDB 6.0.0&#58; Labour Day
author: Dale Harvey

---

To celebrate the USA and Canada's Labo(u)r Day, we have decided to work extra hard to bring
you PouchDB 6.0.0. This release brings early retirement to those features that have done great
work over the years, but whose services are no longer necessary (don't worry, we will pay
their pensions in full).

Along with the removed features, we have a large list of bugfixes, documentation
work and general improvements for you to enjoy with your BBQ.

### Removed Features

PouchDB 5.4.0 introduced some deprecations. In 6.0.0, we have now removed these
features permanently:

#### ([#5154](https://github.com/pouchdb/pouchdb/issues/5154)) - Remove `db.put(doc, id, rev)`

Please use `db.put({_id: id, _rev: rev, data: 'foo'})` instead.

#### ([#5251](https://github.com/pouchdb/pouchdb/issues/5251)) - Remove `new PouchDB(dbName).then`

The constructor is now stateless. If you need to test whether setup can complete,
then `new PouchDB(dbName).info()` can do that for you.

Note this also applies to the callback style, i.e. `new PouchDB(dbName, function (err) { /* ... */ })`.

#### ([#5591](https://github.com/pouchdb/pouchdb/pull/5519)) - Remove SQLite Plugin support

The WebSQL adapter no longer automatically detects the SQLite Plugin in Cordova environments.
Please use the [pouchdb-adapter-cordova-sqlite](https://github.com/nolanlawson/pouchdb-adapter-cordova-sqlite) plugin instead.

#### ([#5519](https://github.com/pouchdb/pouchdb/pull/5591)) - Remove `extras` API

APIs like `require('pouchdb/extras/ajax')` are gone. Instead these have been extracted out into 
separate packages:

<div class="table-responsive">
<table class="table">
  <thead>
  <tr>
    <th>Removed</th>
    <th>Use instead</th>
  </tr>
  </thead>
  <tbody>
  <tr>
    <td><code>require('pouchdb/extras/ajax')</code></td>
    <td><code>require('pouchdb-ajax')</code></td>
  </tr>
  <tr>
    <td><code>require('pouchdb/extras/checkpointer')</code></td>
    <td><code>require('pouchdb-checkpointer')</code></td>
  </tr>
  <tr>
    <td><code>require('pouchdb/extras/generateReplicationId')</code></td>
    <td><code>require('pouchdb-generate-replication-id')</code></td>
  </tr>
  <tr>
    <td><code>require('pouchdb/extras/promise')</code></td>
    <td><code>require('pouchdb-promise')</code></td>
  </tr>
  <tr>
    <td><code>require('pouchdb/extras/fruitdown')</code></td>
    <td><code>require('pouchdb-adapter-fruitdown')</code>*</td>
  </tr>
  <tr>
    <td><code>require('pouchdb/extras/localstorage')</code></td>
    <td><code>require('pouchdb-adapter-localstorage')</code>*</td>
  </tr>
  <tr>
    <td><code>require('pouchdb/extras/memory')</code></td>
    <td><code>require('pouchdb-adapter-memory')</code>*</td>
  </tr>
  <tr>
    <td><code>require('pouchdb/extras/websql')</code></td>
    <td><code>require('pouchdb-adapter-node-websql')</code>*</td>
  </tr>
  </tbody>
</table>
</div>

{% include alert/start.html variant="info"%}
{% markdown %}
\* For the adapters, you'll also need to explicitly register them using `PouchDB.plugin()`, e.g. `PouchDB.plugin(require('pouchdb-adapter-memory'))`. Please see [Custom builds](/custom.html) for more info.
{% endmarkdown %}
{% include alert/end.html%}

#### ([#5435](https://github.com/pouchdb/pouchdb/pull/5435)) - Remove `getUrl()`, `getHeaders()` from HTTP adapter

Instead of the `getUrl()` API, you can use `db.name` to determine the URL for HTTP-based adapters. For `getHeaders()`
no replacement is intended. Both APIs were previously undocumented.

#### ([#5625](https://github.com/pouchdb/pouchdb/pull/5625), [#5590](https://github.com/pouchdb/pouchdb/pull/5590)) - Remove node-websql as dependency, remove `optionalDependencies`

`leveldown` and `websql` are no longer optional dependencies. Instead, `websql` is removed entirely (use
[pouchdb-adapter-node-websql](https://www.npmjs.com/package/pouchdb-adapter-node-websql) instead), and `leveldown` is
now required.

If you want to avoid installing `leveldown`, then you can use the [pouchdb-browser](https://www.npmjs.com/package/pouchdb-browser) preset if you don't need Node support, or you can use [pouchdb-memory](https://www.npmjs.com/package/pouchdb-memory) if you only need an in-memory database. For all other uses, see [Custom builds](/custom.html).

#### ([#5612](https://github.com/pouchdb/pouchdb/pull/5612)) - Sandbox view and filter function execution

View and filter functions now execute in `'use strict'` environments and within a sandbox in Node. If you were depending on
non-strict mode or non-sandboxed behavior, then you will need to change your view/filter functions.

### Bugfixes

* ([#5214](https://github.com/pouchdb/pouchdb/issues/5214)) - Stop squelching errors
* ([#3962](https://github.com/pouchdb/pouchdb/issues/3962)) - Limit concurrent attachment requests
* ([#4632](https://github.com/pouchdb/pouchdb/issues/4632)) - Fix attachment md5sum memory leak
* ([#4967](https://github.com/pouchdb/pouchdb/issues/4967)) - Fix map function called twice
* ([#5402](https://github.com/pouchdb/pouchdb/issues/5402)) - Remove the unbounded accumulation of listeners
* ([#5379](https://github.com/pouchdb/pouchdb/issues/5379)) - Do not update checkpoint if last_seq has not changed
* ([#5441](https://github.com/pouchdb/pouchdb/issues/5441)) - Release memory faster in ajax requests
* ([#5450](https://github.com/pouchdb/pouchdb/issues/5450)) - Don't leak change listeners
* ([#5172](https://github.com/pouchdb/pouchdb/issues/5172)) - Differentiate between validation and non-validation errors
* ([#5527](https://github.com/pouchdb/pouchdb/issues/5527)) - Check if ArrayBuffer is defined before binary check
* ([#5471](https://github.com/pouchdb/pouchdb/issues/5471)) - PouchDB.plugin() giving more helpful errors
* ([#5574](https://github.com/pouchdb/pouchdb/issues/5574)) - Encode db name if opts.prefix is a URL
* ([#5443](https://github.com/pouchdb/pouchdb/issues/5443)) - Use PUT when checkpointing to remote dbs
* ([#5612](https://github.com/pouchdb/pouchdb/issues/5612)) - Change view & filter function execution
* ([#5491](https://github.com/pouchdb/pouchdb/issues/5491)) - Fix for scenario where xhr.response === null
* ([#5584](https://github.com/pouchdb/pouchdb/issues/5584)) - Support options.timeout in a replication's bulkDocs()


### Documentation

* ([#5359](https://github.com/pouchdb/pouchdb/pull/5359)) - Remove whitespace that breaks markdown rendering
* ([#5836](https://github.com/pouchdb/pouchdb/pull/5368)) - Remove references to index.html to fix excerpts
* ([#5304](https://github.com/pouchdb/pouchdb/pull/5304)) - Add ServiceWorker support to the website
* ([#5418](https://github.com/pouchdb/pouchdb/pull/5418)) - Added PouchDB packages (websocket / stream)
* ([#5422](https://github.com/pouchdb/pouchdb/pull/5422)) - Added GRADEpro GDT to the list of users of PouchDB
* ([#5449](https://github.com/pouchdb/pouchdb/pull/5449)) - Add info about the emit fn in map functions
* ([#5556](https://github.com/pouchdb/pouchdb/pull/5556)) - Fix typo: seperate -> separate
* ([#5570](https://github.com/pouchdb/pouchdb/pull/5570)) - Fix tiny wording issue in changes() docs
* ([#5594](https://github.com/pouchdb/pouchdb/pull/5594)) - Fix typo in CoC
* ([#5597](https://github.com/pouchdb/pouchdb/pull/5597)) - Added last_seq to example
* ([#5412](https://github.com/pouchdb/pouchdb/pull/5412)) - markdownify headings
* ([#5602](https://github.com/pouchdb/pouchdb/pull/5602)) - Update ISSUE_TEMPLATE.md


### Get in touch

As always, please [file issues](https://github.com/pouchdb/pouchdb/issues) or [tell us what you think](https://github.com/pouchdb/pouchdb/blob/master/CONTRIBUTING.md#get-in-touch). And of course, a big thanks to all of our [new and existing contributors](https://github.com/pouchdb/pouchdb/graphs/contributors)!

