---
layout: post

title: PouchDB 5.4.0
author: Nolan Lawson

---

I'm happy to announce PouchDB 5.4.0, which is a minor release with a few new features, many bugfixes, and a handful of deprecations.

The big feature of 5.4.0 is the new [Custom Builds API](/custom.html), which has its own separate [introductory blog post](/2016/06/06/introducing-pouchdb-custom-builds.html). This post serves mostly as a changelog and summary.

One major bugfix is that PouchDB now supports Node 6. For those who have opted to stick with Node 5, it is certainly the more stable choice
(or even better: Node 4, which is an LTS release), but feel free to upgrade to Node 6 now if you're feeling adventuresome.

Another milestone is that PouchDB is now [tested at 100% code coverage](https://github.com/pouchdb/pouchdb/commit/fb77927d2f14911478032884f1576b770815bcab), and the build will actually fail if it ever drops below that. Big props to Dale Harvey for the massive amount of effort he's put into the test infrastructure to reach this point.

Another change that fellow library authors may find interesting: we are now [building in Node 5 but testing in other versions](https://github.com/pouchdb/pouchdb/issues/5186). This means that our build dependencies do not need to support "troublesome" versions of Node such as 0.10 or 6; only our runtime dependencies need to.

### Deprecations

We have outright removed some undocumented APIs, and added warnings for some (formerly) documented APIs. Please read carefully in case you are using any of these features.

**Deprecation #1: PouchDB.utils, PouchDB.ajax, PouchDB.Errors**

We have removed the `PouchDB.utils`, `PouchDB.ajax`, and `PouchDB.Errors` APIs. These were always
undocumented and unsupported, and we regret if anybody accidentally ended up relying on them.

If you are using these APIs you can now `require` them directly as so:

```js
var PouchDB = require('pouchdb');
PouchDB.utils = { promise: require('pouchdb-promise') };
PouchDB.ajax = require('pouchdb-ajax');
PouchDB.Errors = require('pouchdb-errors');
```

Alternatively you can look at the [Custom Builds API](/custom.html) instead.

**Deprecation #2: db.put(doc, id, rev)**

```js
db.put({}, 'myid', '2-xxx');
```

Instead of doing this, please put the `_id` and `_rev` on the document itself:

```js
db.put({_id: 'myid', _rev: '2-xxx'});
```

This API was not removed, but will log a warning if you try to use it.

**Deprecation #3: new PouchDB(dbName, callback)**

```js
var db = new PouchDB('mydb', function (err) {
  // called when PouchDB has asynchronously finished setting up
  // (or has errored)
});
```

Instead of using this format (which has been undocumented and unrecommended for
some time), please do:

```js
var db = new PouchDB('mydb');
db.info().then(function () {
  // db is now ready
}).catch(/* ... */);
```

There is no need to "wait" for the PouchDB constructor to asynchronously finish
setting up, since the constructor has been made stateless. However, if you really
want to verify that the database is ready and working, you can do an `info()` request.

This API was not removed, but will log a warning if you try to use it.

### New features

* ([#5128](https://github.com/pouchdb/pouchdb/issues/5128)) - custom builds
* ([#5128](https://github.com/pouchdb/pouchdb/issues/5128)) - multi-package architecture
* ([#5128](https://github.com/pouchdb/pouchdb/issues/5128)) - `jsnext:main` support


### Bugfixes

* ([#3539](https://github.com/pouchdb/pouchdb/issues/3539)) - Ensure throw in user code does not effect pouch
* ([#5272](https://github.com/pouchdb/pouchdb/issues/5272)) - Fix checkpointing against Cloudant/CouchDB 2.0
* ([#5225](https://github.com/pouchdb/pouchdb/issues/5225)) - Guard uses of console before calling it
* ([#5238](https://github.com/pouchdb/pouchdb/issues/5238)) - Fix unhandled rejection in changes
* ([#3923](https://github.com/pouchdb/pouchdb/issues/3923)) - Add ability to set url as prefix
* ([#4922](https://github.com/pouchdb/pouchdb/issues/4922)) - Do not call 'destroyed' twice for http instances
* ([#3609](https://github.com/pouchdb/pouchdb/issues/3609)) - opts.view implies filter=_view
* ([#4444](https://github.com/pouchdb/pouchdb/issues/4444)) - Don't leak event emitters
* ([#5197](https://github.com/pouchdb/pouchdb/issues/5197)) - detect WebSQL invalid on WKWebView
* ([#5200](https://github.com/pouchdb/pouchdb/issues/5200)) - Don't clone special objects like Workers
* ([#5196](https://github.com/pouchdb/pouchdb/issues/5196)) - fix excessively long replication loop
* ([#5157](https://github.com/pouchdb/pouchdb/issues/5157)) - avoid launching more requests than browser can perform
* ([#5140](https://github.com/pouchdb/pouchdb/issues/5140)) - remove use of buffer.toArrayBuffer()
* ([#5118](https://github.com/pouchdb/pouchdb/issues/5118)) - Revert "([#4867](https://github.com/pouchdb/pouchdb/issues/4867)) - Cache ddoc views and filters"
* ([#2674](https://github.com/pouchdb/pouchdb/issues/2674)) - avoid unneeded attachment GET requests

### Deprecations

* ([#5251](https://github.com/pouchdb/pouchdb/issues/5251)) - Add deprecation notice for async constructor
* ([#5154](https://github.com/pouchdb/pouchdb/issues/5154)) - Add deprecation notice for db.put(doc, id, rev)
 
### Documentation

* ([#5094](https://github.com/pouchdb/pouchdb/issues/5094)) - Remove editable title from home page
* ([#5089](https://github.com/pouchdb/pouchdb/issues/5089)) - Fix the install jekyll script
* ([#4199](https://github.com/pouchdb/pouchdb/issues/4199)) - add a download specific page
* ([#5084](https://github.com/pouchdb/pouchdb/issues/5084)) - Use bundler to install jekyll dependencies
* ([#5083](https://github.com/pouchdb/pouchdb/issues/5083)) - Saving of 12kb in payload if site css is minified
* ([#5080](https://github.com/pouchdb/pouchdb/issues/5080)) - Fix docs replication batch_size
* ([#5082](https://github.com/pouchdb/pouchdb/issues/5082)) - Remove references to iriscouch ([#5234](https://github.com/pouchdb/pouchdb/issues/5234))
* ([#4493](https://github.com/pouchdb/pouchdb/issues/4493)) - Mention implication of views on size param ([#5241](https://github.com/pouchdb/pouchdb/issues/5241))
* ([#5080](https://github.com/pouchdb/pouchdb/issues/5080)) - Clarify batch_size documentation
* ([#4573](https://github.com/pouchdb/pouchdb/issues/4573)) - Remove outdated Firefox Inspector link

### Testing

* ([#4575](https://github.com/pouchdb/pouchdb/issues/4575)) - Fix tests against CouchDB master
* ([#5260](https://github.com/pouchdb/pouchdb/issues/5260)) - Catches unhandled rejections in tests
* ([#2426](https://github.com/pouchdb/pouchdb/issues/2426)) - Add test to ensure doc_ids don't prevent replication
* ([#4767](https://github.com/pouchdb/pouchdb/issues/4767)) - 100% code coverage
* ([#5186](https://github.com/pouchdb/pouchdb/issues/5186)) - build in Node 5, test in other Nodes

### Get in touch

As always, please [file issues](https://github.com/pouchdb/pouchdb/issues) or [tell us what you think](https://github.com/pouchdb/pouchdb/blob/master/CONTRIBUTING.md#get-in-touch). And of course, a big thanks to all of our [new and existing contributors](https://github.com/pouchdb/pouchdb/graphs/contributors)!
