---
layout: post

title: PouchDB 5.3.0&#58; SQLite support in Node
author: Nolan Lawson

---

PouchDB 5.3.0 is released today, with a new feature: SQLite support in Node,
using [node-websql](https://github.com/nolanlawson/node-websql). This means
that, in addition to the LevelDB-based [LevelDOWN](https://github.com/Level/leveldown) (or any [other *DOWN adapter](https://github.com/Level/levelup/wiki/Modules#storage-back-ends)), you can now
also use [sqlite3](https://github.com/mapbox/node-sqlite3), via PouchDB's
WebSQL adapter.

To get started, just do:

```js
require('pouchdb/extras/websql');
var db = new PouchDB('database.db', {adapter: 'websql'})
```

This feature will also be available in [PouchDB Server](https://github.com/pouchdb/pouchdb-server/), as `pouchdb-server --sqlite`.

Note that this doesn't change the behavior of the WebSQL adapter in the browser.
That adapter is still bundled by default in PouchDB's browser version. For more
details, see the ["extras" API documentation]({{ site.baseurl }}/api.html#extras).

### Changelog

#### Features

* Support WebSQL in Node via node-websql ([#4915](https://github.com/pouchdb/pouchdb/issues/4915))

#### Bugfixes

* Escape unicode in auth header ([#4903](https://github.com/pouchdb/pouchdb/issues/4903))
* Fix cache-busting in Edge ([#4827](https://github.com/pouchdb/pouchdb/issues/4827))
* Better error when trying to re-use a destroyed database ([#4339](https://github.com/pouchdb/pouchdb/issues/4339))
* Cache ddoc views and filters ([#4867](https://github.com/pouchdb/pouchdb/issues/4867))
* Allow creating databases with reserved words ([#4898](https://github.com/pouchdb/pouchdb/issues/4898))
* Fix missing key in ungrouped (custom) reduce functions ([#4878](https://github.com/pouchdb/pouchdb/issues/4878))
* Fix leaking of stemmed revisions ([#4372](https://github.com/pouchdb/pouchdb/issues/4372))

### Get in touch

As always, please [file issues](https://github.com/pouchdb/pouchdb/issues) or [tell us what you think](https://github.com/pouchdb/pouchdb/blob/master/CONTRIBUTING.md#get-in-touch). And as always, a big thanks to all of our [new and existing contributors](https://github.com/pouchdb/pouchdb/graphs/contributors)!
