---
layout: post

title: PouchDB 5.1.0 - Cover all the things
author: Dale Harvey

---

It is time for the regularly scheduled PouchDB release, this month has a nice set of improvements, and we even managed to remove a little (`3KB`) around the edges.

### Coverage

We are now very happy to be hitting [100% coverage on our tests](https://coveralls.io/github/pouchdb/pouchdb/). This currently only covers Node.js and excludes some cases that are difficult to test but it does give us confidence that our shared code is very well tested and we can ensure new code that is merged has the same level of testing.

### GreenKeeper

We have had issues in the past with how to manage npm dependencies. Version ranges can lead to other people breaking PouchDB with their releases, and strict versions lead to us using stagnant packages and not being aware of upcoming breakages. During this month, the [hood.ie team](http://hood.ie) released [GreenKeeper](http://greenkeeper.io) which gives us best of both worlds, stable versions that are always kept up to date!

### New features

* Add an option to configure `withCredentials` on CORS requests ([#2513](http://github.com/pouchdb/pouchdb/issues/2513))
* Allow user to disable `heartbeat` in HTTP requests ([#4490](http://github.com/pouchdb/pouchdb/issues/4490))

### Bugfixes

* Explain http error caused by checking for `_bulk_get` ([#4435](http://github.com/pouchdb/pouchdb/issues/4435))
* Don't create a database just to delete it ([#4467](http://github.com/pouchdb/pouchdb/issues/4467))
* Add friendly err msg to common leveldown err ([#4447](http://github.com/pouchdb/pouchdb/issues/4447))
* Avoid empty bulkGet() ([#4474](http://github.com/pouchdb/pouchdb/issues/4474))
* Fix http url with port 80 ([#247](https://github.com/pouchdb/express-pouchdb/issues/247))
* Url encode http database name ([#4314](http://github.com/pouchdb/pouchdb/issues/4314))
* Handle invalid view name consistently ([#4451](http://github.com/pouchdb/pouchdb/issues/4451))
* Remove put implementation and fix local doc handling ([#1526](http://github.com/pouchdb/pouchdb/issues/1526))
* Fix cross origin check ([#4501](http://github.com/pouchdb/pouchdb/issues/4501))

### Get in touch

Please [file issues](https://github.com/pouchdb/pouchdb/issues) or [tell us what you think](https://github.com/pouchdb/pouchdb/blob/master/CONTRIBUTING.md#get-in-touch). And as always, a big thanks to all of our [new and existing contributors](https://github.com/pouchdb/pouchdb/graphs/contributors)!
