---
layout: post

title: PouchDB 5.0.0 - Five years of PouchDB
author: Nolan Lawson

---

Fitting with the fact that [PouchDB turned five years old this year](https://github.com/pouchdb/pouchdb/commit/d600081962d3f54b410e5cfcf78cd413ad94abb9), we're proud to announce PouchDB 5.0.0. This release contains the usual number of bugfixes and improvements, as well as several deprecations, since it is a major version bump.

The biggest news in terms of features is support for [\_bulk\_get](https://mail-archives.apache.org/mod_mbox/couchdb-dev/201509.mbox/%3CCA%2BvSmEYjimR3emsgHOTkNqdBcN_Rvh-V9gQZtDBVAEEcMO1TQQ%40mail.gmail.com%3E), which is a new CouchDB API that enables vastly faster replication, set to be debuted in CouchDB 2.0. This API is also shipped in the newly-released PouchDB Server 1.0.0, meaning you can test out the faster replication now.

### Deprecations

* Remove `PouchDB.destroy()` ([#4223](http://github.com/pouchdb/pouchdb/issues/4223))

Having a `destroy()` function on the `PouchDB` object was always a little awkward, which is why we introduced the `db.destroy()` alternative. So now that `PouchDB.destroy()` is out, upgrading your code should look like this:

```js
PouchDB.destroy('mydb');
```

becomes:

```js
new PouchDB('mydb').destroy();
```

Keep in mind that the `PouchDB` object is no longer usable after you `destroy()` it. So you should call `new PouchDB()` again if you want to re-use it.

* Remove CRUD events ([#4224](http://github.com/pouchdb/pouchdb/issues/4224))

These events (`'create'`, `'update'`, and `'delete'`) were intended to make the `changes()` API easier to work with, but they ended up being too ambitious and confusing, so 5.0.0 removes them.

If you are relying on these events, then you can upgrade like so:

```js
db.changes({live: true})
  .on('create', createListener)
  .on('update', updateListener)
  .on('delete', deleteListener);
```

becomes:


```js
db.changes({live: true})
  .on('change', function (change) {
    if (change.deleted) {
      deleteListener(change);
    } else if (change.changes.length === 1 &&
               /^1-/.test(change.changes[0].rev)) {
      createListener(change);
    } else {
      updateListener(change);
    }
  });
```

Keep in mind that this "update vs. create" test is not foolproof (what happens if a `2-` document is the first version that gets synced? what happens if two conflicting `1-` revisions are synced?), but it will match the old behavior.

Most of the time, your UI should be able to handle document "updates" or "creates" equivalently, so `change.deleted` becomes the only special case. See [Efficiently managing UI state with PouchDB]({{ site.baseurl }}/2015/02/28/efficiently-managing-ui-state-in-pouchdb.html) for some details about how to do this.

* Remove `idb-alt` plugin ([#4222](http://github.com/pouchdb/pouchdb/issues/4222))

This was an alternative IndexedDB adapter based on [Level.js](https://github.com/maxogden/level.js), which was experimental and probably unused by anyone except the PouchDB developers themselves.

### New features

* Implement `bulkGet()` ([#3424](http://github.com/pouchdb/pouchdb/issues/3424))
* Add [FruitDOWN](https://github.com/nolanlawson/fruitdown) as a supported adapter ([#4329](http://github.com/pouchdb/pouchdb/issues/4329))
* Allow user to specify Firefox persistent storage ([#4315](http://github.com/pouchdb/pouchdb/issues/4315))
* Allow setting http options per request ([#3941](http://github.com/pouchdb/pouchdb/issues/3941))

### Bugfixes

* Maintain canceled state in replicator better ([#4276](http://github.com/pouchdb/pouchdb/issues/4276))
* Don't mutate binary objects provided by the user ([#3955](http://github.com/pouchdb/pouchdb/issues/3955) [#4273](http://github.com/pouchdb/pouchdb/issues/4273))
* Fire events on sync, ensure we only fire one active event ([#4251](http://github.com/pouchdb/pouchdb/issues/4251))
* Catch errors from WebSQL `openDatabase()` ([#4018](http://github.com/pouchdb/pouchdb/issues/4018))
* Ensure setup errors propagate to the API ([#4358](http://github.com/pouchdb/pouchdb/issues/4358))
* Prevent replication firing extra events ([#4293](http://github.com/pouchdb/pouchdb/issues/4293))
* Proper propagation of quota exceeded errors ([#4018](http://github.com/pouchdb/pouchdb/issues/4018))
* Remove `'use strict'` from `eval()` ([#4344](http://github.com/pouchdb/pouchdb/issues/4344))
* Alias `skip_setup` to `skipSetup` ([#3535](http://github.com/pouchdb/pouchdb/issues/3535))
* Fix options usage within http adapter ([#4313](http://github.com/pouchdb/pouchdb/issues/4313))
* Fix Firefox `FileReader` usage in a web worker ([#4402](http://github.com/pouchdb/pouchdb/issues/4402))

### Get in touch

Please [file issues](https://github.com/pouchdb/pouchdb/issues) or [tell us what you think](https://github.com/pouchdb/pouchdb/blob/master/CONTRIBUTING.md#get-in-touch). And as always, a big thanks to all of our [new and existing contributors](https://github.com/pouchdb/pouchdb/graphs/contributors)!
