---
layout: post

title: PouchDB 4.0.2 - A Little Extra
author: Nolan Lawson

---

4.0.2 is a quick update to sneak in some important bugfixes in anticipation of the next monthly release.

The most visible change in 4.0.2 is the long-awaited upgrade of `levelup` and `leveldown` to 1.x ([#3873](https://github.com/pouchdb/pouchdb/issues/3873)), which contains some big improvements to how `leveldown` is installed. With 4.0.2, instead of needing to recompile `leveldown` every time PouchDB is `npm install`ed, it will simply be downloaded thanks to [leveldown-prebuilt](https://github.com/mafintosh/leveldown-prebuilt). So if you've ever groaned at the dreaded `node-gyp rebuild` console message, hop onto 4.0.2 and enjoy the faster install times!

Also noteworthy is that the in-memory adapter is now fully tested and working in IE 10+, thanks to fixes in [#4216](https://github.com/pouchdb/pouchdb/issues/4216).

Another big change is that PouchDB is more stable when replicating during intermittent connectivity, thanks to a new "stateless constructor" in the HTTP adapter ([#4146](https://github.com/pouchdb/pouchdb/issues/4146)). Instead of kicking off HTTP requests immediately when you call `new PouchDB('http://example.com/db')`, the new version will wait for the first method call, such as `db.info()`.

### Changelog

#### Bugfixes

* Handle errors thrown from `filter` functions ([#3356](https://github.com/pouchdb/pouchdb/issues/3356))
* Upgrade `levelup` to 1.2.1, `leveldown` to 1.4.1, and `level-sublevel` to 6.5.0 ([#3873](https://github.com/pouchdb/pouchdb/issues/3873))
* Stateless constructor for the HTTP adapter, fixes errors syncing while offline ([#4146](https://github.com/pouchdb/pouchdb/issues/4146))
* Ensure document properties are maintained, e.g. docs with keys like `hasOwnProperty` ([#3968](https://github.com/pouchdb/pouchdb/issues/3968))
* Validate attachment names don't start with `_` ([#3357](https://github.com/pouchdb/pouchdb/issues/3357))
* Correctly respect the `revs_limit` of 1000, trim revision trees ([#4204](https://github.com/pouchdb/pouchdb/issues/4204))
* Allow passing in opts to `destroy()` ([#4219](https://github.com/pouchdb/pouchdb/issues/4219))
* Update `request` to 2.61.0 ([#4260](https://github.com/pouchdb/pouchdb/issues/4260))
* Use `Function.prototype.name` shim consistently for IE ([#4216](https://github.com/pouchdb/pouchdb/issues/4216))
* Better CORS warning ([#4256](https://github.com/pouchdb/pouchdb/issues/4256))

### Thank yous

A special thanks for this release goes to [Julian Gruber](https://github.com/juliangruber) of the [Level](https://github.com/level) community, without [whose help](https://github.com/dominictarr/level-sublevel/pull/96) we wouldn't have been able to upgrade `levelup`/`leveldown`/`level-sublevel`. Thanks, Julian!

### Get in touch

Please [file issues](https://github.com/pouchdb/pouchdb/issues) or [tell us what you think](https://github.com/pouchdb/pouchdb/blob/master/CONTRIBUTING.md#get-in-touch). And as always, a big thanks to all of our [new and existing contributors](https://github.com/pouchdb/pouchdb/graphs/contributors)!
