---
layout: post

title: PouchDB 4.0.1 - Gotta Go Fast
author: Nolan Lawson

---

I'm a big fan of classic video games. So when I hack on PouchDB, my inspiration is this guy:

{% include img.html src="sonic_waiting.gif" alt="Sonic the Hedgehog tapping his foot with visible irritation" %}

In *Sonic the Hedgehog*, the titular hero taps his foot impatiently any time you stop moving. It's almost as if he's egging you on, urging you to go faster. *Come on, what's the holdup?*

With PouchDB, performance is one of our top concerns; we don't want any holdups either. So 4.0.1 is a patch release containing some bugfixes, but mostly a lot of speedups.

This blog post has a detailed performance report as well as some community news, but first the changelog:

### Changelog

#### Bugfixes

* Correctly support `start_key` and `end_key` aliases ([#3833](https://github.com/pouchdb/pouchdb/issues/3833) [#4154](https://github.com/pouchdb/pouchdb/issues/4154))
* Fix memory leak in `PouchDB` constructor ([#4157](https://github.com/pouchdb/pouchdb/issues/4157) [#4168](https://github.com/pouchdb/pouchdb/pull/4168) [#4182](https://github.com/pouchdb/pouchdb/pull/4182))
* Update Uglify to patch security vulnerability ([#4203](https://github.com/pouchdb/pouchdb/issues/4203))
* Fix inconsistent Date serialization in IndexedDB ([#3444](https://github.com/pouchdb/pouchdb/issues/3444))
* Fix error for invalid `doc_ids` ([#2204](https://github.com/pouchdb/pouchdb/issues/2204))
* Better CORS warning message ([#4189](https://github.com/pouchdb/pouchdb/issues/4189))
* Fix memory adapter in IE10 by shimming `Function.prototype.name` ([#4216](https://github.com/pouchdb/pouchdb/issues/4216))
* Don't fail replication if fetching uuid fails ([#4094](https://github.com/pouchdb/pouchdb/issues/4094))

#### Code cleanup, simplification

* Update `lie` ([#4130](https://github.com/pouchdb/pouchdb/issues/4130))
* Deleted/simplified lots of code ([#4103](https://github.com/pouchdb/pouchdb/issues/4103) [#4121](https://github.com/pouchdb/pouchdb/issues/4121) [#4160](https://github.com/pouchdb/pouchdb/issues/4160) [#4144](https://github.com/pouchdb/pouchdb/issues/4144))

#### Performance improvements

* Avoid extra HTTP call for `destroy()` ([#4159](https://github.com/pouchdb/pouchdb/issues/4159))
* Various fixes to improve performance of updating documents ([#3921](https://github.com/pouchdb/pouchdb/issues/3921) [#4140](https://github.com/pouchdb/pouchdb/issues/4140) [#4149](https://github.com/pouchdb/pouchdb/issues/4149) [#4151](https://github.com/pouchdb/pouchdb/issues/4151) [#4162](https://github.com/pouchdb/pouchdb/issues/4162) [#4183](https://github.com/pouchdb/pouchdb/issues/4183) [#4110](https://github.com/pouchdb/pouchdb/issues/4110) [#4185](https://github.com/pouchdb/pouchdb/issues/4185) [#4188](https://github.com/pouchdb/pouchdb/issues/4188))
* Improve performance of `api.html` page in docs ([#4117](https://github.com/pouchdb/pouchdb/issues/4117))

### Community news

#### Slack channel

PouchDB now has a [Slack channel](http://slack.pouchdb.com). It's linked to the [IRC channel](irc://freenode.net/#pouchdb), so any messages will show up in both.

Please note: this isn't a vote against IRC. While we love open-source, decentralized software (such as PouchDB itself!), many folks find it easier and more familiar to collaborate with Slack. So we're happy to support both systems.

#### First timers

Inspired by Kent C. Dodd's article ["First Timers Only"](https://kentcdodds.com/blog/first-timers-only), we set up [two](https://github.com/pouchdb/pouchdb/issues/3883#issuecomment-130370436) [issues](https://github.com/pouchdb/pouchdb/issues/4154#issuecomment-134572814) designed for first-time contributors, with detailed instructions to get started with the PouchDB source code.

We're happy to report that the experiment was a success. Both issues were fixed in no time flat &ndash; less than 24 hours each! And as a result, we've been pleased to welcome [Charlotte Spencer](https://github.com/charlotteis) and [Nicolas Brugneaux](https://github.com/nicolasbrugneaux) as PouchDB contributors. Welcome to the gang, Charlotte and Nicolas!

If you'd like to join PouchDB's [esteemed roster of contributors](https://github.com/pouchdb/pouchdb/graphs/contributors) (161 and counting!), then hit us up in IRC, Slack, or Github, and we'll be happy to coach you to help find an issue where you can pitch in. We also plan to continue this program by marking issues as ["Help wanted"](https://github.com/pouchdb/pouchdb/labels/help%20wanted) and ["First-timers only"](https://github.com/pouchdb/pouchdb/labels/first%20timers%20only).

#### PouchDB Server improvements

[PouchDB Server](http://github.com/pouchdb/pouchdb-server) and its core, [express-pouchdb](http://github.com/pouchdb/express-pouchdb), have seen some notable improvements in the past month. In addition to a roughly 4% per-request [performance improvement](https://github.com/pouchdb/pouchdb-size/pull/2), the UI now supports [uploading attachments](https://github.com/pouchdb/express-pouchdb/pull/237) and sports a snazzier version of the Fauxton UI:

{% include img.html src="fauxton_updated.png" alt="New Fauxton UI in PouchDB Server" %}

This update fixes lots of UI and UX bugs with the Fauxton interface, as well as allowing an easy way to test the new [Mango query language](https://github.com/cloudant/mango), which are partially supported in PouchDB Server via [pouchdb-find](https://github.com/nolanlawson/pouchdb-find). You can get the latest version by running `npm install -g pouchdb-server`.

Many thanks to Nick Colley, Marten de Vries, and the formidable [CouchDB Fauxton team](https://github.com/pouchdb/pouchdb-fauxton/graphs/contributors) for their help with this release!

#### Hoodie + PouchDB Server = &#10084;

In related news, Hoodie has [added support for PouchDB Server](https://twitter.com/gr2m/status/632197399314866176), replacing CouchDB as their default backend.

This is a great vote of confidence for PouchDB Server, and shows how its combination of easy installation and near-complete API compatibility with CouchDB makes it a perfect drop-in replacement, especially during development and testing.

### Performance report

We recently had a [performance problem](https://github.com/pouchdb/pouchdb/issues/3921) reported to us via StackOverflow. So I took it as an opportunity to thoroughly profile the codebase and experiment with some performance improvements.

#### Analysis of the problem

The part of the code that was causing a slowdown was related to updating documents. Per the CouchDB spec, whenever a document is updated, we need to merge its [revision tree](https://wiki.apache.org/couchdb/Replication_and_conflicts) with that of the previous version. However, the merge algorithm was not very optimized, so PouchDB was spending a lot of time in JavaScript just traversing through tree structures, as well as allocating unnecessary memory along the way.

The most shocking illustration of the slowdown came when we ran performance tests using the in-memory adapter. Most of the time, PouchDB is bound by the underlying storage engine (LevelDB, IndexedDB, and WebSQL), but in this case even the in-memory adapter was chugging along much too slowly.

#### The fix is in

The fix involved some major overhauls to the merge algorithm:

* Use [well-known JavaScript optimization techniques](https://github.com/petkaantonov/bluebird/wiki/Optimization-killers), such as removing functions-within-functions and preferring `for` loops to `forEach()`.
* Where possible, cache the calculated metadata values such as the winning revision and whether or not the winner was deleted.
* Simplify PouchDB's `extend()` and `clone()` methods, removing our [long-in-the-tooth jQuery version](https://github.com/pouchdb/pouchdb-extend).
* Use less memory by avoiding `extend()` and `clone()` entirely when we don't need them.

Of course, these improvements were justified by data! The Chrome [Dev Tools profiler](https://github.com/pouchdb/pouchdb/pull/4183#issue-102570121) and [Node.js flame graphs](https://github.com/pouchdb/pouchdb/pull/4185#issuecomment-133856702) are a performance junkie's best friends.

#### Measuring the fix

To determine how much we improved over PouchDB v4.0.0, I ran the [basic-updates test](https://github.com/pouchdb/pouchdb/blob/677450f58d1deb84039a15fb5180fbb2393dd81c/tests/performance/perf.basics.js#L39-L57) with 200 iterations, meaning that it inserted 100 documents and updated them 200 times. All numbers are in milliseconds, and were recorded on a 2013 MacBook Pro running OS X Yosemite.

<div class="table-responsive">
<table class="table">
<tr>
    <th></th>
    <th>v4.0.0</th>
    <th>v4.0.1</th>
    <th>Improvement</th>
</tr>
<tr>
<tr><th>Safari 9.0 (WebSQL)</th><td>24867</td><td>17232</td><td>30.70%</td></tr>
<tr><th>Firefox 40 (IndexedDB)</th><td>50519</td><td>26265</td><td>48.01%</td></tr>
<tr><th>Chrome 44 (IndexedDB)</th><td>49613</td><td>26667</td><td>46.25%</td></tr>
<tr><th>Chrome 44 (WebSQL)</th><td>46336</td><td>26358</td><td>43.12%</td></tr>
<tr><th>iojs 2.1.0 (LevelDB via LevelDOWN)</th><td>37593</td><td>15426</td><td>58.97%</td></tr>
<tr><th>iojs 2.1.0 (in-memory via MemDOWN)</th><td>33908</td><td>11433</td><td>66.28%</td></tr>
</tr>
</table>
</div>

Note that these numbers don't apply to PouchDB as a whole &ndash; for instance, you can't really say "PouchDB is now 46% faster in Chrome." This test applies to a very specific part of the codebase (updating documents), so basic reads, writes, and secondary indexes will be largely unaffected.

Just for fun, I also ran the above performance test against CouchDB 1.6.1, over HTTP. Surprisingly it finished in 10956 milliseconds, which is even faster than our in-memory adapter! So clearly we've still got some work to do, and I encourage any JavaScript performance gurus to [run the tests](https://github.com/pouchdb/pouchdb/blob/master/TESTING.md#performance-tests) and lend a hand.

### A note on PouchDB performance

PouchDB is a very fast database, and I think it holds up well compared to alternatives. It's worth noting, though, that we have a lot of factors that make performance a challenge.

First off, PouchDB is optimized for syncing. This means that we have some complicated data structures (such as revision trees) that add overhead compared to databases that don't need to retain old or conflicting revisions of documents.

Second off, PouchDB supports multiple storage engines, and they have different performance characteristics. For instance, `allDocs()` can be [40x slower in IndexedDB than in WebSQL](https://github.com/pouchdb/pouchdb/issues/3921#issuecomment-107954085) because joins and cursors are fairly slow in IndexedDB, whereas in WebSQL we can use one big SQL query to do it all.

There's been [some](http://discourse.wicg.io/t/indexeddb-2-0-performance-improvements/916) [discussion](http://discourse.wicg.io/t/indexeddb-api-clean-up-promises/876) in the W3C about improving IndexedDB performance, and [IndexedDB v2](http://w3c.github.io/IndexedDB/) offers some new methods like `getAll()` that could boost performance. However, this has limited value for PouchDB, because 1) it only solves half the problem (IndexedDB cursors being slow) while leaving the other half unresolved (joins being slow), and 2) methods like `getAll()` are only implemented in recent versions of Chrome and Firefox, so it would significantly complicate the codebase to support both versions.

Thirdly, PouchDB relies heavily on these underlying storage engines. This means that, when PouchDB gives you a callback after a `put()`, data has actually been written to disk, and when you do an `allDocs()`, PouchDB is actually progressively fetching data from disk. This disk-heavy model allows PouchDB to run well on low-memory devices (such as phones), but also means that it runs better when the storage engine provides better tools, which is why WebSQL is still faster than IndexedDB for us.

#### What you can do about performance

Here are some tips to get the best performance out of PouchDB:

* Don't update your documents too many times. For instance, if you're writing a text editor, don't update the document for every keystroke; set a [debounce](http://underscorejs.org/#debounce), or allow the user to explicitly save.
* Don't continually read the entire database in and out of memory; use [pagination]({{ site.baseurl }}/2014/04/14/pagination-strategies-with-pouchdb.html) and [the changes feed]({{ site.baseurl }}/2015/02/28/efficiently-managing-ui-state-in-pouchdb.html).
* Prefer `allDocs()` to either `query()` or `pouchdb-find`. Building up secondary indexes [is expensive]({{ site.baseurl }}/guides/queries.html).

If you are not using PouchDB's sync capabilities, or if you require complicated queries (such as full-text search) on a large set of data (>1000 documents), I would also advise looking into other databases. PouchDB is designed for sync and it excels at that, but if you have different needs, then you should explore other libraries.

For instance, databases like [LocalForage](https://mozilla.github.io/localForage/), [Dexie](http://www.dexie.org/),
[Lovefield](https://google.github.io/lovefield/), and [YDN-DB](http://dev.yathit.com/ydn-db/index.html) run in more-or-less the same browsers as PouchDB, but have a much simpler data model, where updated/removed data is simply overwritten. These databases are particularly good for quick storage, lookup, and querying. If you are not using sync, you will probably also appreciate the cognitive benefit of not having to think about `_rev`!

If you need even more sophisticated querying capabilities and don't require a low memory footprint, then you could also look into in-memory databases such as [AlaSQL](http://alasql.org/) and [LokiJS](http://lokijs.org/). These databases can periodically write data to a storage engine like IndexedDB, but are primarily queried via in-memory methods, meaning they can be much faster than PouchDB because they don't have to touch disk. On the other hand, they have a high memory footprint and may drop data unless you are careful to flush the in-memory representation to disk.

Make no mistake: PouchDB is committed to being the fastest JavaScript database it can be. However, our primary goal is correctness, especially when it comes to sync. (The [massive test suite](https://travis-ci.org/pouchdb/pouchdb) should be a testament to that.) Every design decision comes with tradeoffs, and our decisions are driven by the goal of providing a free, open-source database that 1) never drops data, 2) syncs like a champ, and 3) runs flawlessly in every modern browser. If PouchDB can do all that while being fast, then that's just icing on the cake!

### Get in touch

Please [file issues](https://github.com/pouchdb/pouchdb/issues) or [tell us what you think](https://github.com/pouchdb/pouchdb/blob/master/CONTRIBUTING.md#get-in-touch). And as always, a big thanks to all of our [new and existing contributors](https://github.com/pouchdb/pouchdb/graphs/contributors)!
