---
layout: post

title: PouchDB 4.0.0 - Ballast Overboard
author: Dale Harvey

---

> When discussing what features we should add,
> we should also discuss what to remove. - possibly Joe Armstrong

I can't remember or find the exact quote, but it was something along those lines. We try to maintain backwards compatibility as much as possible with PouchDB, however sometimes we need to let go of those features that just didn't work out like planned. We have previously marked quite a few things as deprecated, and in this 4.0.0 release we have finally removed them along with our usual slew of bugfixes, improvements and new features.

### Deprecations

* Remove `bluebird` and use `lie` as only `Promise` polyfill - ([#3839](https://github.com/pouchdb/pouchdb/issues/3839))

We previously used `bluebird` as our `Promise` polyfill in node.js because it is a fast library. However `bluebird` contains a lot of non-standard `Promise` functionality, which authors could use and then have their code break in browsers as well as iojs and future versions of node.js, which have introduced a standard `Promise` implementation.

PouchDB will always use the globally available `Promise` object where available, so if you have only used standard `Promise` functionality, this change will not break anything. If you require the extra functionality provided by `bluebird`, then you can have PouchDB use it with

```js
global.Promise = require('bluebird');
````

* Remove `local_seq` - ([#4080](https://github.com/pouchdb/pouchdb/issues/4080))

This was a little-used functionality whose semantics are due to change in CouchDB 2.0.

* Remove `onChange` and `complete` callbacks - ([#4098](https://github.com/pouchdb/pouchdb/issues/4098))

These callbacks have long been replaced with the `EventEmitter`-style `changes()`, `replicate()` and `sync()` APIs, and are finally being removed. If you still have:

```js
db.changes({
  onChange: changeFun,
  complete: completeFun
});
```

You can replace them with:

```js
db.changes()
  .on('change', changeFun)
  .on('complete', completeFun);
```

* Remove `uptodate` event - ([#4100](https://github.com/pouchdb/pouchdb/issues/4100))

`uptodate` was an event introduced to indicate when a `live` replication had finished processing all current changes and was waiting on future changes. It has since been replaced by the `paused` event, which will do the same and additionally indicate whether the replication was paused due to an error. If you have:

```js
replication.on('uptodate', doneFun);
```

You can replace it with:

```js
replication.on('paused', doneFun);
```

### New features

* Return Blobs (or Buffers) in `get()` + `allDocs()` + `changes()` + `query()` with `{binary: true}` ([#2858](https://github.com/pouchdb/pouchdb/issues/2858))
* Allow chaining of plugin registration ([#3943](https://github.com/pouchdb/pouchdb/issues/3943))
* Allow option to raise timeouts in changes / replication ([#4022](https://github.com/pouchdb/pouchdb/issues/4022))
* Add direct edit button to website ([#3747](https://github.com/pouchdb/pouchdb/issues/3747))

### Bugfixes

* Fix attachment length for stubs ([#3963](https://github.com/pouchdb/pouchdb/issues/3963))
* Reduce the number of checkpoint mismatches ([#4009](https://github.com/pouchdb/pouchdb/issues/4009))
* Fallback from checkpoint mismatch correctly (less replication start from the beginning) ([#3999](https://github.com/pouchdb/pouchdb/issues/3999))
* Don't fail replication when attachment request fails ([#4021](https://github.com/pouchdb/pouchdb/issues/4021))
* Fix check for `localStorage` in Safari private mode ([#4070](https://github.com/pouchdb/pouchdb/issues/4070))

### Coverage improvements

* Large number of new tests and dead code removed to increase our [test coverage](https://coveralls.io/github/pouchdb/pouchdb/) - ([#4071](https://github.com/pouchdb/pouchdb/issues/4071))

### Get in touch

Please [file issues](https://github.com/pouchdb/pouchdb/issues) or [tell us what you think](https://github.com/pouchdb/pouchdb/blob/master/CONTRIBUTING.md#get-in-touch). And as always, a big thanks to all of our [new and existing contributors](https://github.com/pouchdb/pouchdb/graphs/contributors)!
