---
layout: post

title: PouchDB 3.6.0
author: Nolan Lawson

---

PouchDB 3.6.0 is a monthly release containing several bugfixes, most notably for "retry" replication and attachment replication. It also contains one minor new feature.

### New features

* `getAttachment()` now supports `rev` ([#3871](https://github.com/pouchdb/pouchdb/issues/3871))
* Add `androidDatabaseImplementation` option for the SQLite Plugin in Cordova ([#3835](https://github.com/pouchdb/pouchdb/issues/3835))

### Performance improvements

* Avoid `application/json` when `GET`ing remote documents with attachments. This makes the replicator and `get()`s on remote PouchDBs more efficient, by preferring to fetch the attachments directly in separate parallel requests. You may see a negative performance impact if you have many small attachments, in which case you should inline them instead of using attachments. However, "normal" attachment use cases should see a big improvement, because attachments are no longer sent over the wire as base64-encoded strings. This also improves support for syncing attachments in Couchbase Sync Gateway, which does not support the `application/json` format. ([#3870](https://github.com/pouchdb/pouchdb/issues/3870))
* Similarly, for uploading of documents with attachments, use the `multipart/related` format rather than `application/json`, because it is more efficient. This also improves Couchbase Sync Gateway support. ([#3876](https://github.com/pouchdb/pouchdb/issues/3876))
* Avoid using `readAsBinaryString` when `readAsArrayBuffer` is more direct ([#3877](https://github.com/pouchdb/pouchdb/issues/3877))
* Better bit-twiddling in the md5 checksum ([#3878](https://github.com/pouchdb/pouchdb/issues/3878))

### Bugfixes

* Fix EventEmitter memory leaks in retry replication (#3858 #3699)
* Fix retry replication when started offline ([#3768](https://github.com/pouchdb/pouchdb/issues/3768))
* Fixes for `fetch()` in Service Workers on Chrome 41 ([#3885](https://github.com/pouchdb/pouchdb/issues/3885))
* Fix a race condition when retry replication is immediately canceled ([#3894](https://github.com/pouchdb/pouchdb/issues/3894))

### Test infrastructure

* Fuzzy replication tests ([#3767](https://github.com/pouchdb/pouchdb/issues/3767))
* Test multiple versions of Node/io.js ([#3843](https://github.com/pouchdb/pouchdb/issues/3843))
* BlackBerry Cordova tests (#3818 #3845)

### Get in touch

Please [file issues](https://github.com/pouchdb/pouchdb/issues) or [tell us what you think](https://github.com/pouchdb/pouchdb/blob/master/CONTRIBUTING.md#get-in-touch). And as always, a big thanks to all of our [new and existing contributors](https://github.com/pouchdb/pouchdb/graphs/contributors)!
