---
layout: post

title: PouchDB 3.2.1&#58; You can always be faster

author: Nolan Lawson

---

A humble release to ring in the new year, PouchDB 3.2.1 is focused on bugfixes and performance improvements. In particular, 3.2.1 boasts some critical fixes for IE11 and node-webkit, as well as a fix for replication of conflicted documents.

{% include alert/start.html variant="warning"%}
This release contains a database migration, which means that once you upgrade you will no longer be able to use previous versions of PouchDB on the same databases.
{% include alert/end.html %}

### Gotta go fast

For performance, the biggest gains will be seen in secondary indexes and auto-compaction. Auto-compaction now occurs in the same transaction as `bulkDocs`, which speeds up the build time for secondary indexes (since they use auto-compaction under the hood). This also means that [pouchdb-quick-search](https://github.com/nolanlawson/pouchdb-quick-search) will be faster.

In addition, the LevelDB adapter now makes all its `bulkDocs` writes inside a single `batch` operation. This means that PouchDB can now provide the same consistency guarantees in both Node.js and the browser, since the LevelDB adapter is using the same transactional model as IndexedDB and WebSQL. Also, using a single `batch` boosts the write performance of LevelDB.

A performance comparison between 3.2.0 and 3.2.1 can be found in [this report](https://gist.github.com/nolanlawson/bc6fd6240db820a36a49). The build times for secondary indexes have been reduced by 37%-57%, depending on the browser and environment.

### CouchDB 2.0 is coming

A big shout-out this release goes to [Will Holley](https://github.com/willholley), who has been tirelessly fixing bugs in the PouchDB test suite so that it can pass against CouchDB master. Not only does this improve PouchDB's test coverage against Cloudant, but it also better prepares us for the (soonish!) release of CouchDB 2.0. Thanks, Will!

### PouchDB Server is getting awesome

And if you haven't checked out [PouchDB Server](https://github.com/pouchdb/pouchdb-server/) or [express-pouchdb](https://github.com/pouchdb/express-pouchdb) recently, you'll be pleased to see that [Marten de Vries](https://github.com/marten-de-vries) has made a ton of improvements over there, including cleaner configuration via `config.json`, authentication support, a `--proxy` option, CouchDB-style logging, "modes" to choose different CouchDB server features, and more. Just `$ npm install -g pouchdb-server && pouchdb-server` to try it out!

### Full changelog:

#### Bugfixes

* `leveldown` is now an optional dependency in Node.js due to build issues with Windows ([#3113](https://github.com/pouchdb/pouchdb/issues/3113))
* Avoid call stack exceeded errors in the merge algorithm ([#2543](https://github.com/pouchdb/pouchdb/issues/2543))
* Properly destroy MemDOWN-based databases ([#3144](https://github.com/pouchdb/pouchdb/issues/3144))
* Avoid "too many listeners" errors in `changes()` ([#2867](https://github.com/pouchdb/pouchdb/issues/2867))
* Non-winning conflicts properly replicated ([#3136](https://github.com/pouchdb/pouchdb/issues/3136))
* Fixes for node-webkit ([#3229](https://github.com/pouchdb/pouchdb/issues/3229))
* LevelDB uses a read queue to prevent database corruption ([#3251](https://github.com/pouchdb/pouchdb/issues/3251))
* Can build and test on Windows ([#2143](https://github.com/pouchdb/pouchdb/issues/2143))
* Avoid http header error in IE11 ([#3278](https://github.com/pouchdb/pouchdb/issues/3278))
* Blobs are stored more efficiently in Chrome 38+ ([#3326](https://github.com/pouchdb/pouchdb/issues/3326) [#3325](https://github.com/pouchdb/pouchdb/issues/3325))
* Many fixes to the test suite to better support CouchDB master ([#136](https://github.com/pouchdb/pouchdb/issues/136))
* Fix replication when `skipSetup` is true ([#2915](https://github.com/pouchdb/pouchdb/issues/2915))
* Fixes for webpack ([#3287](https://github.com/pouchdb/pouchdb/issues/3287))
* `auto_compaction` is correctly reported in `info()` ([#3345](https://github.com/pouchdb/pouchdb/issues/3345))

#### Performance improvements

* Replication doesn't make unnecessary `allDocs()` calls ([#3153](https://github.com/pouchdb/pouchdb/issues/3153))
* Replication GET requests issued in parallel ([#3015](https://github.com/pouchdb/pouchdb/issues/3015))
* Auto-compaction occurs in same transaction as writes ([#3089](https://github.com/pouchdb/pouchdb/issues/3089))
* Formal one-time IndexedDB migration, cleaner schema ([#3211](https://github.com/pouchdb/pouchdb/issues/3211), [#3182](https://github.com/pouchdb/pouchdb/issues/3182))
* IndexedDB doesn't store duplicated id/rev ([#3213](https://github.com/pouchdb/pouchdb/issues/3213))
* Fall back from JSON to vuvuzela to improve parse/stringify ([#3188](https://github.com/pouchdb/pouchdb/issues/3188))
* LevelDB makes changes in a single batch ([#1738](https://github.com/pouchdb/pouchdb/issues/1738))

### Get in touch

Please [file issues](https://github.com/pouchdb/pouchdb/issues) or [tell us what you think](https://github.com/pouchdb/pouchdb/blob/master/CONTRIBUTING.md#get-in-touch). And as always, a big thanks to all of our [new and existing contributors](https://github.com/pouchdb/pouchdb/graphs/contributors)!
