---
layout: post

title: PouchDB 3.2.0&#58; To code is human, to debug is divine

author: Nolan Lawson

---

Hot on the heels of the last release, we present [3.2.0](https://github.com/pouchdb/pouchdb/releases/tag/3.2.0), which has new features to increase developer productivity, as well as a slew of bugfixes.


### New features

* Finally, PouchDB has a [debug mode][]! ([#2874][], [#3084][])
* You can now use `{attachments: true}` to fetch attachments in `allDocs()`, `changes()`, and `query()`, just like CouchDB 1.6.0+ ([#2771][], [#3074][], [#190][])
* The `doc_ids` filter is now supported for `changes()` ([#3056][])

### Bugfixes

* Fix conflict during replication of deleted documents ([#2970][])
* Only detect blob support once ([#2990][])
* Fix tree-merging algorithm, correctly attach docs to deleted winning revs ([#2888][])
* Fix compaction-related race condition in LevelDB ([#3026][])
* Fix LevelDB `bulkDocs()` ordering ([#3062][])
* Fix WebSQL `put()` local docs when missing ([#3066][])
* Fix encoding of base64-string attachments over HTTP ([#3008][])
* Better error for invalid revs ([#2994][])
* Upgrade Browserify to v6 ([#2884][])


### In related news

* [Hoodie &#9829; PouchDB](https://github.com/hoodiehq/wip-hoodie-store-on-pouchdb) (and the feeling is mutual)
* [crypto-pouch](https://github.com/calvinmetcalf/crypto-pouch), a plugin to encrypt a CouchDB/PouchDB database
* [Porting Node.js crypto to the browser, part 1](http://calvinmetcalf.com/post/104082905653/porting-node-js-crypto-to-the-browser-part-1-all)
* [pouchdb-express-router](https://github.com/daleharvey/pouchdb-express-router), the minimum required to replicate PouchDB to an Express server (which will eventually be folded into express-pouchdb and pouchdb-server)
* [PouchDB performance report for November 2014](https://github.com/nolanlawson/pouchdb-perf-report-3.10#readme)

Please [file issues](https://github.com/pouchdb/pouchdb/issues) or [tell us what you think](https://github.com/pouchdb/pouchdb/blob/master/CONTRIBUTING.md#get-in-touch). And as always, a big thanks to our [new and existing contributors](https://github.com/pouchdb/pouchdb/graphs/contributors)!

[3.2.0]: https://github.com/pouchdb/pouchdb/releases/tag/3.2.0
[#2771]: https://github.com/pouchdb/pouchdb/issues/2771
[#3074]: https://github.com/pouchdb/pouchdb/issues/3074
[#2874]: https://github.com/pouchdb/pouchdb/issues/2874
[#3084]: https://github.com/pouchdb/pouchdb/issues/3084
[#3056]: https://github.com/pouchdb/pouchdb/issues/3056
[#2970]: https://github.com/pouchdb/pouchdb/issues/2970
[#2888]: https://github.com/pouchdb/pouchdb/issues/2888
[#3026]: https://github.com/pouchdb/pouchdb/issues/3026
[#3062]: https://github.com/pouchdb/pouchdb/issues/3062
[#3066]: https://github.com/pouchdb/pouchdb/issues/3066
[#3008]: https://github.com/pouchdb/pouchdb/issues/3008
[#2994]: https://github.com/pouchdb/pouchdb/issues/2994
[#2990]: https://github.com/pouchdb/pouchdb/issues/2990
[#2884]: https://github.com/pouchdb/pouchdb/issues/2884
[#190]: https://github.com/pouchdb/mapreduce/issues/190
[debug mode]: /api.html#debug_mode