---
layout: post

title: PouchDB 3.0.5&#58; Turtles All the Way Down

author: Nolan Lawson

---

Tonight our fine dining selection is [PouchDB 3.0.5](https://github.com/pouchdb/pouchdb/releases/tag/3.0.5), which fixes some issues with excessive recursion and also `PouchDB.sync` not always working correctly.

### PouchDB.sync un-borked ([#2735](https://github.com/pouchdb/pouchdb/issues/2735))

You can now call `PouchDB.sync('mydb', 'http://localhost:5984/mydb')` using just the database names.

Less typing === more win.

### No more infinite recursion ([#2543](https://github.com/pouchdb/pouchdb/issues/2543))

You can now have as many revisions to your documents as you want, and you'll no longer descend _Inception_-style into a "too much recursion" or "maximum call stack" error.

We literally wrote [a custom JSON parser](https://github.com/nolanlawson/vuvuzela) to fix this. That's how much we love you.

### Notes on excessive revision histories

The ["infinite recursion" bug](https://github.com/pouchdb/pouchdb/issues/2543) shows up when you have many (> 1000) revisions to the same document. For instance, imagine a text editor that `put()`s a new version of the document for every keystroke. This is fine in traditional databases, but it can be a big problem in PouchDB/CouchDB, because we store the entire history of the database.

Make no mistake: infinitely-large revision histories will now work in PouchDB 3.0.5. However, it's a lot like riding a bicycle without a helmet: you _can_ do it, but you probably shouldn't.

Your mental model for this can be something like Git. Imagine a new `git commit` for every keystroke, and you'll see why it might be a bit problematic.

```js
{ "text": "The quick brown fox jumps over the lazy doge." }
{ "text": "The quick brown fox jumps over the lazy doge" }
{ "text": "The quick brown fox jumps over the lazy dog" }
//
// 40 revisions earlier ...
//
{ "text": "The q" }
{ "text": "The " }
{ "text": "The" }
{ "text": "Th" }
{ "text": "T" }
```

Of course, you can always `compact()` to remove old versions, but this just removes the document data. PouchDB still needs to maintain a permanent tree of the `_rev` hashes in order for the replication algorithm to work properly. If this tree grows excessively, it can bloat your database, whether or not you do compaction.

What this means is that you should be very careful about updating your documents. Try to update your documents in larger batches, or use a pattern like [delta-pouch](https://github.com/redgeoff/delta-pouch) to avoid creating new revisions altogether.
