---
layout: post

title: PouchDB 3.0.0

author: Calvin Metcalf

---

[PouchDB 3.0.0](https://github.com/pouchdb/pouchdb/releases/tag/3.0.1) is finally released! It's faster, it's more stable, it's easier to debug, it doesn't freeze the DOM and it spontaneously generates kittens.

Please [file issues](https://github.com/pouchdb/pouchdb/issues) or [tell us what you think](https://github.com/pouchdb/pouchdb/blob/master/CONTRIBUTING.md#get-in-touch). We would also like to give a huge thanks to our [new and existing contributors](https://github.com/pouchdb/pouchdb/graphs/contributors?from=2014-06-01&to=2014-08-12).

{% include alert/start.html variant="warning"%}
This release includes a migration. Your existing database will be updated automatically, but you cannot downgrade to a previous version of PouchDB once you've upgraded.
{% include alert/end.html %}

### Breaking Changes:
* The browser build `pouchdb-nightly.js` has been renamed to `pouchdb.js`. It was never really a nightly anyway. ([#2146](https://github.com/pouchdb/pouchdb/issues/2146)) 
* `opts.server` has been deprecated from the `replicate()` and `sync()` APIs. You can still replicate from one HTTP server to another, but the data will flow through PouchDB rather than being server-initiated. ([#2313](https://github.com/pouchdb/pouchdb/issues/2313))
* You can no longer rely on errors to have an identifying name. Instead, rely on CouchDB-centric errors to have a status (i.e. `err.status` instead of `err.name`).  There are some that still have an identifying name, but **these could be removed at any time**. The upside of this is that stack traces should be more consistently helpful. ([#2545](https://github.com/pouchdb/pouchdb/issues/2545))

### Major Changes:

 * Constructor option `opts.size` to work around Safari/iOS storage quotas ([#2347](https://github.com/pouchdb/pouchdb/issues/2347))
 * `PouchDB.defaults()` for default constructor options, which permits many new features in pouchdb-server. ([#2054](https://github.com/pouchdb/pouchdb/issues/2054))
 *  `_local` documents are now unversioned in the underlying backend for better map/reduce performance and to better align the `update_seq` with CouchDB ([#2023](https://github.com/pouchdb/pouchdb/issues/2023)). Also fixes an issue with replication and `changes()`. ([#2342](https://github.com/pouchdb/pouchdb/issues/2342))
 * Performance improvements. ([#2391](https://github.com/pouchdb/pouchdb/issues/2391), [#2392](https://github.com/pouchdb/pouchdb/issues/2392), [#2393](https://github.com/pouchdb/pouchdb/issues/2393))
 * MD5 hashes are now calculated incrementally in a way that won't freeze the DOM. ([#445](https://github.com/pouchdb/pouchdb/issues/445), [#2497](https://github.com/pouchdb/pouchdb/issues/2497))
 * More efficient replication. ([#2466](https://github.com/pouchdb/pouchdb/issues/2466), [#2475](https://github.com/pouchdb/pouchdb/issues/2475))


### Bugfixes:

 * Fix for replication of multiple attachments. ([#2358](https://github.com/pouchdb/pouchdb/issues/2358))
 * Fix for `bulkDocs()` in Cloudant. ([#2365](https://github.com/pouchdb/pouchdb/issues/2365))
 * Fix read-only replication for CORS/40*. ([#2484](https://github.com/pouchdb/pouchdb/issues/2484))
 * Fix for reserved words in docs. ([#2477](https://github.com/pouchdb/pouchdb/issues/2477))
 * Fixes for `change` events in `.sync()`. ([#2555](https://github.com/pouchdb/pouchdb/issues/2555))
 * Fixes for race condition in bulk docs with `new_edits=false` in LevelDB. ([#2574](https://github.com/pouchdb/pouchdb/issues/2574))
 * Fixes for `opts.stale` in `query()`. ([pouchdb/mapreduce#196](https://github.com/pouchdb/mapreduce/issues/196), [pouchdb/mapreduce#198](https://github.com/pouchdb/mapreduce/issues/198))

###### [Complete list of changes](https://github.com/pouchdb/pouchdb/compare/2.2.3...3.0.0)
