#include <plasp/sas/InitialState.h>

namespace plasp
{
namespace sas
{

////////////////////////////////////////////////////////////////////////////////////////////////////
//
// InitialState
//
////////////////////////////////////////////////////////////////////////////////////////////////////

InitialState InitialState::fromSAS(tokenize::Tokenizer<> &tokenizer, const Variables &variables)
{
	InitialState initialState;

	tokenizer.expect<std::string>("begin_state");

	initialState.m_facts.reserve(variables.size());

	for (size_t i = 0; i < variables.size(); i++)
		initialState.m_facts.emplace_back(Fact::fromSAS(tokenizer, variables[i]));

	tokenizer.expect<std::string>("end_state");

	return initialState;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

const InitialState::Facts &InitialState::facts() const
{
	return m_facts;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

}
}
