# Packages

## Official "3rd party" Packages

The Pony Developers maintain a number of packages that exist outside of the standard library that you can utilize. Each of the packages is tested nightly to make sure it works with the latest Pony compiler builds.

While the packages are maintained by us, we welcome contributions from the community at large. If you'd like to discuss contributing to any of the packages, please stop by the [contribute to Pony stream](https://ponylang.zulipchat.com/#narrow/stream/192795-contribute-to-Pony).

### [appdirs](https://github.com/ponylang/appdirs)

Package for getting platform-specific application directories e.g. directory for user-based config.

### [crypto](https://github.com/ponylang/crypto)

Package of common cryptographic algorithms and functions for Pony.

### [fork_join](https://github.com/ponylang/fork_join)

Pony parallel processing package.

### [github_rest_api](https://github.com/ponylang/github_rest_api)

Pony package for working with GitHub's REST API.

### [glob](https://github.com/ponylang/glob)

Pony package provides the ability find all pathnames matching a given pattern based on Unix shell rules.

### [http](https://github.com/ponylang/http)

HTTP client package.

### [http_server](https://github.com/ponylang/http_server)

Pony package for building HTTP server applications.

### [json](https://github.com/ponylang/json)

A JSON package for Pony.

### [logger](https://github.com/ponylang/logger)

A simple logging package for Pony.

### [lori](https://github.com/ponylang/lori)

Pony TCP classes reimagined.

### [net_ssl](https://github.com/ponylang/net_ssl)

SSL package for Pony.

### [peg](https://github.com/ponylang/peg)

A parsing expression grammar package for Pony.

### [postgres](https://github.com/ponylang/postgres)

Pure Pony Postgres driver.

### [reactive_streams](https://github.com/ponylang/reactive_streams)

Pony implementation of [http://www.reactive-streams.org/](http://www.reactive-streams.org/).

### [regex](https://github.com/ponylang/regex)

Perl compatible regular expression support for Pony.

### [semver](https://github.com/ponylang/semver)

A semantic versioning package for Ponylang.

### [templates](https://github.com/ponylang/templates)

A template engine for Pony.

### [valbytes](https://github.com/ponylang/valbytes)

Package to deal with multiple concatenated byte-arrays as if they were a single byte-array.

