# Getting Help

If you run into trouble while you are learning Pony, don't worry, we've got you covered. If you are looking for an answer "right now", we suggest you give our Zulip community a try. Whatever your question is, it isn't dumb, and we won't get annoyed. We only request that you follow proper etiquette:

- Be polite and respectful. Constructive criticism is good, but it's even more important that users get along and foster a welcoming community. Being rude won't get your questions answered.
- Be clear whether you are asking if something already exists in Pony (eg. "does Pony have X?"), or if you are requesting new functionality. We've received several messages asking about libraries or features present in other languages, by new users who weren't familiarized with Pony's philosophy or programming style well enough. Make sure that you understand what is your problem and if it makes sense in Pony's ecosystem, and clarify your intention of proposing a change. Baseless suggestions will be ignored.
- Don't rush experienced users for immediate answers. This is an all-volunteer project, and folks will help whenever they are available. Also, Zulip makes it easy to keep conversations of the same topic in one place, so you can check later to see if someone has answered your questions.

The [beginner help](https://ponylang.zulipchat.com/#narrow/stream/189985-beginner-help) stream is a good starting point for basic questions. If you need more information on what is considered appropriate or inappropriate behaviour, check out our [Code of Conduct](https://github.com/ponylang/ponyc/blob/main/CODE_OF_CONDUCT.md).

Many folks encounter the same issues or have the same questions, be sure to give the [frequently asked questions](/faq/index.md) section of this website a read.

Think you've found a bug? It's quite possible. Pony is a relatively young language that is still changing at a rapid pace and bugs do happen. Your best bet. Write to the mailing list with your issue and verify that you are experiencing an issue. Once a more knowledge member of the community confirms you are experiencing a bug, open an issue.

- [Open an issue](https://github.com/ponylang/ponyc/issues)

The Pony community while small is very helpful and inviting. We think you'll find interacting with us to be an enjoyable experience. You can find a lot more community-related resources in the [community section](/community/index.md) of this site.
