# Project Documentation

Documentation is the lifeblood of an Open Source project. It makes it easier to get new users up and running with the language. Our ability to grow Pony usage will be directly tied to the quality and breadth of our documentation. Assisting with adding documentation for Pony is a great way to get started helping out with Pony.

## Standard Library Documentation Improvements

* Add documentation in the form of docstrings to the standard libraries
* Add examples of usage to package level docstrings

## Ponylang Packages Documentation Improvements

The Pony Developers [maintain a number of packages](/use/packages.md) that exist outside of the standard library. Contributions to their documentation are greatly appreciated.

## Improving Examples

The examples that come with Pony are often not idiomatic. One of the ways people are going to learn is to copy code from examples into what they are trying to accomplish. It behooves us to make sure that the examples are of the highest quality. Idiomatic, with comments, without performance anti-patterns etc. We need to undertake a general cleanup of existing examples and writing up a guide for people looking to contribute other examples.

## Improving the Tutorial

There's plenty that people bring up as needing improvement/missing from the Tutorial. Check out [open issues](https://github.com/ponylang/pony-tutorial/issues) with a particular focus on those labelled with ["good first issue"](https://github.com/ponylang/pony-tutorial/issues?q=is%3Aissue+is%3Aopen+label%3A%22good+first+issue%22) and ["help wanted"](https://github.com/ponylang/pony-tutorial/issues?q=is%3Aissue+is%3Aopen+label%3A%22help+wanted%22).
