# Planet Pony

We don't have a Pony blog aggregator at the moment, so in the meantime, we have this manually edited stand in. It's like the [early curated days of Yahoo!](https://www.youtube.com/watch?v=TRAl48Ucgmw)

## 2024

* [Pony Programming Language with Sylvan Clebsch and Sean Allen -- Conversation #7](https://www.youtube.com/watch?v=_jhPREUmHJ4)
* [Pony Language - First Impression [Programming Languages Episode 34]](https://www.youtube.com/watch?v=LA9I6KiCIFA)
* [Developer Voices Interview- Pony: High-Performance, Memory-Safe Actors (with Sean Allen)](https://www.youtube.com/watch?v=u9da3UzEhEI)

## 2022

* [Pony VUG #13: An informal tour of the Pony backpressure system](https://vimeo.com/707155973)
* [Pony VUG #12: Exploration of a bug](https://vimeo.com/695067236)

## 2021

* [Pony VUG #11: Pony via a GitHub REST API](https://vimeo.com/592434464)
* [Pony VUG #10: Pony vs. Rust - How they both drive you mad at compile time](https://vimeo.com/574893226)
* [Pony VUG #9: CastXML2Pony, Automatically(ish) building Pony libraries to wrap C-FFI calls](https://vimeo.com/563948627)

## 2020

* [Pony, Actors, Causality, Types, and Garbage Collection](https://www.infoq.com/presentations/pony-types-garbage-collection/)
* [Sean T. Allen informal Pony presentation to HFPUG](https://onedrive.live.com/?authkey=%21AOnX%2D5R9yRcUoB8&cid=87ADE037DC99854B&id=87ADE037DC99854B%2144222&parId=87ADE037DC99854B%211035&o=OneUp)
* [On Deny Capabilities for Safe, Fast Actors](https://www.seantallen.com/talks/deny-capabilities/)

## 2019

* Video: [Learn Pony with Brian and Sean: Episode 2](https://www.youtube.com/watch?v=wBzPIYgfbdo)
* Video: [Learn Pony with Brian and Sean: Episode 1](https://www.youtube.com/watch?v=ODelwNLePRA)
* Video: [Safely Sharing Data: Reference Capabilities in the Pony Programming
  Language](https://www.youtube.com/watch?v=u1JfYa413fY)
* Video: [Time to Pony up!: A tour of Pony](https://www.youtube.com/watch?v=WlGSpYFntUU)
* Video: [Run, actor, run](https://www.youtube.com/watch?v=tCa7WpHtkgM)
* Video: [The wide world of almost-actors: comparing Pony to BEAM languages](https://www.youtube.com/watch?v=_0m0_qtfzLs) and [slides (PDF)](https://www.codesync.global/uploads/media/activity_slides/0001/02/592b6c97090c38237ce1dab9a161c1350b9ca2ae.pdf)

## 2018

* Video: [Pony: How I learned to stop worrying and embrace an unproven technology](https://youtu.be/GigBhej1gfI) and [slides](https://speakerdeck.com/seantallen/pony-how-i-learned-to-stop-worrying-and-embrace-an-unproven-technology-oscon-2018)
* [Generating Pony Coverage Reports](https://blog.m7w3.de/pony-coverage.html)
* [Introduction to the Pony programming language](https://opensource.com/article/18/5/pony)
* [How to train your Pony: Introduction](https://web.archive.org/web/20241113083722/https://paul.lietar.net/2018/03/how-to-train-your-pony-introduction/)
* Video: [The Wide World of Actors or, Can I Have an Erlang Pony?](https://www.youtube.com/watch?v=uv-3ptTD8hg&feature=youtu.be) and also the [talk's slides (PDF)](https://github.com/slfritchie/wide-world-of-actors)
* Video: [Everyone gets a pony!](https://www.youtube.com/watch?v=e0197aoljGQ)

## 2017

* [Pony Considerations](https://gist.github.com/aturley/49b60c98306d90ffc2f981515827b005)
* Video: [Pony - A Language for Provably Safe Lockless Concurrency (Øredev Malmö)](https://vimeo.com/242214036)
* Slides: [Pony - A Language for Provably Safe Lockless Concurrency (Øredev Malmö)](https://github.com/jemc/slides-pony)
* Video: [Dr. Strangecode or: How I Learned to Stop Worrying and Love the Type System.](https://www.youtube.com/watch?v=vVheDbrQBDk)
* Video: [Pony: How I learned to stop worrying and embrace an unproven technology (QCon New York)](https://www.infoq.com/presentations/pony-wallaroo)
* Slides: [Pony: How I learned to stop worrying and embrace an unproven technology (QCon New York)](https://speakerdeck.com/seantallen/pony-how-i-learned-to-stop-worrying-and-embrace-an-unproven-technology)
* Pony: Actors and Objects from [PLISS'17](https://pliss2017.github.io/index.html). [Part 1](https://www.youtube.com/watch?v=FSu8mBm3iJs). [Part 2](https://www.youtube.com/watch?v=ypCF34YVtRE).
* Slides: [Why Pony? Bleeding edge technology for your concurrency woes (Polyconf'17)](https://speakerdeck.com/seantallen/why-pony)
* [Reference Capabilities, Consume and Recover in Pony](https://bluishcoder.co.nz/2017/07/31/reference_capabilities_consume_recover_in_pony.html)
* [The Promise of Pony's Future](https://medium.com/@KevinHoffman/the-promise-of-ponys-future-44040a0b64ff)
* [Rolling the Dice with Pony](https://medium.com/@KevinHoffman/rolling-the-dice-with-pony-b7a32a69267b)
* [Composition over Inheritance in Pony](https://medium.com/@KevinHoffman/composition-over-inheritance-in-pony-33bbe107914)
* [My First Pony](/blog/posts/myfirstpony-kh.md)
* InfoQ podcast interview with Sylvan Clebsch - [Pony Language Designer Sylvan Clebsch on Pony’s Design, Garbage Collection, and Formal Verification](https://www.infoq.com/podcasts/sylvan-clebsch-pony-formal-verification)
* [Pony: 714 Days Later (Curry On Barcelona)](https://www.youtube.com/watch?v=HGDSnOZaU7Y)
* [What's Next for Our Programming Languages? (QCon London)](https://www.infoq.com/presentations/panel-languages-future)
* [Pony: Co-designing a Type-system and a Runtime (QCon London)](https://www.infoq.com/presentations/pony-type-system)
* [An Early History of Pony](/blog/posts/early-history-of-pony.md)
* [Pony VUG #8: Andrew Turley: Prime Cuts: The Best Pieces Of Pony](https://vimeo.com/202387915)
* [Découverte du langage Pony](https://zestedesavoir.com/articles/1329/decouverte-du-langage-pony/)

## 2016

* [Pony Capabilities made simple](https://soyyomakesgames.wordpress.com/2016/10/10/ponys-capabilities-made-simple/)
* [Pony VUG #7: Nick Pruhs: Designing an Actor Model Game Architecture with Pony](https://vimeo.com/187451870)
* [Pony - A Language for Provably Safe Lockless Concurrency](https://www.youtube.com/watch?v=_nDQ38v0fdU)
* [Pony: Co-Designing a Type System and a Runtime](https://www.youtube.com/watch?v=R6T8ytKV6dc)
* [Pony VUG #6: Andrew Turley: The Art of Forgetting - Garbage Collection in Pony](https://vimeo.com/181099993)
* [Reference Capabilities in Pony for everybody](https://zartstrom.github.io/pony/2016/08/28/reference-capabilities-in-pony.html)
* [Pony VUG #5: George Steed: A Principled Design of Capabilities in Pony](https://vimeo.com/178522513)
* [Pony VUG #4: Simple Value-Dependent Types in Pony](https://vimeo.com/175746403)
* [Borrowing in Pony](https://bluishcoder.co.nz/2016/07/18/borrowing-in-pony.html)
* [Push-parsing and Pony](http://maniagnosis.crsr.net/2016/07/push-parsing.html)
* [Pony VUG #3: The Actor Model and Pony](https://vimeo.com/172129187)
* [Pony VUG #2: Using the Pony FFI in Anger](https://vimeo.com/168247590)
* [Using Pony for FinTech](https://www.infoq.com/presentations/pony)
* [Using the Actor-model Language Pony for FinTech](http://www.infoq.com/news/2016/03/pony-fintech)
* [Exploring actors in Pony](https://bluishcoder.co.nz/2016/05/11/exploring-actors-in-pony.html)
* [Bang, Hat and Arrow in Pony](https://bluishcoder.co.nz/2016/05/04/bang-hat-and-arrow-in-pony.html)
* [Pony VUG #1: Writing Generic Code](https://vimeo.com/163871856)
* [Closures in Pony](https://bluishcoder.co.nz/2016/03/15/closures-in-pony.html)
* [Safely Sharing Data: Reference Capabilities in Pony](http://jtfmumm.com/blog/2016/03/06/safely-sharing-data-pony-reference-capabilities/)
* [the morning paper: Ownership and Reference Counting Based Garbage Collection in the Actor World](http://blog.acolyer.org/2016/02/18/ownership-and-reference-counting-based-garbage-collection-in-the-actor-world/)
* [the morning paper: Deny Capabilities for Safe, Fast Actors](http://blog.acolyer.org/2016/02/17/deny-capabilities/)

## 2015

* [Pony designer Sylvan Clebsch on the Actor-Model Language Pony, Garbage Collection, Capabilities, Concurrency](http://www.infoq.com/interviews/clebsch-pony)
* [Inside the Pony TCP Stack](http://www.monkeysnatchbanana.com/2015/12/19/inside-the-pony-tcp-stack/)
* [Cross compile Pony programs for Android](https://bluishcoder.co.nz/2015/12/17/cross-compile-pony-programs-for-android.html)
* [C linkable libraries with Pony](https://bluishcoder.co.nz/2015/12/16/c-linkable-libraries-with-pony.html)
* [Deconstructing a Pony echo server](http://www.monkeysnatchbanana.com/2015/12/13/deconstructing-a-pony-echo-server/)
* [Presentation slides for "My Little Pony" talk at CodeMesh 2015 in London](https://cdn.rawgit.com/darach/my_little_pony/master/my-little-pony.html)
* [A quick look at the Pony Programming Language](https://bluishcoder.co.nz/2015/11/04/a-quick-look-at-pony.html)
* [Presentation slides for "Deny Capabilities for Safe, Fast Actors" paper on Pony type system at Agere 2015 in Pittsburgh](http://cdn.rawgit.com/sylvanc/pony-lecture/master/agere2015.html)
* [Part two of "Actor-based programming in Pony" at Imperial Programming Lectures in London](https://panopto.imperial.ac.uk/Panopto/Pages/Viewer.aspx?id=2e47f3d3-95e1-45c9-97fd-a9e4f35c66b3)
* [Part one of "Actor-based programming in Pony" at Imperial Programming Lectures in London](https://panopto.imperial.ac.uk/Panopto/Pages/Viewer.aspx?id=aba3f8f7-f050-447c-91c9-61e092d61e85)
* [Video of CurryOn presentation on Pony at ECOOP 2015](https://www.youtube.com/watch?v=KvLjy8w1G_U)
* [Video of Pony talk at TNG Big Tech Day 2015](https://www.bigtechday.com/en/look-back/big-techday/8#3aykiSD5zpvRQ0DzSETrAy)
* [Pony presentation by Prof. Sophia Drossopoulou at the IFIP WG 2.16 (Programming Language Design)](http://www.doc.ic.ac.uk/~scd/Pony-WG2.16.pdf)
