---
authors:
  - seantallen
categories: ["State of the Stable"]
date: 2016-03-12T12:48:57-04:00
draft: false
title: "State of the Stable 2016"
---
Hi there and welcome to the summary of the Pony 2016 "State of the Stable" community survey. It was the first of what will hopefully become an annual tradition. We'd like to thank everyone who took time to answer the survey, especially those of you who took the time to answer the free form questions. There are some very thoughtful answers sprinkled through there. Also a big thank you to everyone who let us know they appreciate the work we are doing. Open source software is often a thankless task and your words of encouragement mean a lot.
<!-- more -->

We asked far more questions this year than we plan to ask in the future. In large part, because there were several basic questions that wanted to get answered. If you visit the [Wufoo report](https://seantallen.wufoo.com/reports/state-of-the-stable/), you can see the answers to all the multiple choice questions as well as download the complete data set.

## Highlights

Almost 49% of respondents said they were planning on doing web development with Pony. We didn't see this coming at all. It was quite a surprise. That simple "you could write an HTTP server" in Pony looks like it needs to be replaced by the real thing.

Respondents tend to have a lot of programming experience. Over 70% have more than 10 years of experience while less than 5% have less than 5 years experience. Our first reaction was "that makes sense, people with more experience are more likely to have experienced the pain that other concurrency models can create". However, we also started to wonder how much of that is selection bias. Is there a way that we can market Pony that would appeal to people with less experience? They core Pony team has a lot of experience and we might be unintentionally appealing to people like us. It's something we are looking at.

There's a lot of dynamic languages showing up in the languages that people are using. How many users are using just dynamic languages? Turns out it’s only a couple of respondents. However, there are a few others who appear to be primarily using dynamic languages with a static one thrown in. In general, you appear to be a pretty polyglot group. There's no "one language" that Pony is drawing a lot of interest from, it's pretty spread out. To address that, we are looking at doing "Pony for Erlangers", "Pony for C++ users", "Pony for Rubyists" etc intro docs.

The vast majority of respondents (over 70%) are just checking out the language. Hopefully we can pull some of those people in as full time users. Based on some of the free form feedback, we know that there are areas of the documentation that we need to address in order to do that. That 18% of you said that you are using Pony for serious hobby projects was a really big boost to our morale. It means a lot to know people are doing "real work" with our creation. One side note from Sean, it's obvious that his coworkers didn't fill out the survey otherwise there'd be several more "I use it at work" entries. Consider yourself shamed if you work with him.

Documentation... well, thanks folks. You said nicer things about the Pony documentation than we do. That said, a lot of the free form feedback was focused on documentation. In particular, documentation around reference capabilities. We have work underway to address documentation and it will be a point of emphasis going forward. Hopefully by the end of the year, we'll have some awesome, beginner friendly documentation that will rival the languages that some of you brought up as favorites (and to the people who brought up Rust and Elm compiler error friendliness as goals to shoot for: we heard you, it’s something that was already on the roadmap, but oh yeah, we heard you).

## Our message to you

Thank you for taking the time to give us feedback. It means a ton. This isn't meant to be a roadmap but we want to let you know that several of the issues you brought up are things we are working on including:

* Improved documentation/More examples
* Better packaging/easier installation
* Distributed Pony

We'd love your help. If you are interested in assisting, please join the [contribute to Pony stream in our Zulip community](https://ponylang.zulipchat.com/#narrow/stream/192795-contribute-to.20Pony) and [check out some of the ways that anyone can contribute](https://www.ponylang.io/contribute/).

See y'all next year,
The Pony core team
