---
title: "Types Specification"
sub_link: "specification/types"
meta_title: "Inputs/Outputs - Polyaxon Specification"
meta_description: "Each Component may have its own inputs and outputs. The inputs and outputs describe the expected parameters to pass to the component and their types. In the context of a DAG, inputs and outputs types are used to validate the flow of information going from one operation to another."
visibility: public
status: published
tags:
  - specification
  - api
  - polyaxon
  - yaml
  - json
  - python
sidebar: "core"
---

Polyaxon exposes several types for defining inputs and outputs. Some of these types are composite types, 
this section outlines the definition of the composite types.

## possible types

    * ANY: "any"
    * INT: "int"
    * FLOAT: "float"
    * BOOL: "bool"
    * STR: "str"
    * DICT: "dict"
    * DICT_OF_DICTS: "dict_of_dicts"
    * URI: "uri"
    * AUTH: "auth"
    * LIST: "list"
    * GCS: "gcs"
    * S3: "s3"
    * WASB: "wasb"
    * DOCKERFILE: "dockerfile"
    * GIT: "git"
    * IMAGE: "image"
    * EVENT: "event"
    * ARTIFACTS: "artifacts"
    * PATH: "path"
    * METRIC: "metric"
    * METADATA: "metadata"
    * DATE: "date"
    * DATETIME: "datetime" 

{{autogenerated}}
