---
title: "Vega"
meta_title: "Vega"
meta_description: "You can log and consume charts generated by [altair-viz](https://altair-viz.github.io/) or [Vega Lite](http://vega.github.io/vega-lite/) directly to Polyaxon."
custom_excerpt: "Plotly is a graphing library that makes interactive, publication-quality graphs. Examples of how to make line plots, scatter plots, area charts, bar charts, error bars, box plots, histograms, heatmaps, subplots, multiple-axes, polar charts, and bubble charts. "
image: "../../content/images/integrations/vega.png"
author:
  name: "Polyaxon"
  slug: "Polyaxon"
  website: "https://polyaxon.com"
  twitter: "polyaxonAI"
  github: "polyaxon"
tags:
  - tracking
  - visualizations
featured: false
popularity: 1
class_name: instruction
visibility: public
status: published
---

You can log and consume charts generated by [altair-viz](https://altair-viz.github.io/) or [Vega Lite](http://vega.github.io/vega-lite/) directly to Polyaxon.

## Tracking

You can log any chart generated by Altair using [Polyaxon's tracking module](/docs/experimentation/tracking/module/#log_altair_chart).

## Dashboard

Any chart that is logged during the lifetime of your jobs or experiments can be rendered automatically in [Polyaxon UI](/docs/experimentation/visualizations/custom/#altair).

## In notebooks

You can also consume any events or charts tracked in your experiments using the Python Library to [programmatically](/docs/experimentation/visualizations/programmatic/#single-run) visualize results in notebooks.

## Downloading events

All charts and events are stored on your artifacts store, and follow any networking or security policy you set for your cluster.
You can download any chart tracked to either render it manually or to archive it to a different location using the [Python Library](/docs/core/python-library/run-client/#get_events)

## Example

### Python script

```python
import altair as alt
from vega_datasets import data

from polyaxon import tracking

tracking.init()

source = data.cars()

brush = alt.selection(type='interval')

points = alt.Chart(source).mark_point().encode(
    x='Horsepower:Q',
    y='Miles_per_Gallon:Q',
    color=alt.condition(brush, 'Origin:N', alt.value('lightgray'))
).add_selection(
    brush
)

bars = alt.Chart(source).mark_bar().encode(
    y='Origin:N',
    color='Origin:N',
    x='count(Origin):Q'
).transform_filter(
    brush
)

chart = points & bars

tracking.log_altair_chart(name='altair_chart', figure=chart)
```

### Example as an executable component

```yaml
version: 1.1
kind: component
name: altair-chart
run:
  kind: job
  init:
    - file:
        filename: script.py
        content: |
          import altair as alt
          from vega_datasets import data
  
          from polyaxon import tracking
  
          tracking.init()
  
          source = data.cars()
          brush = alt.selection(type='interval')
          points = alt.Chart(source).mark_point().encode(
              x='Horsepower:Q',
              y='Miles_per_Gallon:Q',
              color=alt.condition(brush, 'Origin:N', alt.value('lightgray'))
          ).add_selection(
              brush
          )
          bars = alt.Chart(source).mark_bar().encode(
              y='Origin:N',
              color='Origin:N',
              x='count(Origin):Q'
          ).transform_filter(
              brush
          )
          chart = points & bars
          tracking.log_altair_chart(name='altair_chart', figure=chart)
  container:
    image: 'polyaxon/polyaxon-examples:ml'
    workingDir: '{{ globals.artifacts_path }}'
    command: [python3, -u, script.py]
```

### Result

In the `dashboards` tab, create a new custom chart widget

![run-dashboards-altair](../../content/images/dashboard/runs/dashboards-altair.png)
