---
title: "Plotly"
meta_title: "Plotly"
meta_description: "You can log and consume charts generated by [Plotly](https://plotly.com/) directly to Polyaxon."
custom_excerpt: "Plotly is a graphing library that makes interactive, publication-quality graphs. Examples of how to make line plots, scatter plots, area charts, bar charts, error bars, box plots, histograms, heatmaps, subplots, multiple-axes, polar charts, and bubble charts."
image: "../../content/images/integrations/plotly.png"
author:
  name: "Polyaxon"
  slug: "Polyaxon"
  website: "https://polyaxon.com"
  twitter: "polyaxonAI"
  github: "polyaxon"
tags:
  - tracking
  - visualizations
featured: false
popularity: 1
class_name: instruction
visibility: public
status: published
---

You can log and consume charts generated by [Plotly](https://plotly.com/) directly to Polyaxon.

## Tracking

You can log any chart generated by Plotly using [Polyaxon's tracking module](/docs/experimentation/tracking/module/#log_plotly_chart).

## Dashboard

Any chart that is logged during the lifetime of your jobs or experiments can be rendered automatically in [Polyaxon UI](/docs/experimentation/visualizations/custom/#plotly).

## In notebooks

You can also consume any events or charts tracked in your experiments using the Python Library to [programmatically](/docs/experimentation/visualizations/programmatic/#single-run) visualize results in notebooks.

## Downloading events

All charts and events are stored on your artifacts store, and follow any networking or security policy you set for your cluster.
You can download any chart tracked to either render it manually or to archive it to a different location using the [Python Library](/docs/core/python-library/run-client/#get_events)

## Example

### Python script

```python
import plotly.express as px

from polyaxon import tracking

tracking.init()

df = px.data.tips()

fig = px.density_heatmap(df, x="total_bill", y="tip", facet_row="sex", facet_col="smoker")
tracking.log_plotly_chart(name="2d-hist", figure=fig, step=1)
```

### Example as an executable component

```yaml
version: 1.1
kind: component
name: plt-chart
run:
  kind: job
  init:
    - file:
        filename: script.py
        content: |
          import plotly.express as px
  
          from polyaxon import tracking
  
          tracking.init()
  
          df = px.data.tips()
  
          fig = px.density_heatmap(df, x="total_bill", y="tip",
          facet_row="sex", facet_col="smoker")
  
          tracking.log_plotly_chart(name="2d-hist", figure=fig)
  container:
    image: 'polyaxon/polyaxon-examples:ml'
    workingDir: '{{ globals.artifacts_path }}'
    command: [python3, -u, script.py]
```

### Result

In the `dashboards` tab, create a new custom chart widget

![run-dashboards-plotly](../../content/images/dashboard/runs/dashboards-plotly.png)
