---
title: "One Platform"
sub_link: "one-platform"
meta_title: "Single Platform - Polyaxon As A Single Platform For Machine Learning and Deep Learning Life Cycle"
meta_description: "Polyaxon is a single platform that does everything from accessing data to managing machine learning models. This provides more results, happier developers and data scientists, improved cycle times, and a great return on investment."
visibility: public
status: published
tags:
  - reference
---

## One platform

Polyaxon is a single platform that does everything from accessing data to managing machine learning models. This provides more results, happier developers and data scientists, improved cycle times, and a great return on investment.

Other solutions currently in the market offer a kit plane you have to assemble yourself, or lock-in solution with a rigid approach, Polyaxon is based on an open-source end-to-end opinionated platform with flexible and extensible interfaces.

## One access interface

Users on your teams have to access to one and only one platform to perform most of the operations needed to develop and manage ML models.
No time is wasted switching between platforms with different access interfaces.

Teams can set one high-level authorization for managing access to the different aspects of the platform.
This means that you set permissions once and everyone in your organization has the right access to every component.

One interface can have a major impact on distributing knowledge within and between teams, which will result in improving all your employees' productivity.

## One project interface

Polyaxon provides one interface for managing the lifecycle of your projects, with all needed components, steps, and plugins,
this gives Polyaxon all information needed at every step to expose the relevant context to users.
This allows natural, fast, and intuitive access to the needed information in an easy and optimal way.
Finally, the single project interface reduces information dissipation due to the nonexistent context switching, which results in more productivity.

## One on-boarding process

New team members only need to learn about a single, simple, and intuitive interface and tools. Our tools and documentation are integrated, non-dependent on other unestablished projects, and open-source.
This means that not only you don't have to write your own documentation, but you can contribute to make on-boarding your users, as well as anyone in the community a breeze.

## One deployment

Running Polyaxon means that you only need to install, maintain, scale, backup, network, and secure one deployment.
One deployment results in saving time from your developers, reduces risk, increases reliability, and lowers the bill.

## One upgrade

Features and plugins developed and maintained by Polyaxon are guaranteed to work properly after every upgrade.
Maintaining several different ad-hoc applications and components increase the complexity of your deployments,
and makes upgrades a complex process prone to errors and incompatibilities.

## One centralized database

Managing the state of an application is hard, so imagine what it means to manage several stateful applications with different scalability, migrations, and backup processes.
In addition to the non-necessary complexity, several applications plane will result in redundant, and eventually inconsistent, data.

Polyaxon comes with one database, PostgreSQL, providing you with one consistent source of truth about the state of your deployment, so you don't have to manually extract data or create a warehouse.

## One Vendor

You only have to deal with Polyaxon, while ensuring that you have access to an open-source ecosystem, instead of multiple vendors with different licensing and risk pointing to each-other.

If you decide to invest in an internal solution, you can base it on a tool you are already using, and you only need to learn one code base, which is open-source.
